/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.platform;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.physics2.ObstacleSprite;
import edu.cornell.gdiac.physics2.WheelObstacle;

public class Bullet
extends ObstacleSprite {
    public Bullet(float units, JsonValue settings, Vector2 pos, boolean right) {
        float offset = settings.getFloat("offset", 0.0f);
        int n = right ? 1 : -1;
        float s = settings.getFloat("size");
        float radius = s * units / 2.0f;
        this.obstacle = new WheelObstacle(pos.x + (offset *= (float)n), pos.y, s / 2.0f);
        this.obstacle.setDensity(settings.getFloat("density", 0.0f));
        this.obstacle.setPhysicsUnits(units);
        this.obstacle.setBullet(true);
        this.obstacle.setGravityScale(0.0f);
        this.obstacle.setUserData(this);
        this.obstacle.setName("bullet");
        float speed = settings.getFloat("speed", 0.0f);
        this.obstacle.setVX(speed *= (float)(right ? 1 : -1));
        this.debug = ParserUtils.parseColor(settings.get("debug"), Color.WHITE);
        this.mesh.set(-radius, -radius, 2.0f * radius, 2.0f * radius);
    }
}

