/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ScreenUtils;
import edu.cornell.cis3152.physics.InputController;
import edu.cornell.cis3152.physics.ObstacleGroup;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.TextLayout;
import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;
import edu.cornell.gdiac.util.PooledList;
import edu.cornell.gdiac.util.ScreenListener;
import java.util.Iterator;

public abstract class PhysicsScene
implements Screen {
    public static final int EXIT_QUIT = 0;
    public static final int EXIT_NEXT = 1;
    public static final int EXIT_PREV = 2;
    public static final int EXIT_COUNT = 180;
    protected AssetDirectory directory;
    protected OrthographicCamera camera;
    protected SpriteBatch batch;
    protected float width;
    protected float height;
    protected JsonValue constants;
    protected BitmapFont displayFont;
    private TextLayout goodMessage;
    private TextLayout badMessage;
    public static final int WORLD_VELOC = 6;
    public static final int WORLD_POSIT = 2;
    protected PooledList<ObstacleSprite> sprites = new PooledList();
    protected PooledList<ObstacleSprite> addQueue = new PooledList();
    private ScreenListener listener;
    protected World world;
    protected Rectangle bounds;
    protected Vector2 scale;
    protected boolean active;
    protected boolean complete;
    protected boolean failed;
    protected boolean debug;
    protected int countdown;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean value) {
        if (value) {
            this.countdown = 180;
        }
        this.complete = value;
    }

    public boolean isFailure() {
        return this.failed;
    }

    public void setFailure(boolean value) {
        if (value) {
            this.countdown = 180;
        }
        this.failed = value;
    }

    public boolean isActive() {
        return this.active;
    }

    public SpriteBatch getSpriteBatch() {
        return this.batch;
    }

    public void setSpriteBatch(SpriteBatch batch) {
        this.batch = batch;
    }

    protected PhysicsScene(AssetDirectory directory, String prefix) {
        this.directory = directory;
        this.constants = directory.getEntry(prefix + "-constants", JsonValue.class);
        JsonValue defaults = this.constants.get("world");
        this.scale = new Vector2();
        this.bounds = new Rectangle(0.0f, 0.0f, defaults.get("bounds").getFloat(0), defaults.get("bounds").getFloat(1));
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.displayFont = directory.getEntry("shared-retro", BitmapFont.class);
        this.goodMessage = new TextLayout();
        this.goodMessage.setFont(this.displayFont);
        this.goodMessage.setAlignment(33);
        this.goodMessage.setColor(Color.YELLOW);
        this.goodMessage.setText("VICTORY!");
        this.goodMessage.layout();
        this.badMessage = new TextLayout();
        this.badMessage.setFont(this.displayFont);
        this.badMessage.setAlignment(33);
        this.badMessage.setColor(Color.RED);
        this.badMessage.setText("FAILURE!");
        this.badMessage.layout();
        this.complete = false;
        this.failed = false;
        this.debug = false;
        this.active = false;
        this.countdown = -1;
    }

    @Override
    public void dispose() {
        if (this.world != null) {
            for (ObstacleSprite sprite : this.sprites) {
                Obstacle obj = sprite.getObstacle();
                obj.deactivatePhysics(this.world);
            }
        }
        this.sprites.clear();
        this.addQueue.clear();
        this.world.dispose();
        this.addQueue = null;
        this.sprites = null;
        this.bounds = null;
        this.scale = null;
        this.world = null;
        this.batch = null;
    }

    public void addQueuedObject(ObstacleSprite sprite) {
        assert (this.inBounds(sprite)) : "Object is not in bounds";
        this.addQueue.add(sprite);
    }

    protected void addSprite(ObstacleSprite sprite) {
        assert (this.inBounds(sprite)) : "Sprite is not in bounds";
        this.sprites.add(sprite);
        sprite.getObstacle().activatePhysics(this.world);
    }

    protected void addSpriteGroup(ObstacleGroup group) {
        for (ObstacleSprite sprite : group.getSprites()) {
            assert (this.inBounds(sprite)) : "Sprite is not in bounds";
            this.sprites.add(sprite);
        }
        group.activatePhysics(this.world);
    }

    public boolean inBounds(ObstacleSprite sprite) {
        Obstacle obj = sprite.getObstacle();
        boolean horiz = this.bounds.x <= obj.getX() && obj.getX() <= this.bounds.x + this.bounds.width;
        boolean vert = this.bounds.y <= obj.getY() && obj.getY() <= this.bounds.y + this.bounds.height;
        return horiz && vert;
    }

    public abstract void reset();

    public boolean preUpdate(float dt) {
        InputController input = InputController.getInstance();
        input.sync(this.bounds, this.scale);
        if (this.listener == null) {
            return true;
        }
        if (input.didDebug()) {
            boolean bl = this.debug = !this.debug;
        }
        if (input.didReset()) {
            this.reset();
        }
        if (input.didExit()) {
            this.pause();
            this.listener.exitScreen(this, 0);
            return false;
        }
        if (input.didAdvance()) {
            this.pause();
            this.listener.exitScreen(this, 1);
            return false;
        }
        if (input.didRetreat()) {
            this.pause();
            this.listener.exitScreen(this, 2);
            return false;
        }
        if (this.countdown > 0) {
            --this.countdown;
        } else if (this.countdown == 0) {
            if (this.failed) {
                this.reset();
            } else if (this.complete) {
                this.pause();
                this.listener.exitScreen(this, 1);
                return false;
            }
        }
        return true;
    }

    public abstract void update(float var1);

    public void postUpdate(float dt) {
        while (!this.addQueue.isEmpty()) {
            this.addSprite(this.addQueue.poll());
        }
        this.world.step(dt, 6, 2);
        Iterator<PooledList.Entry> iterator = this.sprites.entryIterator();
        while (iterator.hasNext()) {
            PooledList.Entry entry = iterator.next();
            ObstacleSprite sprite = (ObstacleSprite)entry.getValue();
            Obstacle obj = sprite.getObstacle();
            if (obj.isRemoved()) {
                obj.deactivatePhysics(this.world);
                entry.remove();
                continue;
            }
            obj.update(dt);
        }
    }

    public void draw(float dt) {
        ScreenUtils.clear(0.39f, 0.58f, 0.93f, 1.0f);
        this.batch.begin(this.camera);
        for (ObstacleSprite obj : this.sprites) {
            obj.draw(this.batch);
        }
        if (this.debug) {
            for (ObstacleSprite obj : this.sprites) {
                obj.drawDebug(this.batch);
            }
        }
        if (this.complete && !this.failed) {
            this.batch.drawText(this.goodMessage, this.width / 2.0f, this.height / 2.0f);
        } else if (this.failed) {
            this.batch.drawText(this.badMessage, this.width / 2.0f, this.height / 2.0f);
        }
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.camera == null) {
            this.camera = new OrthographicCamera();
        }
        this.camera.setToOrtho(false, width, height);
        this.scale.x = (float)width / this.bounds.width;
        this.scale.y = (float)height / this.bounds.height;
        this.reset();
    }

    @Override
    public void render(float delta) {
        if (this.active) {
            if (this.preUpdate(delta)) {
                this.update(delta);
                this.postUpdate(delta);
            }
            this.draw(delta);
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void show() {
        this.active = true;
    }

    @Override
    public void hide() {
        this.active = false;
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }
}

