/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics;

import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;

public abstract class ObstacleGroup {
    protected Array<ObstacleSprite> sprites = new Array();
    protected Array<Joint> joints = new Array();
    protected boolean active;

    public Iterable<ObstacleSprite> getSprites() {
        return this.sprites;
    }

    public Iterable<Joint> getJoints() {
        return this.joints;
    }

    protected ObstacleGroup() {
    }

    public boolean activatePhysics(World world) {
        this.active = true;
        for (ObstacleSprite s : this.sprites) {
            Obstacle obj = s.getObstacle();
            this.active = this.active && obj.activatePhysics(world);
        }
        boolean bl = this.active = this.active && this.createJoints(world);
        if (!this.active) {
            this.deactivatePhysics(world);
        }
        return this.active;
    }

    public void deactivatePhysics(World world) {
        if (this.active) {
            for (Joint joint : this.joints) {
                world.destroyJoint(joint);
            }
            this.joints.clear();
            for (ObstacleSprite s : this.sprites) {
                Obstacle obj = s.getObstacle();
                obj.deactivatePhysics(world);
            }
            this.active = false;
        }
    }

    protected abstract boolean createJoints(World var1);
}

