/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.util.Controllers;
import edu.cornell.gdiac.util.XBoxController;

public class InputController {
    private static final float GP_ACCELERATE = 1.0f;
    private static final float GP_MAX_SPEED = 10.0f;
    private static final float GP_THRESHOLD = 0.01f;
    private static InputController theController = null;
    private boolean resetPressed;
    private boolean resetPrevious;
    private boolean nextPressed;
    private boolean nextPrevious;
    private boolean prevPressed;
    private boolean prevPrevious;
    private boolean primePressed;
    private boolean primePrevious;
    private boolean secondPressed;
    private boolean secondPrevious;
    private boolean tertiaryPressed;
    private boolean debugPressed;
    private boolean debugPrevious;
    private boolean exitPressed;
    private boolean exitPrevious;
    private float horizontal;
    private float vertical;
    private Vector2 crosshair;
    private Vector2 crosscache;
    private float momentum;
    XBoxController xbox;

    public static InputController getInstance() {
        if (theController == null) {
            theController = new InputController();
        }
        return theController;
    }

    public float getHorizontal() {
        return this.horizontal;
    }

    public float getVertical() {
        return this.vertical;
    }

    public Vector2 getCrossHair() {
        return this.crosscache.set(this.crosshair);
    }

    public boolean didPrimary() {
        return this.primePressed && !this.primePrevious;
    }

    public boolean didSecondary() {
        return this.secondPressed && !this.secondPrevious;
    }

    public boolean didTertiary() {
        return this.tertiaryPressed;
    }

    public boolean didReset() {
        return this.resetPressed && !this.resetPrevious;
    }

    public boolean didAdvance() {
        return this.nextPressed && !this.nextPrevious;
    }

    public boolean didRetreat() {
        return this.prevPressed && !this.prevPrevious;
    }

    public boolean didDebug() {
        return this.debugPressed && !this.debugPrevious;
    }

    public boolean didExit() {
        return this.exitPressed && !this.exitPrevious;
    }

    public InputController() {
        Array<XBoxController> controllers = Controllers.get().getXBoxControllers();
        this.xbox = controllers.size > 0 ? controllers.get(0) : null;
        this.crosshair = new Vector2();
        this.crosscache = new Vector2();
    }

    public void sync(Rectangle bounds, Vector2 scale) {
        this.primePrevious = this.primePressed;
        this.secondPrevious = this.secondPressed;
        this.resetPrevious = this.resetPressed;
        this.debugPrevious = this.debugPressed;
        this.exitPrevious = this.exitPressed;
        this.nextPrevious = this.nextPressed;
        this.prevPrevious = this.prevPressed;
        if (this.xbox != null && this.xbox.isConnected()) {
            this.readGamepad(bounds, scale);
            this.readKeyboard(bounds, scale, true);
        } else {
            this.readKeyboard(bounds, scale, false);
        }
    }

    private void readGamepad(Rectangle bounds, Vector2 scale) {
        this.resetPressed = this.xbox.getStart();
        this.exitPressed = this.xbox.getBack();
        this.nextPressed = this.xbox.getRBumper();
        this.prevPressed = this.xbox.getLBumper();
        this.primePressed = this.xbox.getA();
        this.debugPressed = this.xbox.getY();
        this.horizontal = this.xbox.getLeftX();
        this.vertical = this.xbox.getLeftY();
        this.secondPressed = this.xbox.getRightTrigger() > 0.6f;
        this.tertiaryPressed = this.xbox.getA();
        this.crosscache.set(this.xbox.getLeftX(), this.xbox.getLeftY());
        if (this.crosscache.len2() > 0.01f) {
            this.momentum += 1.0f;
            this.momentum = Math.min(this.momentum, 10.0f);
            this.crosscache.scl(this.momentum);
            this.crosscache.scl(1.0f / scale.x, 1.0f / scale.y);
            this.crosshair.add(this.crosscache);
        } else {
            this.momentum = 0.0f;
        }
        this.clampPosition(bounds);
    }

    private void readKeyboard(Rectangle bounds, Vector2 scale, boolean secondary) {
        this.resetPressed = secondary && this.resetPressed || Gdx.input.isKeyPressed(46);
        this.debugPressed = secondary && this.debugPressed || Gdx.input.isKeyPressed(32);
        this.primePressed = secondary && this.primePressed || Gdx.input.isKeyPressed(19);
        this.secondPressed = secondary && this.secondPressed || Gdx.input.isKeyPressed(62);
        this.prevPressed = secondary && this.prevPressed || Gdx.input.isKeyPressed(44);
        this.nextPressed = secondary && this.nextPressed || Gdx.input.isKeyPressed(42);
        this.exitPressed = secondary && this.exitPressed || Gdx.input.isKeyPressed(111);
        float f = this.horizontal = secondary ? this.horizontal : 0.0f;
        if (Gdx.input.isKeyPressed(22)) {
            this.horizontal += 1.0f;
        }
        if (Gdx.input.isKeyPressed(21)) {
            this.horizontal -= 1.0f;
        }
        float f2 = this.vertical = secondary ? this.vertical : 0.0f;
        if (Gdx.input.isKeyPressed(19)) {
            this.vertical += 1.0f;
        }
        if (Gdx.input.isKeyPressed(20)) {
            this.vertical -= 1.0f;
        }
        this.tertiaryPressed = Gdx.input.isButtonPressed(0);
        this.crosshair.set(Gdx.input.getX(), Gdx.input.getY());
        this.crosshair.scl(1.0f / scale.x, -1.0f / scale.y);
        this.crosshair.y += bounds.height;
        this.clampPosition(bounds);
    }

    private void clampPosition(Rectangle bounds) {
        this.crosshair.x = Math.max(bounds.x, Math.min(bounds.x + bounds.width, this.crosshair.x));
        this.crosshair.y = Math.max(bounds.y, Math.min(bounds.y + bounds.height, this.crosshair.y));
    }
}

