/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import edu.cornell.cis3152.physics.LoadingScene;
import edu.cornell.cis3152.physics.PhysicsScene;
import edu.cornell.cis3152.physics.platform.PlatformScene;
import edu.cornell.cis3152.physics.ragdoll.RagdollScene;
import edu.cornell.cis3152.physics.rocket.RocketScene;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.util.ScreenListener;

public class GDXRoot
extends Game
implements ScreenListener {
    AssetDirectory directory;
    private SpriteBatch batch;
    private LoadingScene loading;
    private int current;
    private PhysicsScene[] controllers;

    @Override
    public void create() {
        this.batch = new SpriteBatch();
        this.loading = new LoadingScene("assets.json", this.batch, 1);
        this.loading.setScreenListener(this);
        this.setScreen(this.loading);
    }

    @Override
    public void dispose() {
        this.setScreen(null);
        if (this.loading != null) {
            this.loading.dispose();
            this.loading = null;
        }
        if (this.controllers != null) {
            for (int ii = 0; ii < this.controllers.length; ++ii) {
                this.controllers[ii].dispose();
            }
            this.controllers = null;
        }
        this.batch.dispose();
        this.batch = null;
        if (this.directory != null) {
            this.directory.unloadAssets();
            this.directory.dispose();
            this.directory = null;
        }
        super.dispose();
    }

    @Override
    public void resize(int width, int height) {
        if (this.loading != null) {
            this.loading.resize(width, height);
        }
        if (this.controllers != null) {
            for (int ii = 0; ii < this.controllers.length; ++ii) {
                this.controllers[ii].resize(width, height);
            }
        }
    }

    @Override
    public void exitScreen(Screen screen, int exitCode) {
        if (screen == this.loading) {
            this.directory = this.loading.getAssets();
            this.loading.dispose();
            this.loading = null;
            this.controllers = new PhysicsScene[3];
            this.controllers[0] = new RocketScene(this.directory);
            this.controllers[1] = new PlatformScene(this.directory);
            this.controllers[2] = new RagdollScene(this.directory);
            for (int ii = 0; ii < this.controllers.length; ++ii) {
                this.controllers[ii].setScreenListener(this);
                this.controllers[ii].setSpriteBatch(this.batch);
            }
            this.current = 0;
            this.controllers[this.current].reset();
            this.setScreen(this.controllers[this.current]);
        } else if (exitCode == 1) {
            this.current = (this.current + 1) % this.controllers.length;
            this.controllers[this.current].reset();
            this.setScreen(this.controllers[this.current]);
        } else if (exitCode == 2) {
            this.current = (this.current + this.controllers.length - 1) % this.controllers.length;
            this.controllers[this.current].reset();
            this.setScreen(this.controllers[this.current]);
        } else if (exitCode == 0) {
            Gdx.app.exit();
        }
    }
}

