/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.util;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.util.XBoxController;

public class Controllers {
    private static Controllers singleton;
    private boolean active;

    private Controllers() {
        this(true);
    }

    private Controllers(boolean active) {
        this.active = active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public static Controllers get() {
        if (singleton == null) {
            singleton = new Controllers();
        }
        return singleton;
    }

    public Array<Controller> getControllers() {
        if (this.active) {
            try {
                return com.badlogic.gdx.controllers.Controllers.getControllers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Array();
    }

    public Array<XBoxController> getXBoxControllers() {
        Array xBoxControllers = new Array();
        if (this.active) {
            try {
                for (Controller controller : com.badlogic.gdx.controllers.Controllers.getControllers()) {
                    String name = controller.getName().toLowerCase();
                    if (!name.contains("xbox") && !name.contains("pc")) continue;
                    xBoxControllers.add((Object)new XBoxController(controller));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return xBoxControllers;
    }

    public void addListener(ControllerListener listener) {
        if (this.active) {
            try {
                com.badlogic.gdx.controllers.Controllers.addListener((ControllerListener)listener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeListener(ControllerListener listener) {
        if (this.active) {
            try {
                com.badlogic.gdx.controllers.Controllers.removeListener((ControllerListener)listener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearListeners() {
        if (this.active) {
            try {
                com.badlogic.gdx.controllers.Controllers.clearListeners();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Array<ControllerListener> getListeners() {
        if (this.active) {
            try {
                return com.badlogic.gdx.controllers.Controllers.getListeners();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Array();
    }
}

