/*
 * Bullet.java
 *
 * This is a passive model, and this model does very little by itself. The
 * CollisionController does most of the hard work.
 *
 * Based on the original Optimization Lab by Don Holden, 2007
 *
 * @author: Walker M. White
 * @version: 2/2/2025
 */
package edu.cornell.cis3152.optimization.entity;

import com.badlogic.gdx.utils.JsonValue;

/**
 * Model class for bullets fired by the ship.
 */
public class Bullet extends GameObject {

    /** The y-position offset of a newly generated bullet */
    private static float offset;
    /** The vertical speed of a newly generated bullet */
    private static float speed;

    /**
     * Returns the type of this object.
     *
     * We use this instead of runtime-typing for performance reasons.
     *
     * @return the type of this object.
     */
    public ObjectType getType() {
        return ObjectType.BULLET;
    }

    /**
     * Defines the constants for this class.
     *
     * Constants are values shared across all instances. Instead of defining
     * them above, we define them a JSON file. This static method initializes
     * the value from this file.
     *
     * @param constants The JSON value with constants
     */
    public static void setConstants(JsonValue constants) {
        offset = constants.getFloat("speed", 0);
        speed  = constants.getFloat("speed", 0);
    }

    /**
    * Creates a bullet with the given starting position.
     *
     * Any parameters other than position should be derived from the JSON
     * value of constants. See {@link #setConstants}.
     *
     * @param x The x-coordinate of the object
     * @param y The y-coordinate of the object
     */
    public Bullet(float x, float y) {
        super(x,y+offset);
        velocity.y = speed;
    }
}
