/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2.layout;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.scene2.SceneNode;

public abstract class Layout {
    public static final Vector2 ZERO = new Vector2(0.0f, 0.0f);
    public static final Vector2 ONE = new Vector2(1.0f, 1.0f);
    public static final Vector2 UNIT_X = new Vector2(1.0f, 0.0f);
    public static final Vector2 UNIT_Y = new Vector2(0.0f, 1.0f);
    public static final Vector2 ANCHOR_CENTER = new Vector2(0.5f, 0.5f);
    public static final Vector2 ANCHOR_BOTTOM_LEFT = new Vector2(0.0f, 0.0f);
    public static final Vector2 ANCHOR_TOP_LEFT = new Vector2(0.0f, 1.0f);
    public static final Vector2 ANCHOR_BOTTOM_RIGHT = new Vector2(1.0f, 0.0f);
    public static final Vector2 ANCHOR_TOP_RIGHT = new Vector2(1.0f, 1.0f);
    public static final Vector2 ANCHOR_MIDDLE_RIGHT = new Vector2(1.0f, 0.5f);
    public static final Vector2 ANCHOR_MIDDLE_LEFT = new Vector2(0.0f, 0.5f);
    public static final Vector2 ANCHOR_TOP_CENTER = new Vector2(0.5f, 1.0f);
    public static final Vector2 ANCHOR_BOTTOM_CENTER = new Vector2(0.5f, 0.0f);

    public Layout() {
    }

    public Layout(JsonValue data) {
    }

    public void dispose() {
    }

    public boolean add(String key, JsonValue data) {
        return false;
    }

    public boolean remove(String key) {
        return false;
    }

    public abstract void layout(SceneNode var1);

    public Anchor getAnchor(String xAnchor, String yAnchor) {
        Anchor anchor = Anchor.CENTER;
        block6 : switch (xAnchor) {
            case "left": {
                switch (yAnchor) {
                    case "top": {
                        anchor = Anchor.TOP_LEFT;
                        break block6;
                    }
                    case "bottom": {
                        anchor = Anchor.BOTTOM_LEFT;
                        break block6;
                    }
                    case "middle": {
                        anchor = Anchor.MIDDLE_LEFT;
                        break block6;
                    }
                }
                anchor = Anchor.LEFT_FILL;
                break;
            }
            case "right": {
                switch (yAnchor) {
                    case "top": {
                        anchor = Anchor.TOP_RIGHT;
                        break block6;
                    }
                    case "bottom": {
                        anchor = Anchor.BOTTOM_RIGHT;
                        break block6;
                    }
                    case "middle": {
                        anchor = Anchor.MIDDLE_RIGHT;
                        break block6;
                    }
                }
                anchor = Anchor.RIGHT_FILL;
                break;
            }
            case "center": {
                switch (yAnchor) {
                    case "top": {
                        anchor = Anchor.TOP_CENTER;
                        break block6;
                    }
                    case "bottom": {
                        anchor = Anchor.BOTTOM_CENTER;
                        break block6;
                    }
                    case "middle": {
                        anchor = Anchor.CENTER;
                        break block6;
                    }
                }
                anchor = Anchor.CENTER_FILL;
                break;
            }
            case "fill": {
                switch (yAnchor) {
                    case "top": {
                        anchor = Anchor.TOP_FILL;
                        break block6;
                    }
                    case "bottom": {
                        anchor = Anchor.BOTTOM_FILL;
                        break block6;
                    }
                    case "middle": {
                        anchor = Anchor.MIDDLE_FILL;
                        break block6;
                    }
                }
                anchor = Anchor.TOTAL_FILL;
                break;
            }
            default: {
                anchor = Anchor.NONE;
            }
        }
        return anchor;
    }

    public void placeNode(SceneNode node, Anchor anchor, Rectangle bounds, Vector2 offset) {
        Vector2 spot = new Vector2();
        Vector2 adjust = offset;
        Vector2 size = new Vector2();
        bounds.getSize(size);
        switch (anchor) {
            case TOP_LEFT: {
                spot.set(0.0f, size.y);
                break;
            }
            case MIDDLE_LEFT: {
                spot.set(0.0f, size.y / 2.0f);
                break;
            }
            case TOP_CENTER: {
                spot.set(size.x / 2.0f, size.y);
                break;
            }
            case CENTER: {
                spot.set(size.x / 2.0f, size.y / 2.0f);
                break;
            }
            case BOTTOM_CENTER: {
                spot.set(size.x / 2.0f, 0.0f);
                break;
            }
            case TOP_RIGHT: {
                spot.set(size.x, size.y);
                break;
            }
            case MIDDLE_RIGHT: {
                spot.set(size.x, size.y / 2.0f);
                break;
            }
            case BOTTOM_RIGHT: {
                spot.set(size.x, 0.0f);
                break;
            }
            case BOTTOM_LEFT: 
            case NONE: {
                break;
            }
            case LEFT_FILL: {
                spot.set(0.0f, size.y * node.getAnchor().y);
                node.setContentHeight(size.y - 2.0f * adjust.y);
                adjust.y = 0.0f;
                break;
            }
            case CENTER_FILL: {
                spot.set(size.x / 2.0f, size.y * node.getAnchor().y);
                node.setContentHeight(size.y - 2.0f * adjust.y);
                adjust.y = 0.0f;
                break;
            }
            case RIGHT_FILL: {
                spot.set(size.x, size.y * node.getAnchor().y);
                node.setContentHeight(size.y - 2.0f * adjust.y);
                adjust.y = 0.0f;
                break;
            }
            case BOTTOM_FILL: {
                spot.set(size.x * node.getAnchor().x, 0.0f);
                node.setContentWidth(size.x - 2.0f * adjust.x);
                adjust.x = 0.0f;
                break;
            }
            case MIDDLE_FILL: {
                spot.set(size.x * node.getAnchor().x, size.y / 2.0f);
                node.setContentWidth(size.x - 2.0f * adjust.x);
                adjust.x = 0.0f;
                break;
            }
            case TOP_FILL: {
                spot.set(size.x * node.getAnchor().x, size.y);
                node.setContentWidth(size.x - 2.0f * adjust.x);
                adjust.x = 0.0f;
                break;
            }
            case TOTAL_FILL: {
                spot.set(size.x * node.getAnchor().x, size.y * node.getAnchor().y);
                node.setContentSize(size.x - 2.0f * adjust.x, size.y - 2.0f * adjust.y);
                adjust.set(0.0f, 0.0f);
            }
        }
        spot.add(new Vector2(bounds.x, bounds.y)).add(adjust);
        node.setPosition(spot);
    }

    public void reanchor(SceneNode node, Anchor anchor) {
        switch (anchor) {
            case TOP_LEFT: {
                node.setAnchor(ANCHOR_TOP_LEFT);
                break;
            }
            case MIDDLE_LEFT: {
                node.setAnchor(ANCHOR_MIDDLE_LEFT);
                break;
            }
            case BOTTOM_LEFT: {
                node.setAnchor(ANCHOR_BOTTOM_LEFT);
                break;
            }
            case TOP_CENTER: {
                node.setAnchor(ANCHOR_TOP_CENTER);
                break;
            }
            case CENTER: {
                node.setAnchor(ANCHOR_CENTER);
                break;
            }
            case BOTTOM_CENTER: {
                node.setAnchor(ANCHOR_BOTTOM_CENTER);
                break;
            }
            case TOP_RIGHT: {
                node.setAnchor(ANCHOR_TOP_RIGHT);
                break;
            }
            case MIDDLE_RIGHT: {
                node.setAnchor(ANCHOR_MIDDLE_RIGHT);
                break;
            }
            case BOTTOM_RIGHT: {
                node.setAnchor(ANCHOR_BOTTOM_RIGHT);
                break;
            }
            case LEFT_FILL: {
                node.setAnchor(ANCHOR_BOTTOM_LEFT);
                break;
            }
            case CENTER_FILL: {
                node.setAnchor(ANCHOR_BOTTOM_CENTER);
                break;
            }
            case RIGHT_FILL: {
                node.setAnchor(ANCHOR_BOTTOM_RIGHT);
                break;
            }
            case BOTTOM_FILL: {
                node.setAnchor(ANCHOR_BOTTOM_LEFT);
                break;
            }
            case MIDDLE_FILL: {
                node.setAnchor(ANCHOR_MIDDLE_LEFT);
                break;
            }
            case TOP_FILL: {
                node.setAnchor(ANCHOR_TOP_LEFT);
                break;
            }
            case TOTAL_FILL: {
                node.setAnchor(ANCHOR_BOTTOM_LEFT);
                break;
            }
        }
    }

    public static enum Anchor {
        BOTTOM_LEFT,
        MIDDLE_LEFT,
        TOP_LEFT,
        BOTTOM_CENTER,
        CENTER,
        TOP_CENTER,
        BOTTOM_RIGHT,
        MIDDLE_RIGHT,
        TOP_RIGHT,
        BOTTOM_FILL,
        MIDDLE_FILL,
        TOP_FILL,
        LEFT_FILL,
        CENTER_FILL,
        RIGHT_FILL,
        TOTAL_FILL,
        NONE;

    }
}

