/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ShortArray;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.PathFactory;
import edu.cornell.gdiac.math.Poly2;
import edu.cornell.gdiac.scene2.SceneNode;
import edu.cornell.gdiac.scene2.TexturedNode;

public class WireNode
extends TexturedNode {
    private static final String UNKNOWN_STR = "<unknown>";
    protected Poly2 polygon;
    protected ShortArray indices;
    protected PathFactory.Traversal traversal;
    private final Vector2 vectorCache = new Vector2();
    private final Matrix4 matrixCache = new Matrix4();
    private final Path2 pathCache = new Path2();

    public WireNode() {
        this.classname = "WireNode";
        this.name = "WireNode";
        this.polygon = new Poly2();
        this.indices = new ShortArray();
    }

    public WireNode(Poly2 poly) {
        this(poly, PathFactory.Traversal.INTERIOR);
    }

    public WireNode(Rectangle rect) {
        this(new Poly2(rect), PathFactory.Traversal.INTERIOR);
    }

    public WireNode(Path2 path) {
        super((TextureRegion)null);
        this.polygon = new Poly2();
        this.indices = new ShortArray();
        this.setPath(path);
        this.setContentSize(this.polygon.getBounds().getSize(new Vector2()));
    }

    public static WireNode initWithPath(Rectangle rect) {
        return new WireNode(new Path2(rect));
    }

    public WireNode(float[] vertices) {
        super((TextureRegion)null);
        this.traversal = PathFactory.Traversal.CLOSED;
        this.polygon = new Poly2();
        this.indices = new ShortArray();
        this.setPath(vertices);
        this.setContentSize(this.polygon.getBounds().getSize(new Vector2()));
    }

    public WireNode(Poly2 poly, PathFactory.Traversal traversal) {
        super((TextureRegion)null);
        this.traversal = traversal;
        this.polygon = new Poly2(poly);
        this.indices = new ShortArray();
        this.makeTraversal(poly, traversal);
        this.setContentSize(this.polygon.getBounds().getSize(new Vector2()));
    }

    public WireNode(float[] vertices, short[] indices) {
        this.traversal = PathFactory.Traversal.NONE;
        this.polygon.set(vertices);
        this.indices = new ShortArray(indices);
        this.setContentSize(this.polygon.getBounds().getSize(new Vector2()));
    }

    public WireNode(float[] vertices, ShortArray indices) {
        this.traversal = PathFactory.Traversal.NONE;
        this.polygon.set(vertices);
        this.indices = new ShortArray(indices);
        this.setContentSize(this.polygon.getBounds().getSize(new Vector2()));
    }

    @Override
    public boolean initWithData(AssetDirectory manager, JsonValue data) {
        if (this.texture != null) {
            throw new IllegalArgumentException(this.classname + " is already initialized");
        }
        if (data == null) {
            return true;
        }
        if (!super.initWithData(manager, data)) {
            throw new IllegalArgumentException("Failed to initialize WireNode with the given JSON data.");
        }
        Vector2 coord = this.getPosition();
        boolean sizeFit = data.has("size");
        Vector2 size = this.getSize();
        if (!data.has("polygon")) {
            Rectangle bounds = new Rectangle();
            if (this.texture != null) {
                bounds.setSize(this.texture.getRegionWidth(), this.texture.getRegionHeight());
            } else {
                bounds.setSize(this.getContentWidth(), this.getContentHeight());
            }
            this.polygon.set(bounds);
        }
        this.setContentSize(this.polygon.getBounds().getSize(new Vector2()));
        if (data.has("wireframe")) {
            JsonValue indicesData = data.get("wireframe");
            this.indices = new ShortArray(indicesData.size);
            for (int i = 0; i < indicesData.size(); ++i) {
                this.indices.add(indicesData.get(i).asShort());
            }
        } else {
            String traverse;
            switch (traverse = data.getString("traversal", UNKNOWN_STR)) {
                case "open": {
                    this.traversal = PathFactory.Traversal.OPEN;
                    break;
                }
                case "closed": {
                    this.traversal = PathFactory.Traversal.CLOSED;
                    break;
                }
                case "interior": {
                    this.traversal = PathFactory.Traversal.INTERIOR;
                    break;
                }
                default: {
                    this.traversal = PathFactory.Traversal.NONE;
                }
            }
            this.makeTraversal(this.polygon, this.traversal);
        }
        if (sizeFit) {
            this.setContentSize(size);
        }
        this.setPosition(coord);
        return true;
    }

    public WireNode(AssetDirectory manager, JsonValue data) {
        this();
        this.initWithData(manager, data);
    }

    @Override
    public SceneNode copy(SceneNode dst) {
        super.copy(dst);
        WireNode node = (WireNode)dst;
        node.polygon = this.polygon;
        node.indices = this.indices;
        node.traversal = this.traversal;
        return dst;
    }

    public void setPolygon(Poly2 poly) {
        this.polygon = poly;
        if (this.traversal != PathFactory.Traversal.NONE) {
            this.makeTraversal(poly, this.traversal);
        }
        this.clearRenderData();
    }

    public Poly2 getPolygon() {
        return this.polygon;
    }

    public void setPolygon(Rectangle rect) {
        this.polygon.set(rect);
        if (this.traversal != PathFactory.Traversal.NONE) {
            this.makeTraversal(this.polygon, this.traversal);
        }
        this.clearRenderData();
    }

    public void setPath(Path2 path) {
        this.traversal = path.closed ? PathFactory.Traversal.CLOSED : PathFactory.Traversal.OPEN;
        this.polygon.set(path.vertices.items);
        this.indices.clear();
        this.indices.ensureCapacity(2 * path.size());
        for (int i = 0; i < path.size() - 1; ++i) {
            this.indices.add(i);
            this.indices.add(i + 1);
        }
        if (path.closed) {
            this.indices.add(path.size() - 1);
            this.indices.add(0);
        }
    }

    public void setPath(Rectangle rect) {
        this.setPath(this.pathCache.set(rect));
    }

    public void setPath(float[] vertices) {
        this.traversal = PathFactory.Traversal.CLOSED;
        this.polygon.set(vertices);
        this.indices.clear();
        this.indices.ensureCapacity(vertices.length);
        int vertices_size = vertices.length / 2;
        for (int i = 0; i < vertices_size - 1; ++i) {
            this.indices.add(i);
            this.indices.add(i + 1);
        }
        this.indices.add(vertices_size - 1);
        this.indices.add(0);
    }

    public void setTraversal(PathFactory.Traversal traversal) {
        if (this.traversal == traversal) {
            return;
        }
        this.traversal = traversal;
        this.makeTraversal(this.polygon, this.traversal);
        this.clearRenderData();
    }

    public void setTraversal(short[] indices) {
        this.traversal = PathFactory.Traversal.NONE;
        this.indices.clear();
        this.indices.addAll(indices);
        this.clearRenderData();
    }

    public void setTraversal(ShortArray indices) {
        this.traversal = PathFactory.Traversal.NONE;
        this.indices = indices;
        this.clearRenderData();
    }

    public PathFactory.Traversal getTraversal() {
        return this.traversal;
    }

    public float[] getVertices() {
        return this.polygon.vertices.items;
    }

    public Vector2[] getVerticesAsVector2() {
        return this.polygon.getVertices();
    }

    public short[] getIndices() {
        return this.indices.items;
    }

    @Override
    public void draw(SpriteBatch batch, Affine2 transform, Color tint) {
        if (!this.rendered) {
            this.generateRenderData();
        }
        batch.setColor(tint);
        batch.setTextureRegion(this.texture);
        if (this.gradient != null) {
            batch.setGradient(this.gradient);
        }
        batch.setBlendEquation(this.blendEquation);
        batch.setBlendSrcFunc(this.srcFactor);
        batch.setBlendDstFunc(this.dstFactor);
        batch.drawMesh(this.mesh, transform, true);
        batch.setGradient(null);
    }

    @Override
    protected void generateRenderData() {
        assert (!this.rendered) : "Render data is already present";
        if (this.texture == null) {
            return;
        }
        Vector2 nsize = this.getContentSize();
        Vector2 bsize = this.polygon.getBounds().getSize(this.vectorCache);
        Matrix4 shift = this.matrixCache;
        boolean adjust = false;
        if (!nsize.equals(bsize)) {
            adjust = true;
            shift.scale(bsize.x > 0.0f ? nsize.x / bsize.x : 0.0f, bsize.y > 0.0f ? nsize.y / bsize.y : 0.0f, 1.0f);
        }
        Vector2 offset = this.polygon.getBounds().getPosition(this.vectorCache);
        if (!this.absolute && !offset.isZero()) {
            adjust = true;
            shift.translate(-offset.x, -offset.y, 0.0f);
        }
        int width = this.texture.getRegionWidth();
        int height = this.texture.getRegionHeight();
        float color = Color.WHITE.toFloatBits();
        int vsize = this.polygon.vertices.size / 2;
        int stride = this.mesh.getStride();
        this.mesh.vertices.clear();
        this.mesh.vertices.ensureCapacity(stride * vsize);
        for (int ii = 0; ii < vsize; ++ii) {
            float x = this.polygon.vertices.items[2 * ii];
            float y = this.polygon.vertices.items[2 * ii + 1];
            this.mesh.vertices.items[ii * stride] = x;
            this.mesh.vertices.items[ii * stride + 1] = y;
            this.mesh.vertices.items[ii * stride + 2] = color;
            this.mesh.vertices.items[ii * stride + 3] = width > 0 ? x / (float)width : 0.0f;
            float f = this.mesh.vertices.items[ii * stride + 4] = height > 0 ? 1.0f - y / (float)height : 0.0f;
            if (stride <= 5) continue;
            this.mesh.vertices.items[ii * stride + 5] = width > 0 ? x / (float)width : 0.0f;
            this.mesh.vertices.items[ii * stride + 6] = height > 0 ? 1.0f - y / (float)height : 0.0f;
        }
        this.mesh.vertices.size = stride * vsize;
        this.mesh.indices.clear();
        this.mesh.indices.ensureCapacity(this.indices.size);
        System.arraycopy(this.indices.items, 0, this.mesh.indices.items, 0, this.indices.size);
        this.mesh.indices.size = this.indices.size;
        this.mesh.command = 1;
        this.rendered = true;
        this.updateTextureCoords();
        if (adjust) {
            this.mesh.mul(shift);
        }
    }

    @Override
    protected void updateTextureCoords() {
        if (!this.rendered) {
            return;
        }
        float width = this.texture.getRegionWidth();
        float height = this.texture.getRegionHeight();
        Vector2 off = this.offset.add(this.polygon.getBounds().x, this.polygon.getBounds().y);
        for (int i = 0; i < this.mesh.vertexCount(); ++i) {
            float s = (this.mesh.getPositionX(i) + off.x) / width;
            float t = (this.mesh.getPositionY(i) + off.y) / height;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (!this.flipVertical) {
                t = 1.0f - t;
            }
            this.mesh.setTextureCoord(i, s, t);
            this.mesh.setTextureCoord(i, s * this.texture.getU2() + (1.0f - s) * this.texture.getU(), t * this.texture.getV2() + (1.0f - t) * this.texture.getV());
            if (this.gradient == null) continue;
            s = (this.mesh.getPositionX(i) + off.x) / this.polygon.getBounds().width;
            t = (this.mesh.getPositionY(i) + off.y) / this.polygon.getBounds().height;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (!this.flipVertical) {
                t = 1.0f - t;
            }
            this.mesh.setGradientCoord(i, s, t);
        }
    }

    private void makeTraversal(Poly2 src, PathFactory.Traversal type) {
        switch (type) {
            case NONE: {
                break;
            }
            case OPEN: {
                this.makeBoundaryTraversal(src, false);
                break;
            }
            case CLOSED: {
                this.makeBoundaryTraversal(src, true);
                break;
            }
            case INTERIOR: {
                this.makeInteriorTraversal(src);
            }
        }
    }

    private void makeBoundaryTraversal(Poly2 src, boolean closed) {
        if (src.indices.isEmpty()) {
            this.indices.clear();
            this.indices.ensureCapacity(2 * src.size());
            for (int ii = 0; ii < src.size() - 1; ++ii) {
                this.indices.add(ii);
                this.indices.add(ii + 1);
            }
            if (closed) {
                this.indices.add(src.size() - 1);
                this.indices.add(0);
            }
        } else {
            short[][] bounds;
            this.indices.clear();
            for (short[] bound : bounds = src.boundaries()) {
                this.indices.ensureCapacity(2 * bound.length);
                for (int pos = 0; pos < bound.length - 1; ++pos) {
                    this.indices.add(bound[pos]);
                    this.indices.add(bound[pos + 1]);
                }
                if (!closed) continue;
                this.indices.add(bound[bound.length - 1]);
                this.indices.add(bound[0]);
            }
        }
    }

    private void makeInteriorTraversal(Poly2 src) {
        ShortArray indxs = src.indices;
        this.indices.clear();
        this.indices.ensureCapacity(2 * indxs.size);
        for (int ii = 0; ii < indxs.size; ii += 3) {
            this.indices.add(indxs.get(ii));
            this.indices.add(indxs.get(ii + 1));
            this.indices.add(indxs.get(ii + 1));
            this.indices.add(indxs.get(ii + 2));
            this.indices.add(indxs.get(ii + 2));
            this.indices.add(indxs.get(ii));
        }
    }
}

