/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.Gradient;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteMesh;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.scene2.SceneNode;

public abstract class TexturedNode
extends SceneNode {
    protected TextureRegion texture = null;
    protected Gradient gradient = null;
    protected boolean absolute = false;
    protected Vector2 offset = new Vector2();
    protected boolean rendered = false;
    protected SpriteMesh mesh = new SpriteMesh();
    protected int blendEquation = 32774;
    protected int srcFactor = 770;
    protected int dstFactor = 771;
    protected boolean flipHorizontal = false;
    protected boolean flipVertical = false;

    public static int blendEq(String value) {
        switch (value) {
            case "GL_FUNC_SUBTRACT": {
                return 32778;
            }
            case "GL_FUNC_REVERSE_SUBTRACT": {
                return 32779;
            }
            case "GL_MAX": {
                return 32776;
            }
            case "GL_MIN": {
                return 32775;
            }
        }
        return 32774;
    }

    public static int blendFunc(String value) {
        switch (value) {
            case "GL_SRC_COLOR": {
                return 768;
            }
            case "GL_ONE_MINUS_SRC_COLOR": {
                return 769;
            }
            case "GL_DST_COLOR": {
                return 774;
            }
            case "GL_ONE_MINUS_DST_COLOR": {
                return 775;
            }
            case "GL_SRC_ALPHA": {
                return 770;
            }
            case "GL_ONE_MINUS_SRC_ALPHA": {
                return 771;
            }
            case "GL_DST_ALPHA": {
                return 772;
            }
            case "GL_ONE_MINUS_DST_ALPHA": {
                return 773;
            }
            case "GL_ONE": {
                return 1;
            }
            case "GL_CONSTANT_COLOR": {
                return 32769;
            }
            case "GL_ONE_MINUS_CONSTANT_COLOR": {
                return 32770;
            }
            case "GL_CONSTANT_ALPHA": {
                return 32771;
            }
            case "GL_ONE_MINUS_CONSTANT_ALPHA": {
                return 32772;
            }
        }
        return 0;
    }

    public TexturedNode() {
    }

    public TexturedNode(String filename) {
        this();
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Invalid filename for texture");
        }
        this.texture = new TextureRegion(new Texture(filename));
        this.setAnchor(new Vector2(0.5f, 0.5f));
        this.setTexture(this.texture);
    }

    public TexturedNode(TextureRegion textureRegion) {
        this();
        this.setAnchor(new Vector2(0.5f, 0.5f));
        this.setTexture(textureRegion);
    }

    public TexturedNode(Texture texture) {
        this();
        this.setAnchor(new Vector2(0.5f, 0.5f));
        TextureRegion region = new TextureRegion(texture);
        this.setTexture(region);
    }

    public boolean initWithData(AssetDirectory manager, JsonValue data) {
        if (this.texture != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is already initialized");
        }
        String textureName = data.getString("texture", "<unknown>");
        this.setTexture(manager.getEntry(textureName, Texture.class));
        if (data.has("gradient")) {
            JsonValue gradientData = data.get("gradient");
            Color innerColor = new Color(gradientData.getFloat("innerR", 1.0f), gradientData.getFloat("innerG", 1.0f), gradientData.getFloat("innerB", 1.0f), gradientData.getFloat("innerA", 1.0f));
            Color outerColor = new Color(gradientData.getFloat("outerR", 1.0f), gradientData.getFloat("outerG", 1.0f), gradientData.getFloat("outerB", 1.0f), gradientData.getFloat("outerA", 1.0f));
            Vector2 start = new Vector2(gradientData.getFloat("startX", 0.0f), gradientData.getFloat("startY", 0.0f));
            Vector2 end = new Vector2(gradientData.getFloat("endX", 1.0f), gradientData.getFloat("endY", 1.0f));
            this.gradient.set(innerColor, outerColor, start, end);
        }
        this.absolute = data.getBoolean("absolute", false);
        this.blendEquation = TexturedNode.blendEq(data.getString("blendeq", "GL_FUNC_ADD"));
        this.srcFactor = TexturedNode.blendFunc(data.getString("blendsrc", "GL_SRC_ALPHA"));
        this.dstFactor = TexturedNode.blendFunc(data.getString("blenddst", "GL_ONE_MINUS_SRC_ALPHA"));
        String flip = data.getString("flip", "none");
        this.flipHorizontal = flip.equals("horizontal") || flip.equals("both");
        this.flipVertical = flip.equals("vertical") || flip.equals("both");
        return true;
    }

    public TexturedNode(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        this.initWithData(manager, data);
    }

    public TexturedNode copy(TexturedNode dst) {
        super.copy(dst);
        TexturedNode node = dst;
        node.texture = this.texture;
        node.gradient = this.gradient;
        node.absolute = this.absolute;
        node.rendered = this.rendered;
        node.offset = new Vector2(this.offset);
        node.mesh = this.mesh;
        node.blendEquation = this.blendEquation;
        node.srcFactor = this.srcFactor;
        node.dstFactor = this.dstFactor;
        node.flipHorizontal = this.flipHorizontal;
        node.flipVertical = this.flipVertical;
        return dst;
    }

    public void setTexture(String filename) {
        TextureRegion texture = new TextureRegion(new Texture(filename));
        this.setTexture(texture);
    }

    public void setTexture(TextureRegion texture) {
        TextureRegion temp;
        TextureRegion textureRegion = temp = texture == null ? new TextureRegion(Texture2D.getBlank()) : texture;
        if (this.texture != temp) {
            this.texture = temp;
            this.updateTextureCoords();
        }
    }

    public void setTexture(Texture texture) {
        TextureRegion temp;
        TextureRegion textureRegion = temp = texture == null ? new TextureRegion(Texture2D.getBlank()) : new TextureRegion(texture);
        if (this.texture != temp) {
            this.texture = temp;
            this.updateTextureCoords();
        }
    }

    public TextureRegion getTexture() {
        return this.texture;
    }

    public Gradient getGradient() {
        return this.gradient;
    }

    public void setGradient(Gradient gradient) {
        this.gradient = gradient;
        this.clearRenderData();
    }

    public void shiftTexture(float dx, float dy) {
        this.offset.add(dx, dy);
        this.updateTextureCoords();
    }

    public void setBlendFunc(int srcFactor, int dstFactor) {
        this.srcFactor = srcFactor;
        this.dstFactor = dstFactor;
    }

    public int getSourceBlendFactor() {
        return this.dstFactor;
    }

    public int getDestinationBlendFactor() {
        return this.dstFactor;
    }

    public void setBlendEquation(int equation) {
        this.blendEquation = equation;
    }

    public int getBlendEquation() {
        return this.blendEquation;
    }

    public void flipHorizontal(boolean flag) {
        this.flipHorizontal = flag;
        this.updateTextureCoords();
    }

    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    public void flipVertical(boolean flag) {
        this.flipVertical = flag;
        this.updateTextureCoords();
    }

    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    @Override
    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        if (verbose) {
            sb.append("cugl.");
            sb.append(this.getClass().getSimpleName());
        }
        int texId = this.texture == null ? -1 : this.texture.getTexture().getTextureObjectHandle();
        sb.append("(tag:");
        sb.append(this.getTag());
        sb.append(", name:");
        sb.append(this.getName());
        sb.append(", texture:");
        sb.append(texId);
        sb.append(")");
        return sb.toString();
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean flag) {
        this.absolute = flag;
        this.setAnchor(new Vector2(0.0f, 0.0f));
    }

    @Override
    public void setAnchor(Vector2 anchor) {
        if (!this.absolute) {
            super.setAnchor(anchor);
        }
    }

    @Override
    public void setAnchor(float x, float y) {
        this.setAnchor(new Vector2(x, y));
    }

    @Override
    public void setContentSize(Vector2 size) {
        super.setContentSize(size);
        this.clearRenderData();
    }

    @Override
    public void setContentSize(float width, float height) {
        this.setContentSize(new Vector2(width, height));
    }

    @Override
    public abstract void draw(SpriteBatch var1, Affine2 var2, Color var3);

    public void refresh() {
        this.clearRenderData();
        this.generateRenderData();
    }

    protected abstract void generateRenderData();

    protected abstract void updateTextureCoords();

    public void clearRenderData() {
        if (this.mesh != null) {
            this.mesh.clear();
        }
        this.rendered = false;
    }
}

