/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.scene2.PolygonNode;
import edu.cornell.gdiac.scene2.SceneNode;
import java.util.Objects;

public class SpriteNode
extends PolygonNode {
    protected int cols;
    protected int rows;
    protected int limit;
    protected int frame;
    protected Rectangle bounds;

    public SpriteNode() {
        this.rows = 0;
        this.cols = 0;
        this.limit = 0;
        this.frame = 0;
        this.bounds = new Rectangle();
    }

    public SpriteNode(TextureRegion texture, int rows, int cols) {
        this(texture, rows, cols, rows * cols);
    }

    public SpriteNode(TextureRegion texture, int rows, int cols, int size) {
        super(texture);
        assert (size <= rows * cols) : "Size cannot exceed rows * col";
        this.rows = rows;
        this.cols = cols;
        this.limit = size;
        this.bounds = new Rectangle(0.0f, 0.0f, (float)texture.getRegionWidth() / (float)cols, (float)texture.getRegionHeight() / (float)rows);
        this.setPolygon(this.bounds);
    }

    public SpriteNode(SpriteNode sprite) {
        super(sprite.texture);
        this.cols = sprite.cols;
        this.rows = sprite.rows;
        this.limit = sprite.limit;
        this.frame = sprite.frame;
        this.bounds = new Rectangle(sprite.bounds);
        this.setPolygon(this.bounds);
    }

    public SpriteNode(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        if (data.has("count")) {
            this.limit = data.getInt("count");
            if (data.has("cols")) {
                this.cols = data.getInt("cols");
                this.rows = this.limit / this.cols + (this.limit % this.cols == 0 ? 0 : 1);
            } else if (data.has("rows")) {
                this.rows = data.getInt("rows");
                this.cols = this.limit / this.rows;
            } else {
                this.rows = 1;
                this.cols = this.limit;
            }
        } else if (data.has("cols")) {
            this.cols = data.getInt("cols");
            this.rows = data.getInt("rows");
            this.limit = this.rows * this.cols;
        } else {
            this.cols = this.rows = data.getInt("rows", 1);
            this.limit = this.rows;
        }
        this.frame = data.getInt("frame", 0);
        this.bounds.setSize((float)this.texture.getRegionWidth() / (float)this.cols, (float)this.texture.getRegionHeight() / (float)this.rows);
        this.bounds.x = (float)(this.frame % this.cols) * this.bounds.width;
        this.bounds.y = (float)this.texture.getRegionHeight() - (1.0f + (float)this.frame / (float)this.cols) * this.bounds.height;
        Vector2 coord = this.getPosition();
        this.setPolygon(this.bounds);
        this.setPosition(coord);
    }

    @Override
    public SceneNode copy(SceneNode dst) {
        super.copy(dst);
        SpriteNode node = (SpriteNode)dst;
        node.cols = this.cols;
        node.rows = this.rows;
        node.limit = this.limit;
        node.frame = this.frame;
        node.bounds = this.bounds;
        return dst;
    }

    public int getCount() {
        return this.limit;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        assert (frame >= 0 && frame < this.limit) : "Invalid animation frame";
        this.frame = frame;
        float x = (float)(frame % this.cols) * this.bounds.width;
        float y = (float)this.texture.getRegionHeight() - (1.0f + (float)frame / (float)this.cols) * this.bounds.height;
        float dx = x - this.bounds.x;
        float dy = y - this.bounds.y;
        this.bounds.x = x;
        this.bounds.y = y;
        this.shiftTexture(dx, dy);
    }

    @Override
    public void generateRenderData() {
        assert (!this.rendered) : "Render data is already present";
        if (this.texture == null) {
            return;
        }
        for (Vector2 vertex : this.polygon.getVertices()) {
            this.mesh.push(vertex, Color.WHITE, new Vector2(0.0f, 0.0f));
        }
        for (int i = 0; i < this.polygon.indices.size; ++i) {
            this.mesh.indices.add(this.polygon.indices.get(i));
        }
        this.mesh.command = 4;
        Vector2 nsize = this.getContentSize();
        Vector2 bsize = new Vector2(this.polygon.getBounds().width, this.polygon.getBounds().height);
        Matrix4 shift = new Matrix4();
        boolean adjust = false;
        if (!Objects.equals(nsize, bsize)) {
            adjust = true;
            shift.scale(bsize.x > 0.0f ? nsize.x / bsize.x : 0.0f, bsize.y > 0.0f ? nsize.y / bsize.y : 0.0f, 1.0f);
        }
        Vector2 offset = new Vector2(this.polygon.getBounds().x, this.polygon.getBounds().y);
        if (!this.absolute && !offset.isZero()) {
            adjust = true;
            shift.translate(-offset.x, -offset.y, 0.0f);
        }
        if (adjust) {
            this.mesh = this.mesh.mul(shift);
        }
        this.rendered = true;
        this.updateTextureCoords();
    }

    private Rectangle getBounds() {
        return this.polygon.getBounds();
    }

    @Override
    public void updateTextureCoords() {
        if (!this.rendered) {
            return;
        }
        Vector2 tsize = new Vector2(this.texture.getRegionWidth(), this.texture.getRegionHeight());
        Vector2 off = new Vector2(this.bounds.x, this.bounds.y);
        for (int i = 0; i < this.mesh.vertexCount(); ++i) {
            Vector2 position = this.mesh.getPosition(i);
            float s = (position.x + off.x) / tsize.x;
            float t = 1.0f - (position.y + off.y) / tsize.y;
            if (this.flipHorizontal) {
                float x0 = off.x / tsize.x;
                float x1 = (off.x + this.bounds.width) / tsize.x;
                s = x1 - (s - x0);
            }
            if (this.flipVertical) {
                float y0 = off.y / tsize.y;
                float y1 = (off.y + this.bounds.height) / tsize.y;
                t = y1 - (t - y0);
            }
            float texS = s * this.texture.getU2() + (1.0f - s) * this.texture.getU();
            float texT = t * this.texture.getV2() + (1.0f - t) * this.texture.getV();
            this.mesh.setTextureCoord(i, texS, texT);
            if (this.gradient == null) continue;
            s = position.x / this.contentSize.x;
            t = position.y / this.contentSize.y;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (this.flipVertical) {
                t = 1.0f - t;
            }
            this.mesh.setGradientCoord(i, s, t);
        }
    }
}

