/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteMesh;
import edu.cornell.gdiac.graphics.TextAlign;
import edu.cornell.gdiac.graphics.TextLayout;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.graphics.TexturedMesh;
import edu.cornell.gdiac.scene2.SceneNode;

public class Label
extends SceneNode {
    final Color DROP_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    protected BitmapFont font;
    protected TextLayout layout;
    protected Vector2 offset = new Vector2(0.0f, 0.0f);
    protected float padbot = 0.0f;
    protected float padleft = 0.0f;
    protected float padtop = 0.0f;
    protected float padrght = 0.0f;
    protected boolean dropShadow = false;
    protected float dropBlur = 0.0f;
    protected Vector2 dropOffset = new Vector2(0.0f, 0.0f);
    protected Color foreground = Color.BLACK;
    protected Color background = Color.CLEAR;
    protected int blendEquation = 32774;
    protected int srcFactor = 32971;
    protected int dstFactor = 771;
    protected boolean rendered = false;
    protected Rectangle bounds = new Rectangle();
    protected Array<TexturedMesh> glyphrun = new Array();
    protected Vector2 cache = new Vector2();
    float blurCache = 0.0f;

    @Override
    public void dispose() {
        this.clearRenderData();
        this.layout = null;
        this.font = null;
        this.foreground = Color.BLACK;
        this.background = Color.CLEAR;
        this.padleft = 0.0f;
        this.padbot = 0.0f;
        this.padrght = 0.0f;
        this.padtop = 0.0f;
        this.dropShadow = false;
        this.dropBlur = 0.0f;
        this.dropOffset.setZero();
        this.rendered = false;
        this.blendEquation = 32774;
        this.srcFactor = 770;
        this.dstFactor = 771;
        super.dispose();
    }

    public Label() {
        this.classname = "Label";
    }

    public Label(Vector2 size) {
        this();
        this.set(size);
        this.font = null;
        this.layout = new TextLayout();
        this.layout.setAlignment(10);
    }

    public Label(float width, float height) {
        this(new Vector2(width, height));
    }

    public Label(Rectangle rect) {
        super(rect);
        this.classname = "Label";
        this.font = null;
        this.layout = new TextLayout();
        this.layout.setAlignment(10);
    }

    public Label(float x, float y, float width, float height) {
        this(new Rectangle(x, y, width, height));
    }

    public Label(String text, BitmapFont font) {
        super(new Vector2(0.0f, 0.0f));
        assert (font != null) : "The font is undefined";
        this.classname = "Label";
        this.font = font;
        this.layout = new TextLayout(text, font);
        this.layout.setAlignment(10);
        this.layout.layout();
        this.resize();
        this.reanchor();
    }

    public Label(float x, float y, String text, BitmapFont font) {
        super(x, y);
        assert (font != null) : "The font is undefined";
        this.classname = "Label";
        this.font = font;
        this.layout = new TextLayout(text, font);
        this.layout.setAlignment(10);
        this.layout.layout();
        this.resize();
        this.reanchor();
    }

    public Label(Vector2 size, String text, BitmapFont font) {
        this.set(size);
        assert (font != null) : "The font is undefined";
        this.classname = "Label";
        this.font = font;
        this.layout = new TextLayout(text, font);
        this.layout.setAlignment(10);
        this.layout.layout();
        this.reanchor();
    }

    public Label(Rectangle rect, String text, BitmapFont font) {
        super(rect);
        assert (font != null) : "The font is undefined";
        this.classname = "Label";
        this.font = font;
        this.layout = new TextLayout(text, font, rect.width);
        this.layout.setAlignment(10);
        this.layout.layout();
        this.reanchor();
    }

    public Label(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        boolean wrap;
        JsonValue col;
        Vector2 coord = this.getPosition();
        BitmapFont font = manager.getEntry(data.getString("font", "<unknown>"), BitmapFont.class);
        assert (font != null) : "The font is undefined";
        this.classname = "Label";
        this.font = font;
        if (data.has("text")) {
            this.layout = new TextLayout(data.getString("text"), font);
        } else {
            this.layout = new TextLayout();
            this.layout.setFont(font);
        }
        if (data.has("foreground")) {
            col = data.get("foreground");
            if (col.isString()) {
                try {
                    this.foreground.set(Color.valueOf(col.asString()));
                }
                catch (IllegalStateException e) {
                    this.foreground.set(Color.WHITE);
                }
            } else {
                assert (col.size >= 4) : "'color' must be a four-element number array";
                try {
                    this.foreground.r = (float)col.get(0).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.foreground.r = 0.0f;
                }
                try {
                    this.foreground.g = (float)col.get(1).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.foreground.g = 0.0f;
                }
                try {
                    this.foreground.b = (float)col.get(2).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.foreground.b = 0.0f;
                }
                try {
                    this.foreground.a = (float)col.get(3).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.foreground.a = 0.0f;
                }
            }
        }
        if (data.has("background")) {
            col = data.get("background");
            if (col.isString()) {
                try {
                    this.background.set(Color.valueOf(col.asString()));
                }
                catch (IllegalStateException e) {
                    this.background.set(Color.WHITE);
                }
            } else {
                assert (col.size >= 4) : "'color' must be a four element number array";
                try {
                    this.background.r = (float)col.get(0).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.background.r = 0.0f;
                }
                try {
                    this.background.g = (float)col.get(1).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.background.g = 0.0f;
                }
                try {
                    this.background.b = (float)col.get(2).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.background.b = 0.0f;
                }
                try {
                    this.background.a = (float)col.get(3).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.background.a = 0.0f;
                }
            }
        }
        if (data.has("padding")) {
            JsonValue pad = data.get("padding");
            if (pad.isNumber()) {
                float val;
                this.padleft = val = pad.asFloat();
                this.padrght = val;
                this.padtop = val;
                this.padbot = val;
            } else {
                assert (pad.size >= 4) : "'padding' must be a four element number array";
                try {
                    this.padleft = pad.get(0).asFloat();
                }
                catch (IllegalStateException e) {
                    this.padleft = 0.0f;
                }
                try {
                    this.padbot = pad.get(1).asFloat();
                }
                catch (IllegalStateException e) {
                    this.padbot = 0.0f;
                }
                try {
                    this.padrght = pad.get(2).asFloat();
                }
                catch (IllegalStateException e) {
                    this.padrght = 0.0f;
                }
                try {
                    this.padtop = pad.get(3).asFloat();
                }
                catch (IllegalStateException e) {
                    this.padtop = 0.0f;
                }
            }
        }
        int hValue = 8;
        if (data.has("halign")) {
            String align = data.getString("halign", "<unknown>");
            if (align.equals("center")) {
                hValue = 1;
            } else if (align.equals("right")) {
                hValue = 16;
            }
        }
        int vValue = 2;
        if (data.has("valign")) {
            String align = data.getString("valign", "<unknown>");
            if (align.equals("middle")) {
                vValue = 32;
            } else if (align.equals("bottom")) {
                vValue = 4;
            } else if (align.equals("baseline")) {
                vValue = 64;
            }
        }
        this.layout.setAlignment(hValue | vValue);
        this.dropShadow = data.getBoolean("dropshadow", false);
        if (data.has("dropoffset")) {
            JsonValue pos = data.get("dropoffset");
            assert (pos.size >= 2) : "'dropoffset' must be a two element number array";
            try {
                this.dropOffset.x = pos.get(0).asFloat();
            }
            catch (IllegalStateException e) {
                this.dropOffset.x = 0.0f;
            }
            try {
                this.dropOffset.y = pos.get(1).asFloat();
            }
            catch (IllegalStateException e) {
                this.dropOffset.y = 0.0f;
            }
        }
        if (wrap = data.getBoolean("wrap", false)) {
            float width = Math.max(0.0f, this.contentSize.x - this.padleft - this.padrght);
            this.layout.setWidth(width);
        }
        this.layout.layout();
        if (!data.has("size")) {
            this.resize();
        }
        this.reanchor();
        this.setPosition(coord);
    }

    public String getText() {
        return this.layout.getText();
    }

    public void setText(String text, boolean resize) {
        this.layout.setText(text);
        this.layout.layout();
        if (resize) {
            this.resize();
        }
        this.reanchor();
        this.clearRenderData();
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public void setFont(BitmapFont font, boolean resize) {
        this.font = font;
        this.layout.setFont(font);
        if (resize) {
            this.resize();
        }
        this.reanchor();
        this.clearRenderData();
    }

    public void setFont(BitmapFont font) {
        this.setFont(font, false);
    }

    public int getAlignment() {
        return this.layout.getAlignment();
    }

    public void setAlignment(int alignment) {
        this.layout.setAlignment(TextAlign.normalize(alignment));
        this.layout.layout();
        this.reanchor();
        this.clearRenderData();
    }

    public boolean getWrap() {
        return this.layout.getWidth() > 0.0f;
    }

    public void setWrap(boolean wrap) {
        float width = Math.max(0.0f, this.getContentWidth() - this.padleft - this.padrght);
        if (wrap && this.layout.getWidth() != width) {
            this.layout.setWidth(width);
            this.layout.layout();
            this.reanchor();
        } else if (!wrap && this.layout.getWidth() != 0.0f) {
            this.layout.setWidth(0.0f);
            this.layout.layout();
            this.reanchor();
        }
    }

    public void setPadding(float left, float bottom, float right, float top) {
        int align = this.layout.getAlignment();
        if (TextAlign.isLeft(align)) {
            this.offset.x += left - this.padleft;
        } else if (TextAlign.isRight(align)) {
            this.offset.x -= right - this.padrght;
        } else if (TextAlign.isCenter(align)) {
            float ocent = (this.padleft - this.padrght) / 2.0f;
            float ncent = (left - right) / 2.0f;
            this.offset.x += ncent - ocent;
        }
        if (TextAlign.isBottom(align) || TextAlign.isBaseline(align)) {
            this.offset.y += bottom - this.padbot;
        } else if (TextAlign.isTop(align)) {
            this.offset.y -= top - this.padtop;
        } else if (TextAlign.isMiddle(align)) {
            float omid = (this.padbot - this.padtop) / 2.0f;
            float nmid = (bottom - top) / 2.0f;
            this.offset.y += nmid - omid;
        }
        this.padleft = left;
        this.padbot = bottom;
        this.padrght = right;
        this.padtop = top;
        if (this.layout.getWidth() > 0.0f) {
            float width = Math.max(0.0f, this.contentSize.x - this.padleft - this.padrght);
            this.layout.setWidth(width);
            this.layout.layout();
        }
        this.reanchor();
        this.clearRenderData();
    }

    public void setPadding(float pad) {
        this.setPadding(pad, pad, pad, pad);
    }

    public float getPaddingLeft() {
        return this.padleft;
    }

    public void setPaddingLeft(float left) {
        this.setPadding(left, this.padbot, this.padrght, this.padtop);
    }

    public float getPaddingBottom() {
        return this.padbot;
    }

    public void setPaddingBottom(float bot) {
        this.setPadding(this.padleft, bot, this.padrght, this.padtop);
    }

    public float getPaddingRight() {
        return this.padrght;
    }

    public void setPaddingRight(float right) {
        this.setPadding(this.padleft, this.padbot, right, this.padtop);
    }

    public float getPaddingTop() {
        return this.padtop;
    }

    public void setPaddingTop(float top) {
        this.setPadding(this.padleft, this.padbot, this.padrght, top);
    }

    public Rectangle getInterior() {
        Rectangle result = new Rectangle(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight());
        result.x += this.padleft;
        result.y += this.padbot;
        result.width -= this.padleft + this.padrght;
        result.height -= this.padbot + this.padtop;
        return result;
    }

    public void setInterior(Rectangle rect) {
        Rectangle interior = new Rectangle(rect);
        interior.merge(new Rectangle(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight()));
        float left = interior.x;
        float bottom = interior.y;
        float right = this.contentSize.x - (interior.x + interior.width);
        float top = this.contentSize.y - (interior.y + interior.height);
        this.setPadding(left, bottom, right, top);
    }

    public Rectangle getTextBounds() {
        Rectangle bounds = this.layout.getBounds();
        bounds.x += this.offset.x;
        bounds.y += this.offset.y;
        return bounds;
    }

    @Override
    public void setContentSize(Vector2 size) {
        super.setContentSize(size);
        if (this.layout.getWidth() > 0.0f) {
            this.setWrap(true);
        }
        this.reanchor();
    }

    @Override
    public void setContentSize(float width, float height) {
        super.setContentSize(width, height);
        if (this.layout.getWidth() > 0.0f) {
            this.setWrap(true);
        }
        this.reanchor();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
        this.updateColor();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        if (this.background == color) {
            return;
        }
        if (this.background == Color.CLEAR || color == Color.CLEAR) {
            this.clearRenderData();
        }
        this.background = color;
        this.updateColor();
    }

    public Vector2 getDropShadow() {
        return this.dropOffset;
    }

    public void setDropShadow(Vector2 p) {
        this.setDropShadow(p.x, p.y);
    }

    public void setDropShadow(float x, float y) {
        this.dropOffset.set(x, y);
        if (!this.dropShadow && !this.dropOffset.isZero()) {
            this.dropShadow = true;
        }
    }

    public float getShadowBlur() {
        return this.dropBlur;
    }

    public void setShadowBlur(float blur) {
        this.dropBlur = blur;
        this.dropShadow = blur > 0.0f || !this.dropOffset.isZero();
    }

    public void setBlendFunc(int srcFactor, int dstFactor) {
    }

    int getSourceBlendFactor() {
        return this.srcFactor;
    }

    public int getDestinationBlendFactor() {
        return this.srcFactor;
    }

    public void setBlendEquation(int equation) {
        this.blendEquation = equation;
    }

    int getBlendEquation() {
        return this.blendEquation;
    }

    @Override
    public void draw(SpriteBatch batch, Affine2 transform, Color tint) {
        if (!this.rendered) {
            this.generateRenderData();
        }
        batch.setBlendEquation(this.blendEquation);
        batch.setBlendFunction(this.srcFactor, this.dstFactor);
        if (this.background != Color.CLEAR) {
            batch.setTexture(Texture2D.getBlank());
            batch.setColor(new Color(tint).mul(this.getBackground()));
            batch.fill(this.bounds, transform);
        }
        if (this.dropShadow) {
            this.blurCache = batch.getBlur();
            batch.setBlur(this.dropBlur);
            batch.setColor(new Color(tint).mul(this.DROP_COLOR));
            Affine2 offset = new Affine2().setToTranslation(this.dropOffset);
            offset.preMul(transform);
            for (int i = 0; i < this.glyphrun.size; ++i) {
                batch.setTextureRegion(this.glyphrun.get(i).getTextureRegion());
                batch.drawMesh((SpriteMesh)this.glyphrun.get(i), offset, true);
            }
            batch.setBlur(this.blurCache);
        }
        batch.setColor(tint);
        for (int i = 0; i < this.glyphrun.size; ++i) {
            batch.setTextureRegion(this.glyphrun.get(i).getTextureRegion());
            batch.drawMesh((SpriteMesh)this.glyphrun.get(i), transform, true);
        }
    }

    protected void generateRenderData() {
        if (this.rendered) {
            return;
        }
        this.bounds.set(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight());
        Rectangle legal = new Rectangle(this.bounds);
        legal.x -= this.offset.x;
        legal.y -= this.offset.y;
        this.layout.setBounds(legal);
        this.glyphrun.addAll(this.layout.getMeshes());
        for (int i = 0; i < this.glyphrun.size; ++i) {
            TexturedMesh mesh = this.glyphrun.get(i);
            for (int j = 0; j < mesh.vertexCount(); ++j) {
                mesh.getPosition(j, this.cache).add(this.offset);
                mesh.setPosition(j, this.cache);
                mesh.setColor(j, this.foreground);
            }
        }
        this.rendered = true;
    }

    protected void clearRenderData() {
        this.glyphrun.clear();
        this.rendered = false;
    }

    protected void updateColor() {
        if (!this.rendered) {
            return;
        }
        for (int j = 0; j < this.glyphrun.size; ++j) {
            TexturedMesh mesh = this.glyphrun.get(j);
            for (int i = 0; i < mesh.vertexCount(); ++i) {
                mesh.setColor(i, this.foreground);
            }
        }
    }

    protected void resize() {
        this.layout.getBounds().width += this.padleft + this.padrght;
        this.layout.getBounds().height += this.padbot + this.padtop;
        super.setContentSize(new Vector2(this.layout.getBounds().width, this.layout.getBounds().height));
        this.bounds.set(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight());
    }

    protected void reanchor() {
        this.clearRenderData();
        int align = this.layout.getAlignment();
        if (TextAlign.isLeft(align)) {
            this.offset.x = this.padleft;
        } else if (TextAlign.isRight(align)) {
            this.offset.x = this.getContentWidth() - this.padrght;
        } else if (TextAlign.isCenter(align)) {
            this.offset.x = (this.getContentWidth() + (this.padleft - this.padrght)) / 2.0f;
        }
        if (TextAlign.isBaseline(align) || TextAlign.isBottom(align)) {
            this.offset.y = this.padbot;
        } else if (TextAlign.isTop(align)) {
            this.offset.y = this.getContentHeight() - this.padtop;
        } else if (TextAlign.isMiddle(align)) {
            this.offset.y = (this.getContentHeight() + (this.padbot - this.padtop)) / 2.0f;
        }
    }
}

