/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.scene2.PolygonNode;
import edu.cornell.gdiac.scene2.SceneNode;
import edu.cornell.gdiac.scene2.layout.Layout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Button
extends SceneNode {
    boolean down;
    boolean toggle;
    private SceneNode upNode;
    private SceneNode downNode;
    private JsonValue upForm;
    private JsonValue downForm;
    private Color upColor;
    private Color downColor;
    private String upChild;
    private String downChild;
    private Path2 bounds;
    private boolean active;
    private boolean mouse;
    private int inputkey;
    private int nextKey;
    private final Map<Integer, Listener> listeners = new HashMap<Integer, Listener>();

    public Button() {
        this.down = false;
        this.mouse = false;
        this.active = false;
        this.toggle = false;
        this.upForm = null;
        this.downForm = null;
        this.inputkey = 0;
        this.nextKey = 1;
        this.upColor = Color.WHITE;
        this.downColor = Color.WHITE;
        this.upChild = "";
        this.downChild = "";
        this.bounds = new Path2();
        this.nextKey = 1;
        this.classname = "Button";
    }

    public boolean init() {
        assert (false) : "This node does not support the empty initializer";
        return false;
    }

    public Button(SceneNode up, Color down) {
        this();
        this.upNode = up;
        this.upColor = this.tintColor;
        this.downColor = down;
        Vector2 size = this.upNode.getContentSize();
        this.upNode.setAnchor(Layout.ANCHOR_CENTER);
        this.upNode.setPosition(size.x / 2.0f, size.y / 2.0f);
        this.setContentSize(size);
        this.addChild(this.upNode);
    }

    public Button(SceneNode up, SceneNode down) {
        this();
        assert (up != null) : "Up representation cannot be null";
        this.upNode = up;
        this.downNode = down;
        this.upColor = up.getColor();
        this.upNode.setAnchor(Layout.ANCHOR_CENTER);
        Vector2 size = this.upNode.getContentSize();
        if (down != null) {
            this.downColor = down.getColor();
            this.downNode.setAnchor(Layout.ANCHOR_CENTER);
            this.downNode.setVisible(this.upNode == null);
            Vector2 dsize = this.downNode.getContentSize();
            size.x = Math.max(size.x, dsize.x);
            size.y = Math.max(size.y, dsize.y);
        } else {
            this.downColor = Color.GRAY.mul(this.upColor);
        }
        this.upNode.setPosition(size.x / 2.0f, size.y / 2.0f);
        this.addChild(this.upNode);
        if (this.downNode != null) {
            this.downNode.setPosition(size.x / 2.0f, size.y / 2.0f);
            this.addChild(this.downNode);
        }
        this.setContentSize(size);
    }

    public Button(SceneNode up) {
        this(up, new Color(up.getColor()).mul(Color.GRAY));
    }

    public Button(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        this.bounds = new Path2();
        if (Vector2.Zero.equals(this.getContentSize())) {
            this.setContentSize(new Vector2(50.0f, 50.0f));
        }
        this.toggle = data.getBoolean("toggle", false);
        JsonValue upnode = data.get("upnode");
        this.upChild = "";
        this.upColor = Color.WHITE;
        if (upnode != null && upnode.size > 0) {
            assert (upnode.size == 4) : "The color 'up' must be a 4-element array of numbers 0..255.";
            this.upColor.r = upnode.get(0).asInt();
            this.upColor.g = upnode.get(1).asInt();
            this.upColor.b = upnode.get(2).asInt();
            this.upColor.a = upnode.get(3).asInt();
        } else if (upnode != null) {
            this.upChild = upnode.asString();
        }
        JsonValue downnode = data.get("downnode");
        this.downChild = "";
        this.downColor = Color.CLEAR;
        if (downnode != null && downnode.size > 0) {
            assert (downnode.size == 4) : "The color 'down' must be a 4-element array of numbers 0..255.";
            this.downColor.r = downnode.get(0).asInt();
            this.downColor.g = downnode.get(1).asInt();
            this.downColor.b = downnode.get(2).asInt();
            this.downColor.a = downnode.get(3).asInt();
        } else if (downnode != null) {
            this.downChild = downnode.asString();
        }
        if (data.has("pushable")) {
            this.bounds.set(data.get("pushable").asFloatArray());
        }
    }

    @Override
    public void setColor(Color color) {
        this.upColor = color;
        if (!this.down || this.downNode != null) {
            this.tintColor = color;
        }
    }

    @Override
    public void draw(SpriteBatch batch, Affine2 transform, Color tint) {
    }

    public Path2 getBounds() {
        return this.bounds;
    }

    public void setPushable(Path2 bounds) {
        this.bounds = bounds;
    }

    public void setPushable(Vector2[] vertices) {
        this.bounds.clear();
        FloatArray floatVertices = new FloatArray(vertices.length * 2);
        for (Vector2 vertex : vertices) {
            floatVertices.add(vertex.x, vertex.y);
            this.bounds.vertices = floatVertices;
            this.bounds.closed = true;
        }
    }

    @Override
    public boolean inContentBounds(Vector2 point) {
        Vector2 local = this.screenToNodeCoords(point);
        if (this.bounds.size() > 0 && this.bounds.contains(local)) {
            return this.parent == null || this.parent.inContentBounds(point);
        }
        Vector2 contentSize = this.getContentSize();
        Rectangle contentBounds = new Rectangle(0.0f, 0.0f, contentSize.x, contentSize.y);
        if (contentBounds.contains(local)) {
            return this.parent == null || this.parent.inContentBounds(point);
        }
        return false;
    }

    @Override
    public void doLayout() {
        if (this.upNode == null) {
            JsonValue data;
            boolean position;
            Vector2 osize;
            Vector2 coord = this.getPosition();
            Vector2 size = osize = this.getContentSize();
            if (!this.upChild.isEmpty()) {
                this.upNode = this.getChildByName(this.upChild);
            }
            if (!this.downChild.isEmpty()) {
                this.downNode = this.getChildByName(this.downChild);
            }
            if (this.upNode == null) {
                this.upNode = new PolygonNode(new TextureRegion(Texture2D.getBlank()));
                Vector2 curr = this.upNode.getContentSize();
                if (this.json == null || !this.json.has("size")) {
                    size.set(new Vector2(50.0f, 50.0f));
                }
                this.upNode.setScale(size.x / curr.x, size.y / curr.y);
            } else {
                this.upColor = this.upNode.getColor();
                if (this.json == null || !this.json.has("size")) {
                    size = this.upNode.getSize();
                }
            }
            if (this.downNode != null) {
                this.downColor = this.downNode.getColor();
                this.downNode.setVisible(this.upNode == null);
                Vector2 dsize = this.downNode.getSize();
                if (this.json == null || !this.json.has("size")) {
                    size.x = Math.max(dsize.x, size.x);
                    size.y = Math.max(dsize.y, size.y);
                }
            } else if (this.downColor == Color.CLEAR) {
                this.downColor.set(this.upColor).mul(Color.GRAY);
            }
            osize = size;
            this.setContentSize(size);
            if (this.upNode != null) {
                boolean anchor = false;
                position = false;
                data = this.upNode.getJSON();
                if (data != null) {
                    anchor = data.has("anchor");
                    position = data.has("position");
                }
                if (!anchor) {
                    this.upNode.setAnchor(Layout.ANCHOR_CENTER);
                }
                if (!position) {
                    this.upNode.setPosition(size.x / 2.0f, size.y / 2.0f);
                }
            }
            if (this.downNode != null) {
                boolean anchor = false;
                position = false;
                data = this.downNode.getJSON();
                if (data != null) {
                    anchor = data.has("anchor");
                    position = data.has("position");
                }
                if (!anchor) {
                    this.downNode.setAnchor(Layout.ANCHOR_CENTER);
                }
                if (!position) {
                    this.downNode.setPosition(size.x / 2.0f, size.y / 2.0f);
                }
            }
            if (this.bounds.size() > 0) {
                Vector2 scale = new Vector2(osize.x > 0.0f ? size.x / osize.x : 0.0f, osize.y > 0.0f ? size.y / osize.y : 0.0f);
                this.bounds.scl(scale);
            }
            this.setPosition(coord);
        }
        super.doLayout();
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        if (this.down == down) {
            return;
        }
        this.down = down;
        if (down && this.downNode != null && this.upNode != null) {
            this.upNode.setVisible(false);
            this.downNode.setVisible(true);
        } else if (down) {
            this.tintColor = this.downColor;
        }
        if (!down && this.downNode != null && this.upNode != null) {
            this.upNode.setVisible(true);
            this.downNode.setVisible(false);
        } else if (!down) {
            this.tintColor = this.upColor;
        }
        for (Listener listener : this.listeners.values()) {
            listener.onStateChange(this.getName(), down);
        }
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean value) {
        this.toggle = value;
    }

    public boolean hasListener() {
        return !this.listeners.isEmpty();
    }

    public Listener getListener(int key) {
        if (!this.listeners.containsKey(key)) {
            return null;
        }
        return this.listeners.get(key);
    }

    public List<Listener> getListeners() {
        ArrayList<Listener> result = new ArrayList<Listener>(this.listeners.size());
        result.addAll(this.listeners.values());
        return result;
    }

    public int addListener(Listener listener) {
        assert (this.nextKey < Integer.MAX_VALUE) : "No more available listener slots";
        this.listeners.put(++this.nextKey, listener);
        return this.nextKey;
    }

    public boolean removeListener(int key) {
        if (!this.listeners.containsKey(key)) {
            return false;
        }
        this.listeners.remove(key);
        return true;
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (super.touchDown(screenX, screenY, pointer, button)) {
            return true;
        }
        if (this.active && this.inContentBounds(new Vector2(screenX, screenY))) {
            if (this.toggle) {
                this.setDown(!this.isDown());
            } else {
                this.setDown(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (super.touchUp(screenX, screenY, pointer, button)) {
            return true;
        }
        if (this.active && this.isDown()) {
            if (!this.toggle) {
                this.setDown(false);
            }
            return true;
        }
        return false;
    }

    public boolean activate() {
        if (this.active) {
            return false;
        }
        this.active = true;
        return true;
    }

    public boolean deactivate() {
        if (!this.active) {
            return false;
        }
        this.active = false;
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public static interface Listener {
        public void onStateChange(String var1, boolean var2);
    }
}

