/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import edu.cornell.gdiac.math.Capsule;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;

public class PathFactory {
    private float tolerance;
    private final float DEFAULT_TOLERANCE = 0.5f;

    public PathFactory() {
        this.tolerance = 0.5f;
    }

    public PathFactory(float tol) {
        this.tolerance = tol;
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(float tol) {
        this.tolerance = tol;
    }

    public Path2 makeLine(float ox, float oy, float dx, float dy) {
        return this.makeLine(ox, oy, dx, dy, null);
    }

    public Path2 makeLine(float ox, float oy, float dx, float dy, Path2 path) {
        float[] vert = new float[]{ox, oy, dx, dy};
        if (path == null) {
            path = new Path2(vert);
        } else {
            path.clear();
            path.vertices.addAll(vert);
        }
        path.corners.addAll(0, 1);
        path.closed = false;
        return path;
    }

    public Path2 makeTriangle(float ax, float ay, float bx, float by, float cx, float cy) {
        return this.makeTriangle(ax, ay, bx, by, cx, cy, null);
    }

    public Path2 makeTriangle(float ax, float ay, float bx, float by, float cx, float cy, Path2 path) {
        float[] vert = new float[]{ax, ay, bx, by, cx, cy};
        if (path == null) {
            path = new Path2(vert);
        } else {
            path.clear();
            path.vertices.addAll(vert);
        }
        path.corners.addAll(0, 1, 2);
        path.closed = true;
        return path;
    }

    public Path2 makeRect(float x, float y, float w, float h) {
        return this.makeRect(x, y, w, h, null);
    }

    public Path2 makeRect(float x, float y, float w, float h, Path2 path) {
        float[] vert = new float[]{x, y, x + w, y, x + w, y + h, x, y + h};
        if (path == null) {
            path = new Path2(vert);
        } else {
            path.clear();
            path.vertices.addAll(vert);
        }
        path.corners.addAll(0, 1, 2);
        path.closed = true;
        return path;
    }

    public Path2 makeNgon(float cx, float cy, float radius, int sides) {
        return this.makeNgon(cx, cy, radius, sides, null);
    }

    public Path2 makeNgon(float cx, float cy, float radius, int sides, Path2 path) {
        float coef = (float)Math.PI * 2 / (float)sides;
        float[] vert = new float[sides * 2];
        for (int i = 0; i < sides; ++i) {
            float rads = (float)i * coef;
            vert[i * 2] = (float)((double)radius * Math.cos(rads) + (double)cx);
            vert[i * 2 + 1] = (float)((double)radius * Math.sin(rads) + (double)cy);
        }
        if (path == null) {
            path = new Path2(vert);
        } else {
            path.clear();
            path.vertices.addAll(vert);
        }
        path.closed = true;
        return path;
    }

    public Path2 makeEllipse(float cx, float cy, float sx, float sy) {
        return this.makeEllipse(cx, cy, sx, sy, null);
    }

    public Path2 makeEllipse(float cx, float cy, float sx, float sy, Path2 path) {
        int segments = this.curveSegs(Math.max(sx / 2.0f, sy / 2.0f), (float)Math.PI * 2, this.tolerance);
        float coef = (float)(Math.PI * 2 / (double)segments);
        float[] vert = new float[segments * 2];
        for (int i = 0; i < segments; ++i) {
            float rads = (float)i * coef;
            vert[i * 2] = (float)((double)(0.5f * sx) * Math.cos(rads) + (double)cx);
            vert[i * 2 + 1] = (float)((double)(0.5f * sy) * Math.sin(rads) + (double)cy);
        }
        if (path == null) {
            path = new Path2(vert);
        } else {
            path.clear();
            path.vertices.addAll(vert);
        }
        path.closed = true;
        return path;
    }

    public Path2 makeCircle(float cx, float cy, float radius) {
        return this.makeEllipse(cx, cy, 2.0f * radius, 2.0f * radius, null);
    }

    public Path2 makeCircle(float cx, float cy, float radius, Path2 path) {
        return this.makeEllipse(cx, cy, 2.0f * radius, 2.0f * radius, path);
    }

    public Path2 makeArc(float cx, float cy, float radius, float start, float degrees, boolean closed) {
        return this.makeArc(cx, cy, radius, start, degrees, closed, null);
    }

    public Path2 makeArc(float cx, float cy, float radius, float start, float degrees, boolean closed, Path2 path) {
        if (degrees <= 0.0f || degrees > 360.0f) {
            throw new IllegalArgumentException("degree out of range");
        }
        int segments = this.curveSegs(radius, (float)((double)degrees * Math.PI / 180.0), this.tolerance);
        segments = degrees < (float)segments ? (int)degrees : segments;
        float srad = (float)Math.PI / 180 * start;
        float arad = (float)Math.PI / 180 * degrees;
        float coef = arad / (float)segments;
        float[] vert = degrees == 360.0f || !closed ? new float[segments * 2 + 2] : new float[segments * 2 + 4];
        for (int i = 0; i < segments + 1; ++i) {
            float rads = srad + (float)i * coef;
            vert[i * 2] = (float)((double)(0.5f * radius) * Math.cos(rads) + (double)cx);
            vert[i * 2 + 1] = (float)((double)(0.5f * radius) * Math.sin(rads) + (double)cy);
        }
        if (degrees != 360.0f && closed) {
            vert[segments * 2 + 2] = cx;
            vert[segments * 2 + 3] = cy;
        }
        if (path == null) {
            path = new Path2(vert);
        } else {
            path.clear();
            path.vertices.addAll(vert);
        }
        path.closed = closed;
        return path;
    }

    public Path2 makeRoundedRect(float x, float y, float w, float h, float r) {
        return this.makeRoundedRect(x, y, w, h, r, null);
    }

    public Path2 makeRoundedRect(float x, float y, float w, float h, float r, Path2 path) {
        int i;
        if (r > w / 2.0f) {
            throw new IllegalArgumentException("Radius exceeds width");
        }
        if (r > h / 2.0f) {
            throw new IllegalArgumentException("Radius exceeds height");
        }
        int segments = this.curveSegs(r, (float)Math.PI * 2, this.tolerance);
        float coef = (float)(Math.PI / (double)(2.0f * (float)segments));
        float c1x = w >= 0.0f ? w : 0.0f;
        float c1y = h >= 0.0f ? h : 0.0f;
        float c2x = w >= 0.0f ? 0.0f : w;
        float c2y = h >= 0.0f ? h : 0.0f;
        float c3x = w >= 0.0f ? 0.0f : w;
        float c3y = h >= 0.0f ? 0.0f : h;
        float c4x = w >= 0.0f ? w : 0.0f;
        float c4y = h >= 0.0f ? 0.0f : h;
        float[] vert = new float[segments * 8 + 8];
        int ind = 0;
        float cx = x + c1x - r;
        float cy = y + c1y - r;
        for (i = 0; i <= segments; ++i) {
            vert[ind] = (float)((double)r * Math.cos((float)i * coef) + (double)cx);
            vert[ind + 1] = (float)((double)r * Math.sin((float)i * coef) + (double)cy);
            ind += 2;
        }
        cx = x + c2x + r;
        cy = y + c2y - r;
        for (i = 0; i <= segments; ++i) {
            vert[ind] = (float)((double)cx - (double)r * Math.sin((float)i * coef));
            vert[ind + 1] = (float)((double)r * Math.cos((float)i * coef) + (double)cy);
            ind += 2;
        }
        cx = x + c3x + r;
        cy = y + c3y + r;
        for (i = 0; i <= segments; ++i) {
            vert[ind] = (float)((double)cx - (double)r * Math.cos((float)i * coef));
            vert[ind + 1] = (float)((double)cy - (double)r * Math.sin((float)i * coef));
            ind += 2;
        }
        cx = x + c4x - r;
        cy = y + c4y + r;
        for (i = 0; i <= segments; ++i) {
            vert[ind] = (float)((double)r * Math.sin((float)i * coef) + (double)cx);
            vert[ind + 1] = (float)((double)cy - (double)r * Math.cos((float)i * coef));
            ind += 2;
        }
        if (path == null) {
            path = new Path2(vert);
        } else {
            path.clear();
            path.vertices.addAll(vert);
        }
        path.closed = true;
        return path;
    }

    public Path2 makeCapsule(float x, float y, float w, float h) {
        return this.makeCapsule(Capsule.FULL, x, y, w, h, null);
    }

    public Path2 makeCapsule(float x, float y, float w, float h, Path2 path) {
        return this.makeCapsule(Capsule.FULL, x, y, w, h, path);
    }

    public Path2 makeCapsule(Capsule shape, float x, float y, float w, float h) {
        return this.makeCapsule(shape, x, y, w, h, null);
    }

    public Path2 makeCapsule(Capsule shape, float x, float y, float w, float h, Path2 path) {
        if (shape == Capsule.DEGENERATE) {
            return this.makeEllipse(x + w / 2.0f, y + h / 2.0f, w, h);
        }
        if (w == h) {
            return this.makeCircle(x + w / 2.0f, y + h / 2.0f, w);
        }
        int segments = this.curveSegs(Math.min(w / 2.0f, h / 2.0f), (float)Math.PI * 2, this.tolerance);
        float coef = (float)(Math.PI / (double)segments);
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        if (path == null) {
            path = new Path2();
        } else {
            path.clear();
        }
        if (w <= h) {
            float rads;
            int i;
            int offset;
            float radius = w / 2.0f;
            float iy = y + radius;
            float ih = h - w;
            if (shape == Capsule.HALF_REVERSE) {
                path.push(cx - radius, iy, true);
                path.push(cx + radius, iy, true);
            } else {
                offset = path.vertices.size;
                path.reserve(segments * 2 + 2);
                for (i = 0; i <= segments; ++i) {
                    rads = i == segments ? (float)Math.PI : (float)i * coef;
                    path.vertices.items[offset + i * 2] = (float)((double)cx - (double)radius * Math.cos(rads));
                    path.vertices.items[offset + i * 2 + 1] = (float)((double)iy - (double)radius * Math.sin(rads));
                }
            }
            if (shape == Capsule.HALF) {
                path.push(cx + radius, iy + ih, true);
                path.push(cx - radius, iy + ih, true);
            } else {
                offset = path.vertices.size;
                path.reserve(segments * 2 + 2);
                for (i = 0; i <= segments; ++i) {
                    rads = i == segments ? (float)Math.PI : (float)i * coef;
                    path.vertices.items[offset + i * 2] = (float)((double)cx + (double)radius * Math.cos(rads));
                    path.vertices.items[offset + i * 2 + 1] = (float)((double)(iy + ih) + (double)radius * Math.sin(rads));
                }
            }
        } else {
            float rads;
            int i;
            int offset;
            float radius = h / 2.0f;
            float ix = x + radius;
            float iw = w - h;
            if (shape == Capsule.HALF_REVERSE) {
                path.push(ix, cy + radius, true);
                path.push(ix, cy - radius, true);
            } else {
                offset = path.vertices.size;
                path.reserve(segments * 2 + 2);
                for (i = 0; i <= segments; ++i) {
                    rads = i == segments ? (float)Math.PI : (float)i * coef;
                    path.vertices.items[offset + i * 2] = (float)((double)ix - (double)radius * Math.sin(rads));
                    path.vertices.items[offset + i * 2 + 1] = (float)((double)cy + (double)radius * Math.cos(rads));
                }
            }
            if (shape == Capsule.HALF) {
                path.push(ix + iw, cy - radius, true);
                path.push(ix + iw, cy + radius, true);
            } else {
                offset = path.vertices.size;
                path.reserve(segments * 2 + 2);
                for (i = 0; i <= segments; ++i) {
                    rads = i == segments ? (float)Math.PI : (float)i * coef;
                    path.vertices.items[offset + i * 2] = (float)((double)(ix + iw) + (double)radius * Math.sin(rads));
                    path.vertices.items[offset + i * 2 + 1] = (float)((double)cy - (double)radius * Math.cos(rads));
                }
            }
        }
        path.closed = true;
        return path;
    }

    public Path2[] makeTraversal(Poly2 src, Traversal type) {
        switch (type) {
            case NONE: {
                break;
            }
            case OPEN: {
                return this.makeBoundaryTraversal(src, false);
            }
            case CLOSED: {
                return this.makeBoundaryTraversal(src, true);
            }
            case INTERIOR: {
                return this.makeInteriorTraversal(src);
            }
        }
        return new Path2[0];
    }

    public Path2[] makeBoundaryTraversal(Poly2 src, boolean closed) {
        short[][] bound = src.boundaries();
        Path2[] paths = new Path2[bound.length];
        for (int i = 0; i < bound.length; ++i) {
            short[] sl = bound[i];
            Path2 path = new Path2();
            for (int pos = 0; pos < sl.length; ++pos) {
                path.push(src.vertices.items[sl[pos] * 2], src.vertices.items[sl[pos] * 2 + 1], true);
            }
            path.closed = closed;
            paths[i] = path;
        }
        return paths;
    }

    public Path2[] makeInteriorTraversal(Poly2 src) {
        Path2[] paths = new Path2[src.indices.size / 3];
        int ind = 0;
        for (int i = 0; i < src.indices.size; i += 3) {
            float[] vert = new float[]{src.vertices.items[src.indices.items[i] * 2], src.vertices.items[src.indices.items[i] * 2 + 1], src.vertices.items[src.indices.items[i + 1] * 2], src.vertices.items[src.indices.items[i + 1] * 2 + 1], src.vertices.items[src.indices.items[i + 2] * 2], src.vertices.items[src.indices.items[i + 2] * 2 + 1]};
            Path2 path = new Path2(vert);
            path.closed = true;
            paths[ind] = path;
            ++ind;
        }
        return paths;
    }

    private int curveSegs(float rad, float arc, float tol) {
        float da = (float)(Math.acos(rad / (rad + tol)) * 2.0);
        return Math.max(2, (int)Math.ceil(arc / da));
    }

    public static enum Traversal {
        NONE,
        OPEN,
        CLOSED,
        INTERIOR;

    }
}

