/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import edu.cornell.gdiac.graphics.GLDebug;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

public class UniformBuffer
implements Disposable {
    private IntBuffer dataBuffer;
    private int blockCount;
    private int blockPntr;
    private int blockSize;
    private int blockStride;
    private int bindpoint;
    private boolean isbound = false;
    private ByteBuffer byteBuffer;
    private int drawtype;
    private boolean autoflush;
    private boolean dirty;
    private HashMap<String, Integer> offsets;
    private String name;
    private final float[] tempdata = new float[16];
    private boolean initialized;
    public static final int INVALID_OFFSET = -1;

    public UniformBuffer() {
        if (Gdx.gl30 == null) {
            throw new UnsupportedOperationException("Uniform buffers require OpenGL 3.0");
        }
        this.dataBuffer = BufferUtils.newIntBuffer(1);
        this.dataBuffer.put(0, 0);
        this.blockCount = 0;
        this.blockPntr = 0;
        this.blockSize = 0;
        this.blockStride = 0;
        this.bindpoint = 0;
        this.autoflush = false;
        this.dirty = false;
        this.name = "";
        this.byteBuffer = null;
        this.drawtype = 35040;
        this.offsets = new HashMap();
        this.initialized = true;
    }

    public UniformBuffer(int capacity, int blocks) {
        this();
        assert (blocks != 0) : "Block count must be nonzero";
        GL30 gl = Gdx.gl30;
        this.blockCount = blocks;
        this.blockSize = capacity;
        IntBuffer value = BufferUtils.newIntBuffer(1);
        gl.glGetIntegerv(35380, value);
        while (this.blockStride < this.blockSize) {
            this.blockStride += value.get(0);
        }
        gl.glGetIntegerv(35376, value);
        if (this.blockStride > value.get(0)) {
            this.blockSize = 0;
            this.blockStride = 0;
            this.blockCount = 0;
            throw new GdxRuntimeException(String.format("Capacity exceeds maximum value of %d bytes", value));
        }
        gl.glGenBuffers(1, this.dataBuffer);
        if (this.dataBuffer.get(0) == 0) {
            int error = Gdx.gl30.glGetError();
            throw new GdxRuntimeException(String.format("Could not create uniform buffer. %s", GLDebug.errorName(error)));
        }
        this.byteBuffer = BufferUtils.newUnsafeByteBuffer(this.blockStride * this.blockCount);
        gl.glBindBuffer(35345, this.dataBuffer.get(0));
        gl.glBufferData(35345, this.blockStride * this.blockCount, null, this.drawtype);
        int error = gl.glGetError();
        if (error != 0) {
            gl.glDeleteBuffers(1, this.dataBuffer);
            this.dataBuffer.put(0, 0);
            throw new GdxRuntimeException("Could not create uniform buffer");
        }
        gl.glBindBuffer(35345, 0);
        this.offsets = new HashMap();
    }

    protected void finalize() throws Throwable {
        if (this.initialized) {
            this.dispose();
            super.finalize();
        }
    }

    @Override
    public void dispose() {
        GL30 gl = Gdx.gl30;
        if (this.dataBuffer != null) {
            gl.glDeleteBuffers(1, this.dataBuffer);
            this.dataBuffer.put(0, 0);
            this.dataBuffer = null;
        }
        if (this.byteBuffer != null) {
            BufferUtils.disposeUnsafeByteBuffer(this.byteBuffer);
            this.byteBuffer = null;
        }
        this.name = "";
        if (this.offsets != null) {
            this.offsets.clear();
            this.offsets = null;
        }
        this.blockCount = 0;
        this.blockSize = 0;
        this.blockStride = 0;
        this.bindpoint = 0;
    }

    public int getBuffer() {
        return this.dataBuffer.get(0);
    }

    public int getBindPoint() {
        return this.bindpoint;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setBindPoint(int point) {
        GL30 gl = Gdx.gl30;
        if (this.isbound) {
            gl.glBindBufferBase(35345, this.bindpoint, 0);
        }
        this.bindpoint = point;
    }

    public void bind(boolean activate) {
        GL30 gl = Gdx.gl30;
        if (activate) {
            this.activate();
        }
        gl.glBindBufferBase(35345, this.bindpoint, this.dataBuffer.get(0));
    }

    public void unbind() {
        GL30 gl = Gdx.gl30;
        if (this.isbound) {
            gl.glBindBufferBase(35345, this.bindpoint, 0);
            this.isbound = false;
        }
    }

    public void activate() {
        GL30 gl = Gdx.gl30;
        gl.glBindBuffer(35345, this.dataBuffer.get(0));
        if (this.autoflush && this.dirty) {
            gl.glBufferData(35345, this.blockStride * this.blockCount, this.byteBuffer, this.drawtype);
            this.dirty = false;
        }
    }

    public void deactivate() {
        GL30 gl = Gdx.gl30;
        IntBuffer bound = BufferUtils.newIntBuffer(1);
        gl.glGetIntegerv(35368, bound);
        if (bound == this.dataBuffer) {
            gl.glBindBuffer(35345, 0);
        }
    }

    boolean isBound() {
        return this.isbound;
    }

    public boolean isActive() {
        GL30 gl = Gdx.gl30;
        IntBuffer bound = BufferUtils.newIntBuffer(1);
        gl.glGetIntegerv(35368, bound);
        return bound == this.dataBuffer;
    }

    public int getBlock() {
        return this.blockPntr;
    }

    public void setBlock(int block) {
        GL30 gl = Gdx.gl30;
        if (this.blockPntr != block) {
            this.blockPntr = block;
            gl.glBindBufferRange(35345, this.bindpoint, this.dataBuffer.get(0), block * this.blockStride, this.blockSize);
        }
    }

    public void flush() {
        assert (this.isActive()) : "Buffer is not active.";
        GL30 gl = Gdx.gl30;
        gl.glBufferData(35345, this.blockStride * this.blockCount, this.byteBuffer, this.drawtype);
        this.dirty = false;
    }

    public void setOffset(String name, int offset) {
        this.offsets.put(name, offset);
    }

    public int getOffset(String name) {
        Integer elt = this.offsets.get(name);
        if (elt == null) {
            return -1;
        }
        return elt;
    }

    public String[] getOffsets() {
        String[] result = new String[this.offsets.size()];
        int count = 0;
        for (Map.Entry<String, Integer> mapElement : this.offsets.entrySet()) {
            String key;
            result[count] = key = mapElement.getKey();
            ++count;
        }
        return result;
    }

    public void setUniform(int block, int offset, Vector2 vec) {
        this.tempdata[0] = vec.x;
        this.tempdata[1] = vec.y;
        this.setUniformfv(block, offset, 2, this.tempdata, 0);
    }

    public void setUniform(int block, String name, Vector2 vec) {
        this.tempdata[0] = vec.x;
        this.tempdata[1] = vec.y;
        this.setUniformfv(block, name, 2, this.tempdata, 0);
    }

    public boolean getUniform(int block, int offset, Vector2 vec) {
        if (this.getUniformfv(block, offset, 2, this.tempdata, 0)) {
            vec.set(this.tempdata[0], this.tempdata[1]);
            return true;
        }
        return false;
    }

    public boolean getUniform(int block, String name, Vector2 vec) {
        if (this.getUniformfv(block, name, 2, this.tempdata, 0)) {
            vec.set(this.tempdata[0], this.tempdata[1]);
            return true;
        }
        return false;
    }

    public void setUniform(int block, int offset, Vector3 vec) {
        this.tempdata[0] = vec.x;
        this.tempdata[1] = vec.y;
        this.tempdata[2] = vec.z;
        this.setUniformfv(block, offset, 3, this.tempdata, 0);
    }

    public void setUniform(int block, String name, Vector3 vec) {
        this.tempdata[0] = vec.x;
        this.tempdata[1] = vec.y;
        this.tempdata[2] = vec.z;
        this.setUniformfv(block, name, 3, this.tempdata, 0);
    }

    public boolean getUniform(int block, int offset, Vector3 vec) {
        if (this.getUniformfv(block, offset, 3, this.tempdata, 0)) {
            vec.set(this.tempdata[0], this.tempdata[1], this.tempdata[2]);
            return true;
        }
        return false;
    }

    public boolean getUniform(int block, String name, Vector3 vec) {
        if (this.getUniformfv(block, name, 3, this.tempdata, 0)) {
            vec.set(this.tempdata[0], this.tempdata[1], this.tempdata[2]);
            return true;
        }
        return false;
    }

    public void setUniform(int block, int offset, Color color) {
        this.tempdata[0] = color.r;
        this.tempdata[1] = color.g;
        this.tempdata[2] = color.b;
        this.tempdata[3] = color.a;
        this.setUniformfv(block, offset, 4, this.tempdata, 0);
    }

    public void setUniform(int block, String name, Color color) {
        this.tempdata[0] = color.r;
        this.tempdata[1] = color.g;
        this.tempdata[2] = color.b;
        this.tempdata[3] = color.a;
        this.setUniformfv(block, name, 4, this.tempdata, 0);
    }

    public boolean getUniform(int block, int offset, Color color) {
        if (this.getUniformfv(block, offset, 4, this.tempdata, 0)) {
            color.set(this.tempdata[0], this.tempdata[1], this.tempdata[2], this.tempdata[3]);
            return true;
        }
        return false;
    }

    public boolean getUniform(int block, String name, Color color) {
        if (this.getUniformfv(block, name, 4, this.tempdata, 0)) {
            color.set(this.tempdata[0], this.tempdata[1], this.tempdata[2], this.tempdata[3]);
            return true;
        }
        return false;
    }

    public void setUniform(int block, int offset, Matrix4 mat) {
        this.setUniformfv(block, offset, 16, mat.val, 0);
    }

    public void setUniform(int block, String name, Matrix4 mat) {
        this.setUniformfv(block, name, 16, mat.val, 0);
    }

    public boolean getUniform(int block, int offset, Matrix4 mat) {
        return this.getUniformfv(block, offset, 16, mat.val, 0);
    }

    public boolean getUniform(int block, String name, Matrix4 mat) {
        return this.getUniformfv(block, name, 16, mat.val, 0);
    }

    public void setUniform(int block, int offset, Affine2 mat) {
        float[] data = new float[12];
        data[0] = mat.m00;
        data[1] = mat.m10;
        data[4] = mat.m01;
        data[5] = mat.m11;
        data[8] = mat.m02;
        data[9] = mat.m12;
        data[10] = 1.0f;
        this.setUniformfv(block, offset, 12, data, 0);
    }

    public void setUniform(int block, String name, Affine2 mat) {
        float[] data = new float[12];
        data[0] = mat.m00;
        data[1] = mat.m10;
        data[4] = mat.m01;
        data[5] = mat.m11;
        data[8] = mat.m02;
        data[9] = mat.m12;
        data[10] = 1.0f;
        this.setUniformfv(block, name, 12, data, 0);
    }

    public boolean getUniform(int block, int offset, Affine2 mat) {
        float[] data = new float[12];
        if (this.getUniformfv(block, offset, 12, data, 0)) {
            mat.m00 = data[0];
            mat.m10 = data[1];
            mat.m01 = data[4];
            mat.m11 = data[5];
            mat.m02 = data[8];
            mat.m12 = data[9];
            return true;
        }
        return false;
    }

    public boolean getUniform(int block, String name, Affine2 mat) {
        float[] data = new float[12];
        if (this.getUniformfv(block, name, 12, data, 0)) {
            mat.m00 = data[0];
            mat.m10 = data[1];
            mat.m01 = data[4];
            mat.m11 = data[5];
            mat.m02 = data[8];
            mat.m12 = data[9];
            return true;
        }
        return false;
    }

    public void setUniform(int block, int offset, Quaternion quat) {
        this.tempdata[0] = quat.x;
        this.tempdata[1] = quat.y;
        this.tempdata[2] = quat.z;
        this.tempdata[3] = quat.w;
        this.setUniformfv(block, offset, 4, this.tempdata, 0);
    }

    public void setUniform(int block, String name, Quaternion quat) {
        this.tempdata[0] = quat.x;
        this.tempdata[1] = quat.y;
        this.tempdata[2] = quat.z;
        this.tempdata[3] = quat.w;
        this.setUniformfv(block, name, 4, this.tempdata, 0);
    }

    public boolean getUniform(int block, int offset, Quaternion quat) {
        if (this.getUniformfv(block, offset, 4, this.tempdata, 0)) {
            quat.set(this.tempdata[0], this.tempdata[1], this.tempdata[2], this.tempdata[3]);
            return true;
        }
        return false;
    }

    public boolean getUniformQuaternion(int block, String name, Quaternion quat) {
        if (this.getUniformfv(block, name, 4, this.tempdata, 0)) {
            quat.set(this.tempdata[0], this.tempdata[1], this.tempdata[2], this.tempdata[3]);
            return true;
        }
        return false;
    }

    public void setUniformfv(int block, int offset, int size, float[] values) {
        this.setUniformfv(block, offset, size, values, 0);
    }

    public void setUniformfv(int block, int offset, int size, float[] values, int srcOffset) {
        assert (block < this.blockCount) : "Block " + block + " is invalid.";
        assert (offset < this.blockSize) : "Offset " + offset + " is invalid.";
        GL30 gl = Gdx.gl30;
        if (block >= 0) {
            int pos = this.byteBuffer.position();
            int position = block * this.blockStride + offset;
            ((Buffer)this.byteBuffer).position(position);
            BufferUtils.copy(values, srcOffset, size, (Buffer)this.byteBuffer);
            ((Buffer)this.byteBuffer).position(pos);
            if (this.autoflush && this.isActive()) {
                gl.glBufferSubData(35345, position, size * 32, this.byteBuffer);
            } else {
                this.dirty = true;
            }
        } else {
            boolean active = false;
            if (this.autoflush && this.isActive()) {
                active = true;
            } else {
                this.dirty = true;
            }
            for (int bl = 0; bl < this.blockCount; ++bl) {
                int pos = this.byteBuffer.position();
                int position = bl * this.blockStride + offset;
                ((Buffer)this.byteBuffer).position(position);
                BufferUtils.copy(values, srcOffset, size, (Buffer)this.byteBuffer);
                ((Buffer)this.byteBuffer).position(pos);
                if (!active) continue;
                gl.glBufferSubData(35345, position, size * 32, this.byteBuffer);
            }
        }
    }

    public void setUniformfv(int block, String name, int size, float[] values, int srcoff) {
        int offset = this.getOffset(name);
        if (offset != -1) {
            this.setUniformfv(block, offset, size, values, srcoff);
        }
    }

    public boolean getUniformfv(int block, int offset, int size, float[] values, int dstoff) {
        if (block >= this.blockCount || offset > this.blockSize) {
            return false;
        }
        int position = (block * this.blockStride + offset) / 4;
        FloatBuffer floater = this.byteBuffer.asFloatBuffer();
        floater.position(position);
        floater.get(values, dstoff, size);
        this.byteBuffer.position(0);
        return true;
    }

    public boolean getUniformfv(int block, String name, int size, float[] values, int dstoff) {
        int offset = this.getOffset(name);
        if (offset != -1) {
            return this.getUniformfv(block, offset, size, values, dstoff);
        }
        return false;
    }

    public void setUniformiv(int block, int offset, int size, int[] values, int srcoff) {
        assert (block < this.blockCount) : String.format("Block %d is invalid.", block);
        assert (offset < this.blockSize) : String.format("Offset %d is invalid.", offset);
        if (block >= 0) {
            int position = block * this.blockStride + offset;
            this.byteBuffer.position(position);
            BufferUtils.copy(values, srcoff, size, (Buffer)this.byteBuffer);
            this.byteBuffer.position(0);
            if (this.autoflush && this.isActive()) {
                Gdx.gl30.glBufferSubData(35345, position, size * 4, this.byteBuffer);
            } else {
                this.dirty = true;
            }
        } else {
            for (int bb = 0; bb < this.blockCount; ++bb) {
                int position = bb * this.blockStride + offset;
                this.byteBuffer.position(position);
                BufferUtils.copy(values, srcoff, size, (Buffer)this.byteBuffer);
            }
            this.byteBuffer.position(0);
            if (this.autoflush && this.isActive()) {
                Gdx.gl30.glBufferSubData(35345, 0, size * 4, this.byteBuffer);
            } else {
                this.dirty = true;
            }
        }
    }

    public void setUniformiv(int block, String name, int size, int[] values, int srcoff) {
        int offset = this.getOffset(name);
        if (offset != -1) {
            this.setUniformiv(block, offset, size, values, srcoff);
        }
    }

    public boolean getUniformiv(int block, int offset, int size, int[] values, int dstoff) {
        if (block >= this.blockCount || offset > this.blockSize) {
            return false;
        }
        int position = (block * this.blockStride + offset) / 4;
        IntBuffer integer = this.byteBuffer.asIntBuffer();
        integer.position(position);
        integer.get(values, dstoff, size);
        this.byteBuffer.position(0);
        return true;
    }

    public boolean getUniformiv(int block, String name, int size, int[] values, int dstoff) {
        int offset = this.getOffset(name);
        if (offset != -1) {
            return this.getUniformiv(block, offset, size, values, dstoff);
        }
        return false;
    }
}

