/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class SpriteSheet
extends TextureRegion {
    private int rows;
    private int cols;
    private int rx;
    private int ry;
    private int rwidth;
    private int rheight;
    private int size;
    private int frame;

    public SpriteSheet() {
        this.rows = 0;
        this.cols = 0;
        this.rx = 0;
        this.ry = 0;
        this.rwidth = 0;
        this.rheight = 0;
        this.size = 0;
        this.frame = 0;
    }

    public SpriteSheet(Texture texture, int rows, int cols) {
        this(texture, rows, cols, rows * cols);
    }

    public SpriteSheet(Texture texture, int rows, int cols, int size) {
        this(texture, rows, cols, size, 0, 0, texture.getWidth(), texture.getHeight());
    }

    public SpriteSheet(Texture texture, int rows, int cols, int size, int x, int y, int width, int height) {
        super(texture);
        if (size > rows * cols) {
            Gdx.app.error("SpriteSheet", "Invalid strip size", new IllegalArgumentException());
            return;
        }
        this.rows = rows;
        this.cols = cols;
        this.size = size;
        this.rx = x;
        this.ry = y;
        this.rwidth = width / cols;
        this.rheight = height / rows;
        this.setFrame(0);
    }

    public SpriteSheet(SpriteSheet sprite) {
        super(sprite.getTexture());
        if (this.size > this.rows * this.cols) {
            Gdx.app.error("SpriteSheet", "Invalid strip size", new IllegalArgumentException());
            return;
        }
        this.rows = sprite.rows;
        this.cols = sprite.cols;
        this.size = sprite.size;
        this.rx = sprite.rx;
        this.ry = sprite.ry;
        this.rwidth = sprite.rwidth;
        this.rheight = sprite.rheight;
        this.setFrame(sprite.frame);
    }

    public SpriteSheet set(Texture texture, int rows, int cols) {
        return this.set(texture, rows, cols, rows * cols);
    }

    public SpriteSheet set(Texture texture, int rows, int cols, int size) {
        return this.set(texture, rows, cols, size, 0, 0, texture.getWidth(), texture.getHeight());
    }

    public SpriteSheet set(Texture texture, int rows, int cols, int size, int x, int y, int width, int height) {
        this.setTexture(texture);
        if (size > rows * cols) {
            Gdx.app.error("SpriteSheet", "Invalid strip size", new IllegalArgumentException());
            return null;
        }
        this.rows = rows;
        this.cols = cols;
        this.size = size;
        this.rx = x;
        this.ry = y;
        this.rwidth = width / cols;
        this.rheight = height / rows;
        this.setFrame(0);
        return this;
    }

    public SpriteSheet set(SpriteSheet sprite) {
        this.setTexture(sprite.getTexture());
        if (this.size > this.rows * this.cols) {
            Gdx.app.error("SpriteSheet", "Invalid strip size", new IllegalArgumentException());
            return null;
        }
        this.rows = sprite.rows;
        this.cols = sprite.cols;
        this.size = sprite.size;
        this.rx = sprite.rx;
        this.ry = sprite.ry;
        this.rwidth = sprite.rwidth;
        this.rheight = sprite.rheight;
        this.setFrame(sprite.frame);
        return this;
    }

    @Override
    public void setRegion(TextureRegion region) {
        super.setRegion(region);
        this.rx = region.getRegionX();
        this.ry = region.getRegionY();
        this.rwidth = region.getRegionWidth();
        this.rheight = region.getRegionHeight();
        this.rows = 1;
        this.cols = 1;
        this.size = 1;
        this.frame = 0;
    }

    public int getSize() {
        return this.size;
    }

    public int getFrame() {
        return this.getTexture() == null ? 0 : this.frame;
    }

    public void setFrame(int frame) {
        if (this.getTexture() == null) {
            return;
        }
        if (frame < 0 || frame >= this.size) {
            Gdx.app.error("SpriteSheet", "Invalid animation frame", new IllegalArgumentException());
            return;
        }
        this.frame = frame;
        int x = frame % this.cols * this.rwidth;
        int y = frame / this.cols * this.rheight;
        if (this.getTexture() != null) {
            this.setRegion(x, y, this.rwidth, this.rheight);
        }
    }

    public SpriteSheet copy() {
        return new SpriteSheet(this.getTexture(), this.rows, this.cols, this.size);
    }
}

