/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.backend.audio;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.StreamUtils;
import edu.cornell.gdiac.audio.AudioSource;
import edu.cornell.gdiac.audio.AudioStream;
import edu.cornell.gdiac.backend.audio.OggInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OggSource
implements AudioSource {
    protected FileHandle source;
    protected int channels;
    protected int sampleRate;
    protected float duration;
    protected long byteSize;
    protected OggInputStream input;

    public OggSource(FileHandle file) {
        this.source = file;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try {
            this.input = new OggInputStream(this.source.read());
            this.channels = this.input.getChannels();
            this.sampleRate = this.input.getSampleRate();
            byte[] buffer = new byte[2048];
            this.byteSize = 0L;
            int length = 0;
            while (!this.input.atEnd() && length >= 0) {
                length = this.input.read(buffer);
                if (length <= 0) continue;
                this.byteSize += (long)length;
            }
            this.byteSize -= this.byteSize % (long)(this.channels > 1 ? 4 : 2);
            long samples = this.byteSize / (long)(2 * this.channels);
            this.duration = (float)samples / (float)this.sampleRate;
        }
        finally {
            StreamUtils.closeQuietly(this.input);
        }
    }

    @Override
    public void dispose() {
        this.source = null;
        this.channels = 0;
        this.sampleRate = 0;
        this.duration = 0.0f;
        this.byteSize = 0L;
    }

    @Override
    public FileHandle getFile() {
        return this.source;
    }

    @Override
    public int getChannels() {
        return this.channels;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public AudioStream getStream() {
        return new Stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getData() {
        OggInputStream reader = null;
        ByteBuffer result = null;
        try {
            int length;
            this.input = reader = new OggInputStream(this.source.read(), this.input);
            ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[2048];
            while (!this.input.atEnd() && (length = this.input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            result = ByteBuffer.allocateDirect((int)this.byteSize);
            result.order(ByteOrder.nativeOrder());
            result.put(output.toByteArray(), 0, (int)this.byteSize);
            result.flip();
        }
        finally {
            StreamUtils.closeQuietly(this.input);
        }
        return result;
    }

    public String toString() {
        return "'" + this.getFile().toString() + " [" + String.format("@%x", this.hashCode()) + "]'";
    }

    public class Stream
    implements AudioStream {
        private OggInputStream input;
        private OggInputStream previous;
        private long byteOffs;
        private byte[] tempBytes;

        public Stream() {
            this.input = new OggInputStream(OggSource.this.source.read());
            this.byteOffs = 0L;
        }

        @Override
        public AudioSource getSource() {
            return OggSource.this;
        }

        @Override
        public long getByteSize() {
            return OggSource.this.byteSize;
        }

        @Override
        public long getByteOffset() {
            return this.byteOffs;
        }

        @Override
        public long getSampleSize() {
            return OggSource.this.byteSize / 2L;
        }

        @Override
        public long getSampleOffset() {
            return this.byteOffs / 2L;
        }

        @Override
        public int read(byte[] buffer) {
            if (this.input == null) {
                this.input = new OggInputStream(OggSource.this.source.read(), this.previous);
                this.previous = null;
            }
            int chunk = this.input.read(buffer, 0, buffer.length);
            this.byteOffs += (long)chunk;
            return chunk;
        }

        @Override
        public int read(short[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.read(this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                buffer[ii] = (short)(upper << 8 | lower);
            }
            return length / 2;
        }

        @Override
        public int read(float[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.read(this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                short value = (short)(upper << 8 | lower);
                buffer[ii] = (float)value / 32767.0f;
            }
            return length / 2;
        }

        @Override
        public int seek(long pos, byte[] buffer) {
            if (pos <= 0L || buffer.length <= 1) {
                throw new IllegalArgumentException("Illegal seek parameters");
            }
            byte[] temp = new byte[buffer.length / 2];
            if (pos < this.byteOffs) {
                StreamUtils.closeQuietly(this.input);
                this.input = new OggInputStream(OggSource.this.source.read(), this.input);
                this.byteOffs = 0L;
            }
            if (this.input == null) {
                this.input = new OggInputStream(OggSource.this.source.read(), this.previous);
                this.previous = null;
            }
            int chunk = 1;
            while (chunk > 0 && this.byteOffs < pos) {
                chunk = this.input.read(temp, 0, temp.length);
                this.byteOffs += (long)chunk;
            }
            if (this.byteOffs < pos) {
                this.reset();
                return 0;
            }
            int mark = (int)(this.byteOffs - pos);
            System.arraycopy(temp, mark, buffer, 0, chunk - mark);
            mark = chunk - mark;
            chunk = this.input.read(temp, 0, temp.length);
            System.arraycopy(temp, 0, buffer, mark, chunk);
            return chunk + mark;
        }

        @Override
        public int seek(long pos, short[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.seek(pos, this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                buffer[ii] = (short)(upper << 8 | lower);
            }
            return length / 2;
        }

        @Override
        public int seek(long pos, float[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.seek(pos, this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                short value = (short)(upper << 8 | lower);
                buffer[ii] = (float)value / 32767.0f;
            }
            return length / 2;
        }

        @Override
        public void reset() {
            StreamUtils.closeQuietly(this.input);
            this.previous = null;
            this.input = null;
            this.byteOffs = 0L;
        }

        @Override
        public void loop() {
            StreamUtils.closeQuietly(this.input);
            this.previous = this.input;
            this.input = null;
            this.byteOffs = 0L;
        }
    }
}

