/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.graphics.Shader;

public class ShaderLoader
extends AsynchronousAssetLoader<Shader, ShaderParameters> {
    protected FileHandleResolver resolver;
    private Shader cachedShader;

    public ShaderLoader() {
        this(new InternalFileHandleResolver());
    }

    public ShaderLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
    }

    protected Shader getLoadedShader() {
        return this.cachedShader;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, ShaderParameters params) {
        FileHandle handle;
        if (params.vertex20 != null && (handle = this.resolve(params.vertex20)).exists()) {
            params.vertex20 = handle.readString();
        }
        if (params.vertex30 != null && (handle = this.resolve(params.vertex30)).exists()) {
            params.vertex30 = handle.readString();
        }
        if (params.fragment20 != null && (handle = this.resolve(params.fragment20)).exists()) {
            params.fragment20 = handle.readString();
        }
        if (params.fragment30 != null && (handle = this.resolve(params.fragment30)).exists()) {
            params.fragment30 = handle.readString();
        }
    }

    @Override
    public Shader loadSync(AssetManager manager, String fileName, FileHandle file, ShaderParameters params) {
        boolean useGL30 = Gdx.gl30 != null;
        String key = fileName.substring(0, fileName.length() - 5);
        if (useGL30) {
            if (params.vertex30 == null) {
                Gdx.app.error("ShaderLoader (" + key + ")", "Missing GL30-compliant vertex shader");
                this.cachedShader = new Shader();
            } else if (params.fragment30 == null) {
                Gdx.app.error("ShaderLoader (" + key + ")", "Missing GL30-compliant fragment shader");
                this.cachedShader = new Shader();
            } else {
                this.cachedShader = new Shader(params.vertex30, params.fragment30);
                if (!this.cachedShader.isCompiled()) {
                    Gdx.app.error("ShaderLoader (" + key + ")", this.cachedShader.getLog());
                }
            }
            return this.cachedShader;
        }
        if (params.vertex20 == null) {
            Gdx.app.error("ShaderLoader (" + key + ")", "Missing GL20-compliant vertex shader");
            this.cachedShader = new Shader();
        } else if (params.fragment20 == null) {
            Gdx.app.error("ShaderLoader (" + key + ")", "Missing GL20-compliant fragment shader");
            this.cachedShader = new Shader();
        } else {
            this.cachedShader = new Shader(params.vertex20, params.fragment20);
            if (!this.cachedShader.isCompiled()) {
                Gdx.app.error("ShaderLoader (" + key + ")", this.cachedShader.getLog());
            }
        }
        return this.cachedShader;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, ShaderParameters params) {
        return null;
    }

    public static class ShaderParameters
    extends AssetLoaderParameters<Shader> {
        public String vertex20;
        public String fragment20;
        public String vertex30;
        public String fragment30;
    }
}

