/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization.entity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.optimization.entity.GameObject;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.util.RandomGenerator;

public class Star
extends GameObject {
    private static int meanAge;
    private static int ageRange;
    private static float minOffset;
    private static float maxOffset;
    private static float minFactor;
    private static float maxFactor;
    private int age = RandomGenerator.getInt(meanAge - ageRange, meanAge + ageRange);
    private float angle;

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.STAR;
    }

    public float getAngle() {
        return this.angle;
    }

    public static void setConstants(JsonValue constants) {
        meanAge = constants.getInt("mean age", 0);
        ageRange = constants.getInt("age range", 0);
        JsonValue offsets = constants.get("offset range");
        JsonValue factors = constants.get("factor range");
        minOffset = offsets.getFloat(0);
        maxOffset = offsets.getFloat(1);
        minFactor = factors.getFloat(0);
        maxFactor = factors.getFloat(1);
    }

    public Star(float x, float y) {
        super(x, y);
    }

    public void initVelocity(float vx, float vy) {
        vx = vx * RandomGenerator.getFloat(minFactor, maxFactor) + RandomGenerator.getFloat(minOffset, maxOffset);
        vy = vy * RandomGenerator.getFloat(minFactor, maxFactor) + RandomGenerator.getFloat(minOffset, maxOffset);
        this.velocity.set(vx, vy);
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        if (--this.age == 0) {
            this.destroyed = true;
        }
        this.angle = (float)((double)(delta * 1000.0f) % (Math.PI * 8));
    }

    @Override
    public void draw(SpriteBatch batch) {
        SpriteBatch.computeTransform(this.transform, this.origin.x, this.origin.y, this.position.x, this.position.y, this.angle, 1.0f, 1.0f);
        batch.setColor(Color.WHITE);
        batch.draw(this.animator, this.transform);
    }
}

