/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization.entity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.optimization.entity.GameObject;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteSheet;

public class Ship
extends GameObject {
    private static float beetleSpeed;
    private static int cooldownTime;
    private static int cooldownBonus;
    private static float imageScale;
    private static float animationSpeed;
    private float movement = 0.0f;
    private boolean firing = false;
    private int cooldown = 0;
    private float animeframe = 0.0f;

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.SHIP;
    }

    public float getMovement() {
        return this.movement;
    }

    public void setMovement(float value) {
        this.movement = value;
    }

    public boolean isFiring() {
        return this.firing && this.cooldown <= 0;
    }

    public void setFiring(boolean value) {
        this.firing = value;
    }

    public void resetCooldown() {
        this.cooldown = cooldownTime;
    }

    public static void setConstants(JsonValue constants) {
        beetleSpeed = constants.getFloat("beetle speed", 0.0f);
        cooldownTime = constants.getInt("cooldown time", 0);
        cooldownBonus = constants.getInt("cooldown bonus", 0);
        imageScale = constants.getFloat("image scale", 1.0f);
        animationSpeed = constants.getFloat("animation speed", 0.0f);
    }

    public Ship(float x, float y) {
        super(x, y);
    }

    @Override
    public void setSpriteSheet(SpriteSheet sheet) {
        super.setSpriteSheet(sheet);
        this.radius *= imageScale;
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        if (this.movement != 0.0f && this.animator != null) {
            this.animeframe += animationSpeed;
            if (this.animeframe >= (float)this.animator.getSize()) {
                this.animeframe -= (float)this.animator.getSize();
            }
            this.position.x += this.movement * beetleSpeed;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (!this.firing) {
            this.cooldown -= cooldownBonus;
        }
    }

    @Override
    public void draw(SpriteBatch batch) {
        float x = (float)this.animator.getRegionWidth() / 2.0f;
        float y = (float)this.animator.getRegionHeight() / 2.0f;
        SpriteBatch.computeTransform(this.transform, x, y, this.position.x, this.position.y * imageScale, 0.0f, imageScale, imageScale);
        this.animator.setFrame((int)this.animeframe);
        batch.setColor(Color.WHITE);
        batch.draw(this.animator, this.transform);
    }
}

