/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization.entity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.optimization.entity.GameObject;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteSheet;
import edu.cornell.gdiac.util.RandomGenerator;

public class Shell
extends GameObject {
    private static float maxFriction;
    private static float minFriction;
    private static float maxVY;
    private static float minVY;
    private static float minVX;
    private static float maxVX;
    private static float gravity;
    private static float imageScale;
    private static float animationSpeed;
    private float friction = RandomGenerator.getFloat(minFriction, maxFriction);
    private float minSpeed = RandomGenerator.getFloat(minVY, maxVY);
    private float animeframe;
    private boolean damaged;
    private SpriteSheet dmgSprite;

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.SHELL;
    }

    public float getFriction() {
        return this.friction;
    }

    public float getMinVY() {
        return this.minSpeed;
    }

    @Override
    public void setDestroyed(boolean value) {
        if (value) {
            if (!this.damaged && this.dmgSprite != null) {
                this.animator = this.dmgSprite;
                this.dmgSprite = null;
            } else {
                this.destroyed = value;
            }
        } else {
            this.destroyed = value;
        }
    }

    public static void setConstants(JsonValue constants) {
        JsonValue frictionRange = constants.get("friction range");
        maxFriction = frictionRange.getFloat(1);
        minFriction = frictionRange.getFloat(0);
        JsonValue velRange = constants.get("x-velocity range");
        minVX = velRange.getFloat(0);
        maxVX = velRange.getFloat(1);
        velRange = constants.get("y-velocity range");
        minVY = velRange.getFloat(0);
        maxVY = velRange.getFloat(1);
        gravity = constants.getFloat("gravity", 0.0f);
        imageScale = constants.getFloat("image scale", 1.0f);
        animationSpeed = constants.getFloat("animation speed", 0.0f);
    }

    public Shell(float x, float y) {
        super(x, y);
        float vx = RandomGenerator.getFloat(minVX, maxVX);
        this.velocity.x = vx * (RandomGenerator.getFloat(0.0f, 1.0f) * 2.0f - 1.0f);
        this.animeframe = 0.0f;
    }

    @Override
    public void setSpriteSheet(SpriteSheet sheet) {
        super.setSpriteSheet(sheet);
        this.radius *= imageScale;
    }

    public void setDamagedSprite(SpriteSheet sheet) {
        this.dmgSprite = sheet;
    }

    public SpriteSheet getDamagedSprite() {
        return this.dmgSprite;
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        if (this.animator != null) {
            this.animeframe += animationSpeed;
            if (this.animeframe >= (float)this.animator.getSize()) {
                this.animeframe -= (float)this.animator.getSize();
            }
        }
        this.velocity.y -= gravity;
    }

    @Override
    public void draw(SpriteBatch batch) {
        this.animator.setFrame((int)this.animeframe);
        SpriteBatch.computeTransform(this.transform, this.origin.x, this.origin.y, this.position.x, this.position.y, 0.0f, imageScale, imageScale);
        batch.setColor(Color.WHITE);
        batch.draw(this.animator, this.transform);
    }
}

