/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization.entity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteSheet;

public abstract class GameObject {
    protected Vector2 position;
    protected Vector2 velocity;
    protected Vector2 origin;
    protected float radius;
    protected boolean destroyed;
    protected SpriteSheet animator;
    protected Affine2 transform;
    protected JsonValue constants;

    public void setSpriteSheet(SpriteSheet sheet) {
        this.animator = sheet;
        this.radius = (float)this.animator.getRegionHeight() / 2.0f;
        this.origin = new Vector2((float)this.animator.getRegionWidth() / 2.0f, (float)this.animator.getRegionHeight() / 2.0f);
    }

    public SpriteSheet getSpriteSheet() {
        return this.animator;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public float getX() {
        return this.position.x;
    }

    public void setX(float value) {
        this.position.x = value;
    }

    public float getY() {
        return this.position.y;
    }

    public void setY(float value) {
        this.position.y = value;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public float getVX() {
        return this.velocity.x;
    }

    public void setVX(float value) {
        this.velocity.x = value;
    }

    public float getVY() {
        return this.velocity.y;
    }

    public void setVY(float value) {
        this.velocity.y = value;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean value) {
        this.destroyed = value;
    }

    public float getRadius() {
        return this.radius;
    }

    public abstract ObjectType getType();

    public GameObject(float x, float y) {
        this.position = new Vector2(x, y);
        this.velocity = new Vector2(0.0f, 0.0f);
        this.radius = 0.0f;
        this.destroyed = false;
        this.transform = new Affine2();
    }

    public void update(float delta) {
        this.position.add(this.velocity);
    }

    public void draw(SpriteBatch batch) {
        SpriteBatch.computeTransform(this.transform, this.origin.x, this.origin.y, this.position.x, this.position.y, 0.0f, 1.0f, 1.0f);
        batch.setColor(Color.WHITE);
        batch.draw(this.animator, this.transform);
    }

    public static enum ObjectType {
        SHELL,
        SHIP,
        BULLET,
        STAR;

    }
}

