/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ScreenUtils;
import edu.cornell.cis3152.optimization.Scene;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.util.ScreenListener;

public class LoadingScene
implements Scene,
InputProcessor {
    private static int DEFAULT_BUDGET = 15;
    private AssetDirectory internal;
    private AssetDirectory assets;
    private OrthographicCamera camera;
    private Affine2 affine;
    private ScreenListener listener;
    private int width;
    private int height;
    JsonValue constants;
    private float scale;
    private float progress;
    private int pressState;
    private int budget;
    private boolean active;

    public int getBudget() {
        return this.budget;
    }

    public void setBudget(int millis) {
        this.budget = millis;
    }

    public boolean isReady() {
        return this.pressState == 2;
    }

    @Override
    public boolean exitScene() {
        return this.pressState == 2;
    }

    public AssetDirectory getAssets() {
        return this.assets;
    }

    public LoadingScene(String file) {
        this(file, DEFAULT_BUDGET);
    }

    public LoadingScene(String file, int millis) {
        this.budget = millis;
        this.internal = new AssetDirectory("loading/boot.json");
        this.internal.loadAssets();
        this.internal.finishLoading();
        this.constants = this.internal.getEntry("constants", JsonValue.class);
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.progress = 0.0f;
        this.pressState = 0;
        this.affine = new Affine2();
        Gdx.input.setInputProcessor(this);
        this.assets = new AssetDirectory(file);
        this.assets.loadAssets();
        this.active = true;
    }

    @Override
    public void dispose() {
        this.internal.unloadAssets();
        this.internal.dispose();
    }

    @Override
    public void update(float delta) {
        if (this.progress < 1.0f) {
            this.assets.update(this.budget);
            this.progress = this.assets.getProgress();
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    @Override
    public void draw(SpriteBatch batch) {
        ScreenUtils.clear(0.702f, 0.1255f, 0.145f, 1.0f);
        batch.begin(this.camera);
        batch.setColor(Color.WHITE);
        Texture texture = this.internal.getEntry("splash", Texture.class);
        batch.draw(texture, (float)((this.width - this.height) / 2), 0.0f, (float)this.height, (float)this.height);
        if (this.progress < 1.0f) {
            this.drawProgress(batch);
        } else {
            float cx = this.width / 2;
            float cy = (int)(this.constants.getFloat("bar.height") * (float)this.height);
            float s = this.constants.getFloat("button.scale") * this.scale;
            Color tint = this.pressState == 1 ? Color.GRAY : Color.WHITE;
            texture = this.internal.getEntry("play", Texture.class);
            SpriteBatch.computeTransform(this.affine, texture.getWidth() / 2, texture.getHeight() / 2, cx, cy, 0.0f, s, s);
            batch.setColor(tint);
            batch.draw(texture, this.affine);
        }
        batch.end();
    }

    private void drawProgress(SpriteBatch batch) {
        float w = (int)(this.constants.getFloat("bar.width") * (float)this.width);
        float cx = this.width / 2;
        float cy = (int)(this.constants.getFloat("bar.height") * (float)this.height);
        batch.setColor(Color.WHITE);
        TextureRegion region1 = this.internal.getEntry("progress.backleft", TextureRegion.class);
        batch.draw(region1, cx - w / 2.0f, cy, this.scale * (float)region1.getRegionWidth(), this.scale * (float)region1.getRegionHeight());
        TextureRegion region2 = this.internal.getEntry("progress.backright", TextureRegion.class);
        batch.draw(region2, cx + w / 2.0f - this.scale * (float)region2.getRegionWidth(), cy, this.scale * (float)region2.getRegionWidth(), this.scale * (float)region2.getRegionHeight());
        TextureRegion region3 = this.internal.getEntry("progress.background", TextureRegion.class);
        batch.draw(region3, cx - w / 2.0f + this.scale * (float)region1.getRegionWidth(), cy, w - this.scale * (float)(region2.getRegionWidth() + region1.getRegionWidth()), this.scale * (float)region3.getRegionHeight());
        region1 = this.internal.getEntry("progress.foreleft", TextureRegion.class);
        batch.draw(region1, cx - w / 2.0f, cy, this.scale * (float)region1.getRegionWidth(), this.scale * (float)region1.getRegionHeight());
        if (this.progress > 0.0f) {
            region2 = this.internal.getEntry("progress.foreright", TextureRegion.class);
            float span = this.progress * (w - this.scale * (float)(region1.getRegionWidth() + region2.getRegionWidth()));
            batch.draw(region2, cx - w / 2.0f + this.scale * (float)region1.getRegionWidth() + span, cy, this.scale * (float)region2.getRegionWidth(), this.scale * (float)region2.getRegionHeight());
            region3 = this.internal.getEntry("progress.foreground", TextureRegion.class);
            batch.draw(region3, cx - w / 2.0f + this.scale * (float)region1.getRegionWidth(), cy, span, this.scale * (float)region3.getRegionHeight());
        } else {
            region2 = this.internal.getEntry("progress.foreright", TextureRegion.class);
            batch.draw(region2, cx - w / 2.0f + this.scale * (float)region1.getRegionWidth(), cy, this.scale * (float)region2.getRegionWidth(), this.scale * (float)region2.getRegionHeight());
        }
    }

    @Override
    public void resize(int width, int height) {
        this.scale = (float)height / this.constants.getFloat("height");
        this.width = width;
        this.height = height;
        if (this.camera == null) {
            this.camera = new OrthographicCamera();
        }
        this.camera.setToOrtho(false, width, height);
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        float s;
        float radius;
        if (this.progress < 1.0f || this.pressState == 2) {
            return true;
        }
        float cx = this.width / 2;
        float cy = (int)(this.constants.getFloat("bar.height") * (float)this.height);
        float dist = ((float)screenX - cx) * ((float)screenX - cx) + ((float)(screenY = this.height - screenY) - cy) * ((float)screenY - cy);
        if (dist < (radius = (s = this.constants.getFloat("button.scale") * this.scale) * (float)this.internal.getEntry("play", Texture.class).getWidth() / 2.0f) * radius) {
            this.pressState = 1;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.pressState == 1) {
            this.pressState = 2;
            return false;
        }
        return true;
    }

    @Override
    public boolean keyDown(int keycode) {
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        return true;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return true;
    }

    @Override
    public boolean scrolled(float dx, float dy) {
        return true;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return true;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return true;
    }
}

