/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.util.Controllers;
import edu.cornell.gdiac.util.XBoxController;

public class InputController {
    protected boolean resetPressed;
    protected boolean floodPressed;
    protected boolean exitPressed;
    private boolean firePressed;
    private float offset;
    private XBoxController xbox;

    public float getMovement() {
        return this.offset;
    }

    public boolean didFire() {
        return this.firePressed;
    }

    public boolean didReset() {
        return this.resetPressed;
    }

    public boolean didFlood() {
        return this.floodPressed;
    }

    public boolean didExit() {
        return this.exitPressed;
    }

    public InputController() {
        Array<XBoxController> controllers = Controllers.get().getXBoxControllers();
        this.xbox = controllers.size > 0 ? controllers.get(0) : null;
    }

    public void sync() {
        if (this.xbox != null && this.xbox.isConnected()) {
            this.readGamepad();
            this.readKeyboard(true);
        } else {
            this.readKeyboard(false);
        }
    }

    private void readGamepad() {
        this.resetPressed = this.xbox.getA();
        this.floodPressed = this.xbox.getRBumper();
        this.exitPressed = this.xbox.getBack();
        this.offset = this.xbox.getLeftX();
        this.firePressed = this.xbox.getRightTrigger() > 0.6f;
    }

    private void readKeyboard(boolean secondary) {
        this.resetPressed = secondary && this.resetPressed || Gdx.input.isKeyPressed(46);
        this.floodPressed = secondary && this.floodPressed || Gdx.input.isKeyPressed(34);
        this.exitPressed = secondary && this.exitPressed || Gdx.input.isKeyPressed(111);
        float f = this.offset = secondary ? this.offset : 0.0f;
        if (Gdx.input.isKeyPressed(22)) {
            this.offset += 1.0f;
        }
        if (Gdx.input.isKeyPressed(21)) {
            this.offset -= 1.0f;
        }
        this.firePressed = secondary && this.firePressed || Gdx.input.isKeyPressed(62);
    }
}

