/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.optimization.InputController;
import edu.cornell.cis3152.optimization.entity.Bullet;
import edu.cornell.cis3152.optimization.entity.GameObject;
import edu.cornell.cis3152.optimization.entity.Shell;
import edu.cornell.cis3152.optimization.entity.Ship;
import edu.cornell.cis3152.optimization.entity.Star;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteSheet;
import edu.cornell.gdiac.util.RandomGenerator;

public class GameplayController {
    private SpriteSheet beetleSprite;
    private SpriteSheet starSprite;
    private SpriteSheet bulletSprite;
    private SpriteSheet greenSprite;
    private SpriteSheet redSprite;
    private JsonValue constants;
    private Ship player;
    private int shellCount;
    private Array<GameObject> objects;
    private Array<GameObject> backing;

    public GameplayController(JsonValue constants, AssetDirectory directory) {
        this.constants = constants;
        this.player = null;
        this.shellCount = 0;
        this.objects = new Array();
        this.backing = new Array();
        this.beetleSprite = directory.getEntry("beetle.animation", SpriteSheet.class);
        this.bulletSprite = directory.getEntry("bullet.animation", SpriteSheet.class);
        this.starSprite = directory.getEntry("star.animation", SpriteSheet.class);
        this.redSprite = directory.getEntry("red.animation", SpriteSheet.class);
        this.greenSprite = directory.getEntry("green.animation", SpriteSheet.class);
        Bullet.setConstants(constants.get("bullet"));
        Shell.setConstants(constants.get("shell"));
        Ship.setConstants(constants.get("ship"));
        Star.setConstants(constants.get("star"));
    }

    public Array<GameObject> getObjects() {
        return this.objects;
    }

    public Ship getPlayer() {
        return this.player;
    }

    public boolean isAlive() {
        return this.player != null;
    }

    public int getShellCount() {
        return this.shellCount;
    }

    public void start(float x, float y) {
        this.player = new Ship(x, y);
        this.player.setSpriteSheet(this.beetleSprite);
        this.objects.add(this.player);
    }

    public void reset() {
        this.player = null;
        this.shellCount = 0;
        this.objects.clear();
    }

    public void addShell(float width, float height) {
        Shell b = new Shell(RandomGenerator.getFloat(0.0f, width), height);
        if (RandomGenerator.getInt(0, 2) == 0) {
            b.setSpriteSheet(this.redSprite);
            b.setDamagedSprite(this.greenSprite);
        } else {
            b.setSpriteSheet(this.greenSprite);
            b.setDamagedSprite(null);
        }
        this.objects.add(b);
        ++this.shellCount;
    }

    public void garbageCollect() {
        for (GameObject o : this.objects) {
            if (o.isDestroyed()) {
                this.destroy(o);
                continue;
            }
            this.backing.add(o);
        }
        Array<GameObject> tmp = this.backing;
        this.backing = this.objects;
        this.objects = tmp;
        this.backing.clear();
    }

    protected void destroy(GameObject o) {
        switch (o.getType()) {
            case SHIP: {
                this.player = null;
                break;
            }
            case SHELL: {
                for (int j = 0; j < 6; ++j) {
                    Star s = new Star(o.getX(), o.getY());
                    s.initVelocity(o.getVX(), o.getVY());
                    s.setSpriteSheet(this.starSprite);
                    this.backing.add(s);
                }
                --this.shellCount;
                break;
            }
        }
    }

    public void resolveActions(InputController input, float delta) {
        if (this.player != null) {
            this.resolvePlayer(input, delta);
        }
        for (GameObject o : this.objects) {
            o.update(delta);
        }
    }

    public void resolvePlayer(InputController input, float delta) {
        this.player.setMovement(input.getMovement());
        this.player.setFiring(input.didFire());
        this.player.update(delta);
        if (!this.player.isFiring()) {
            return;
        }
        Bullet b = new Bullet(this.player.getX(), this.player.getY() + this.player.getRadius());
        b.setSpriteSheet(this.bulletSprite);
        this.backing.add(b);
        this.player.resetCooldown();
    }
}

