/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ScreenUtils;
import edu.cornell.cis3152.optimization.CollisionController;
import edu.cornell.cis3152.optimization.GameplayController;
import edu.cornell.cis3152.optimization.InputController;
import edu.cornell.cis3152.optimization.Scene;
import edu.cornell.cis3152.optimization.entity.GameObject;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.TextLayout;
import edu.cornell.gdiac.util.RandomGenerator;
import edu.cornell.gdiac.util.ScreenListener;

public class GameScene
implements Scene {
    private static final int TARGET_FPS = 60;
    private JsonValue constants;
    private Texture background;
    private BitmapFont displayFont;
    private TextLayout counter;
    private TextLayout gameover;
    private TextLayout fpsmeter;
    private float timeModifier;
    private float counterOffset;
    private float fpsOffset;
    private float verticalPos;
    private OrthographicCamera camera;
    private int width;
    private int height;
    private int fps;
    private InputController inputController;
    private CollisionController physicsController;
    private GameplayController gameplayController;
    private GameState gameState;
    private float totalTime = 0.0f;
    private boolean active;
    private ScreenListener listener;

    public GameScene(AssetDirectory assets) {
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.active = false;
        this.gameState = GameState.INTRO;
        this.constants = assets.getEntry("constants", JsonValue.class);
        this.background = assets.getEntry("background", Texture.class);
        this.displayFont = assets.getEntry("times", BitmapFont.class);
        this.timeModifier = this.constants.get("background").getFloat("time modifier", 0.0f);
        this.counterOffset = this.constants.get("background").getFloat("counter offset", 0.0f);
        this.verticalPos = this.constants.get("background").getFloat("vertical pos", 0.0f);
        this.fpsOffset = this.constants.get("background").getFloat("fps offset", 0.0f);
        this.counter = new TextLayout();
        this.counter.setFont(this.displayFont);
        this.counter.setAlignment(10);
        this.fpsmeter = new TextLayout();
        this.fpsmeter.setFont(this.displayFont);
        this.fpsmeter.setAlignment(10);
        this.gameover = new TextLayout();
        this.gameover.setFont(this.displayFont);
        this.gameover.setAlignment(33);
        this.gameover.setText("Game Over!\nPress R to Restart");
        this.gameover.layout();
        this.inputController = new InputController();
        this.gameplayController = new GameplayController(this.constants, assets);
        this.physicsController = new CollisionController(this.constants, this.width, this.height);
    }

    @Override
    public void dispose() {
        this.inputController = null;
        this.gameplayController = null;
        this.physicsController = null;
    }

    @Override
    public void update(float delta) {
        this.fps = Math.round(1.0f / delta);
        if (this.fps >= 59) {
            this.fps = 60;
        }
        this.inputController.sync();
        switch (this.gameState) {
            case INTRO: {
                this.gameState = GameState.PLAY;
                this.gameplayController.start((float)this.width / 2.0f, this.physicsController.getFloorLedge());
                break;
            }
            case OVER: {
                if (this.inputController.didReset()) {
                    this.gameState = GameState.PLAY;
                    this.gameplayController.reset();
                    this.gameplayController.start((float)this.width / 2.0f, this.physicsController.getFloorLedge());
                    break;
                }
                this.play(delta);
                break;
            }
            case PLAY: {
                this.play(delta);
                break;
            }
        }
    }

    protected void play(float delta) {
        if (!this.gameplayController.isAlive()) {
            this.gameState = GameState.OVER;
        }
        if (RandomGenerator.getInt(0, 25) == 0 || this.inputController.didFlood()) {
            this.gameplayController.addShell(this.width, this.height);
        }
        this.gameplayController.resolveActions(this.inputController, delta);
        this.totalTime += delta * 1000.0f;
        float offset = (float)this.width - this.totalTime * this.timeModifier % (float)this.width;
        this.physicsController.processCollisions(this.gameplayController.getObjects(), (int)offset);
        this.gameplayController.garbageCollect();
    }

    @Override
    public void draw(SpriteBatch batch) {
        float offset = -(this.totalTime * this.timeModifier % (float)this.width);
        ScreenUtils.clear(Color.BLACK);
        batch.begin(this.camera);
        batch.setColor(Color.WHITE);
        batch.setBlendMode(SpriteBatch.BlendMode.ALPHA_BLEND);
        float w = this.background.getWidth();
        batch.draw(this.background, offset, this.verticalPos);
        batch.draw(this.background, offset + w, this.verticalPos);
        for (GameObject o : this.gameplayController.getObjects()) {
            o.draw(batch);
        }
        String message = "Current shells: " + this.gameplayController.getShellCount();
        this.counter.setText(message);
        this.counter.layout();
        batch.drawText(this.counter, this.counterOffset, (float)this.height - this.counterOffset);
        String fpsrate = "FPS: " + this.fps;
        this.fpsmeter.setText(fpsrate);
        this.fpsmeter.layout();
        batch.drawText(this.fpsmeter, (float)this.width - this.fpsOffset, (float)this.height - this.counterOffset);
        if (this.gameState == GameState.OVER) {
            batch.drawText(this.gameover, (float)this.width / 2.0f, (float)this.height / 2.0f);
        }
        batch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.camera == null) {
            this.camera = new OrthographicCamera();
        }
        this.camera.setToOrtho(false, width, height);
        if (this.physicsController != null) {
            this.physicsController.resize(width, height);
        }
    }

    @Override
    public boolean exitScene() {
        return this.inputController.didExit();
    }

    public static enum GameState {
        INTRO,
        PLAY,
        OVER;

    }
}

