/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import edu.cornell.cis3152.optimization.GameScene;
import edu.cornell.cis3152.optimization.LoadingScene;
import edu.cornell.cis3152.optimization.Scene;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;

public class GDXRoot
extends ApplicationAdapter {
    AssetDirectory directory;
    private SpriteBatch batch;
    private LoadingScene loading;
    private GameScene playing;
    private Scene active;
    private long timeElapsed;

    @Override
    public void create() {
        this.loading = new LoadingScene("assets.json", 1);
        this.active = this.loading;
        this.batch = new SpriteBatch();
    }

    @Override
    public void dispose() {
        if (this.loading != null) {
            this.loading.dispose();
            this.loading = null;
        }
        if (this.playing != null) {
            this.playing.dispose();
            this.playing = null;
        }
        this.batch.dispose();
        this.batch = null;
        if (this.directory != null) {
            this.directory.unloadAssets();
            this.directory.dispose();
            this.directory = null;
        }
        super.dispose();
    }

    @Override
    public void render() {
        long time = System.currentTimeMillis();
        float delta = (float)(time - this.timeElapsed) / 1000.0f;
        this.timeElapsed = time;
        if (this.active.exitScene()) {
            if (this.loading != null) {
                this.directory = this.loading.getAssets();
                this.loading.dispose();
                this.loading = null;
                this.playing = new GameScene(this.directory);
                this.active = this.playing;
            } else {
                Gdx.app.exit();
            }
        }
        this.active.update(delta);
        this.active.draw(this.batch);
    }

    @Override
    public void resize(int width, int height) {
        if (this.loading != null) {
            this.loading.resize(width, height);
        }
        if (this.playing != null) {
            this.playing.resize(width, height);
        }
        super.resize(width, height);
    }
}

