/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.optimization;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.optimization.entity.Bullet;
import edu.cornell.cis3152.optimization.entity.GameObject;
import edu.cornell.cis3152.optimization.entity.Shell;
import edu.cornell.cis3152.optimization.entity.Ship;
import edu.cornell.cis3152.optimization.entity.Star;

public class CollisionController {
    private float width;
    private float height;
    private JsonValue constants;
    private float boxRestitution;
    private float bumpRestitution;
    private float bottomOffset;
    private float boxCenter;
    private float bumpCenter;
    private float boxWidth;
    private float boxHeight;
    private float bumpRadius;
    private Array<GameObject>[] cells;
    private int size;
    private int stride;
    private float celldim;
    private Vector2 temp1 = new Vector2();
    private Vector2 temp2 = new Vector2();

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getFloorLedge() {
        return this.bottomOffset * this.height;
    }

    public float getBoxX() {
        return this.boxCenter * this.width;
    }

    public float getBoxRadius() {
        return this.boxWidth * this.width / 2.0f;
    }

    public float getBoxHeight() {
        return this.boxHeight * this.height;
    }

    protected float getBumpX() {
        return this.bumpCenter * this.width;
    }

    protected float getBumpRadius() {
        return this.bumpRadius * this.width;
    }

    public CollisionController(JsonValue constants, float width, float height) {
        this.bottomOffset = constants.get("background").getFloat("ledge height");
        this.boxCenter = constants.get("box").getFloat("position");
        this.boxWidth = constants.get("box").getFloat("width");
        this.boxHeight = constants.get("box").getFloat("height");
        this.boxRestitution = constants.get("box").getFloat("restitution");
        this.bumpCenter = constants.get("bump").getFloat("position");
        this.bumpRadius = constants.get("bump").getFloat("radius");
        this.bumpRestitution = constants.get("bump").getFloat("restitution");
        this.celldim = constants.get("optimization").getFloat("cell size");
        this.stride = (int)Math.ceil(width / this.celldim);
        int ysize = (int)Math.ceil(height / this.celldim);
        this.size = this.stride * ysize;
        this.cells = new Array[this.size];
        for (int ii = 0; ii < this.size; ++ii) {
            this.cells[ii] = new Array();
        }
        this.resize(width, height);
    }

    public void resize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public void processCollisions(Array<GameObject> objects, int offset) {
        this.buildCells(objects);
        this.processCells();
        for (GameObject o : objects) {
            this.processBounds(o, offset);
        }
    }

    private void buildCells(Array<GameObject> objects) {
        for (int ii = 0; ii < this.size; ++ii) {
            this.cells[ii].clear();
        }
        for (GameObject o : objects) {
            if (o.isDestroyed()) continue;
            this.add(o);
        }
    }

    private void add(GameObject o) {
        if (Float.isNaN(o.getX()) || Float.isNaN(o.getY())) {
            return;
        }
        if (o.getX() >= 0.0f && o.getX() <= this.width && o.getY() >= 0.0f && o.getY() <= this.height) {
            int x = (int)Math.floor(o.getX() / this.celldim);
            int y = (int)Math.floor(o.getY() / this.celldim);
            x = x >= this.stride ? x - 1 : x;
            y = this.stride * y + x >= this.cells.length ? y - 1 : y;
            this.cells[this.stride * y + x].add(o);
        }
    }

    public void processCells() {
        for (int ii = 0; ii < this.size; ++ii) {
            boolean toprow = ii < this.stride;
            boolean leftcol = ii % this.stride == 0;
            Array.ArrayIterator<GameObject> iterator = new Array.ArrayIterator<GameObject>(this.cells[ii]);
            while (iterator.hasNext()) {
                GameObject go = iterator.next();
                if (!toprow && !leftcol) {
                    for (GameObject target : this.cells[ii - (this.stride + 1)]) {
                        this.processCollision(go, target);
                    }
                }
                if (!toprow) {
                    for (GameObject target : this.cells[ii - this.stride]) {
                        this.processCollision(go, target);
                    }
                }
                if (!leftcol) {
                    for (GameObject target : this.cells[ii - 1]) {
                        this.processCollision(go, target);
                    }
                }
                for (GameObject target : this.cells[ii]) {
                    if (go.equals(target)) continue;
                    this.processCollision(go, target);
                }
            }
        }
    }

    private void processBounds(GameObject o, int offset) {
        switch (o.getType()) {
            case SHELL: {
                this.handleBounds((Shell)o, offset);
                break;
            }
            case STAR: {
                this.handleBounds((Star)o);
                break;
            }
            case BULLET: {
                this.handleBounds((Bullet)o);
                break;
            }
            case SHIP: {
                this.handleBounds((Ship)o);
                break;
            }
        }
    }

    private void handleBounds(Shell sh, int offset) {
        this.hitBox(sh, (float)offset + this.getBoxX() - this.getWidth());
        this.hitBox(sh, (float)offset + this.getBoxX());
        this.hitBox(sh, (float)offset + this.getBoxX() + this.getWidth());
        this.hitBump(sh, (float)offset + this.getBumpX() - this.getWidth());
        this.hitBump(sh, (float)offset + this.getBumpX());
        this.hitBump(sh, (float)offset + this.getBumpX() + this.getWidth());
        if (sh.getX() > this.getWidth() - sh.getRadius()) {
            sh.setX(2.0f * (this.getWidth() - sh.getRadius()) - sh.getX());
            sh.setVX(-sh.getVX());
        } else if (sh.getX() < sh.getRadius()) {
            sh.setX(2.0f * sh.getRadius() - sh.getX());
            sh.setVX(-sh.getVX());
        }
        if (sh.getY() - sh.getRadius() < this.getFloorLedge()) {
            sh.setY(this.getFloorLedge() + sh.getRadius());
            sh.setVY(-sh.getVY());
            sh.setVY(Math.max(sh.getMinVY(), sh.getVY() * sh.getFriction()));
        }
    }

    private void handleBounds(Star st) {
    }

    private void handleBounds(Bullet bu) {
        if (bu.getY() <= 0.0f) {
            bu.setDestroyed(true);
        }
    }

    private void handleBounds(Ship sh) {
        if (sh.getX() <= sh.getRadius()) {
            sh.setX(sh.getRadius());
        } else if (sh.getX() >= this.getWidth() - sh.getRadius()) {
            sh.setX(this.getWidth() - sh.getRadius());
        }
    }

    private void hitBox(GameObject o, float x) {
        if (Math.abs(o.getX() - x) < this.getBoxRadius() && o.getY() < this.getBoxHeight()) {
            if (o.getX() + o.getRadius() > x + this.getBoxRadius()) {
                o.setX(x + this.getBoxRadius() + o.getRadius());
                o.setVX(-o.getVX());
            } else if (o.getX() - o.getRadius() < x - this.getBoxRadius()) {
                o.setX(x - this.getBoxRadius() - o.getRadius());
                o.setVX(-o.getVX());
            } else {
                o.setVY(-o.getVY() * this.boxRestitution);
                o.setY(this.getBoxHeight() + o.getRadius());
            }
        }
    }

    public void hitBump(GameObject o, float x) {
        float dy;
        float dx = o.getX() - x;
        float dist = (float)Math.sqrt(dx * dx + (dy = o.getY() - this.getFloorLedge()) * dy);
        if (dist < 0.1f * this.width) {
            float norm_x = dx / dist;
            float norm_y = Math.abs(dy / dist);
            float tmp = (o.getVX() * norm_x + o.getVY() * norm_y) * this.bumpRestitution;
            o.getVelocity().sub(norm_x * tmp, norm_y * tmp);
            o.setY(this.getFloorLedge() + norm_y * this.getBumpRadius());
        }
    }

    private void processCollision(GameObject o1, GameObject o2) {
        block0 : switch (o1.getType()) {
            case SHELL: {
                switch (o2.getType()) {
                    case SHELL: {
                        this.resolveCollision((Shell)o1, (Shell)o2);
                        break block0;
                    }
                    case STAR: {
                        this.resolveCollision((Shell)o1, (Star)o2);
                        break block0;
                    }
                    case BULLET: {
                        this.resolveCollision((Shell)o1, (Bullet)o2);
                        break block0;
                    }
                    case SHIP: {
                        this.resolveCollision((Shell)o1, (Ship)o2);
                        break block0;
                    }
                }
                break;
            }
            case STAR: {
                switch (o2.getType()) {
                    case SHELL: {
                        this.resolveCollision((Shell)o2, (Star)o1);
                        break block0;
                    }
                    case STAR: {
                        this.resolveCollision((Star)o1, (Star)o2);
                        break block0;
                    }
                    case BULLET: {
                        this.resolveCollision((Star)o1, (Bullet)o2);
                        break block0;
                    }
                    case SHIP: {
                        this.resolveCollision((Star)o1, (Ship)o2);
                        break block0;
                    }
                }
                break;
            }
            case BULLET: {
                switch (o2.getType()) {
                    case SHELL: {
                        this.resolveCollision((Shell)o2, (Bullet)o1);
                        break block0;
                    }
                    case STAR: {
                        this.resolveCollision((Star)o2, (Bullet)o1);
                        break block0;
                    }
                    case BULLET: {
                        this.resolveCollision((Bullet)o1, (Bullet)o2);
                        break block0;
                    }
                    case SHIP: {
                        this.resolveCollision((Bullet)o1, (Ship)o2);
                        break block0;
                    }
                }
                break;
            }
            case SHIP: {
                switch (o2.getType()) {
                    case SHELL: {
                        this.resolveCollision((Shell)o2, (Ship)o1);
                        break block0;
                    }
                    case STAR: {
                        this.resolveCollision((Star)o2, (Ship)o1);
                        break block0;
                    }
                    case BULLET: {
                        this.resolveCollision((Bullet)o2, (Ship)o1);
                        break block0;
                    }
                    case SHIP: {
                        this.resolveCollision((Ship)o1, (Ship)o2);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void resolveCollision(Shell s1, Shell s2) {
        if (s1.isDestroyed() || s2.isDestroyed()) {
            return;
        }
        this.temp1.set(s1.getPosition()).sub(s2.getPosition());
        float dist = this.temp1.len();
        if (dist > s1.getRadius() + s2.getRadius()) {
            return;
        }
        float distToPush = 0.01f + (s1.getRadius() + s2.getRadius() - dist) / 2.0f;
        this.temp1.nor();
        this.temp1.scl(distToPush);
        s1.getPosition().add(this.temp1);
        s2.getPosition().sub(this.temp1);
        this.temp1.set(s2.getPosition()).sub(s1.getPosition()).nor();
        this.temp2.set(s1.getPosition()).sub(s2.getPosition()).nor();
        this.temp1.scl(this.temp1.dot(s1.getVelocity()));
        this.temp2.scl(this.temp2.dot(s2.getVelocity()));
        s1.getVelocity().sub(this.temp1).add(this.temp2);
        s2.getVelocity().sub(this.temp2).add(this.temp1);
    }

    private void resolveCollision(Shell se, Star st) {
        if (se.isDestroyed() || st.isDestroyed()) {
            return;
        }
        this.temp1.set(se.getPosition()).sub(st.getPosition());
        float dist = this.temp1.len();
        if (dist > se.getRadius() + st.getRadius()) {
            return;
        }
        this.temp1.nor();
        float dot = this.temp1.dot(se.getVelocity());
        this.temp1.scl(dot);
        se.getVelocity().sub(this.temp1.scl(this.bumpRestitution));
        se.setDestroyed(true);
        st.setDestroyed(true);
    }

    private void resolveCollision(Shell se, Bullet bu) {
        if (se.isDestroyed() || bu.isDestroyed()) {
            return;
        }
        this.temp1.set(se.getPosition()).sub(bu.getPosition());
        float dist = this.temp1.len();
        if (dist > se.getRadius() + bu.getRadius()) {
            return;
        }
        this.temp1.nor();
        float dot = this.temp1.dot(se.getVelocity());
        this.temp1.scl(dot);
        se.getVelocity().sub(this.temp1.scl(this.bumpRestitution));
        se.setDestroyed(true);
        bu.setDestroyed(true);
    }

    private void resolveCollision(Shell se, Ship sh) {
        if (se.isDestroyed() || sh.isDestroyed()) {
            return;
        }
        this.temp1.set(se.getPosition()).sub(sh.getPosition());
        float dist = this.temp1.len();
        if (dist > se.getRadius() + sh.getRadius()) {
            return;
        }
        se.setDestroyed(true);
        sh.setDestroyed(true);
    }

    private void resolveCollision(Star s1, Star s2) {
    }

    private void resolveCollision(Star st, Bullet bu) {
    }

    private void resolveCollision(Star st, Ship sh) {
    }

    private void resolveCollision(Bullet b1, Bullet b2) {
    }

    private void resolveCollision(Bullet bu, Ship sh) {
    }

    private void resolveCollision(Ship s1, Ship s2) {
    }
}

