/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;

public class Stencil {
    public static final int STENCIL_NONE = 0;
    public static final int STENCIL_LOWER = 1;
    public static final int STENCIL_UPPER = 2;
    public static final int STENCIL_BOTH = 3;

    public static void clearBuffer(int buffer) {
        GL30 gl = Gdx.gl30;
        switch (buffer) {
            case 0: {
                return;
            }
            case 1: {
                gl.glStencilMask(240);
                gl.glClear(1024);
                gl.glStencilMask(255);
                return;
            }
            case 2: {
                gl.glStencilMask(15);
                gl.glClear(1024);
                gl.glStencilMask(255);
                return;
            }
            case 3: {
                gl.glStencilMask(255);
                gl.glClear(1024);
                return;
            }
        }
    }

    public static void applyEffect(Effect effect) {
        GL20 gl = Gdx.gl30;
        if (gl == null) {
            gl = Gdx.gl20;
        }
        switch (effect) {
            case NATIVE: {
                break;
            }
            case NONE: {
                gl.glDisable(2960);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case CLIP: 
            case CLIP_JOIN: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(517, 0, 255);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case MASK: 
            case MASK_JOIN: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(514, 0, 255);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case FILL: 
            case FILL_JOIN: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(517, 0, 255);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case WIPE: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(519, 0, 255);
                gl.glStencilOp(0, 0, 0);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case STAMP: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(519, 0, 255);
                gl.glStencilOpSeparate(1028, 7680, 7680, 34055);
                gl.glStencilOpSeparate(1029, 7680, 7680, 34056);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CARVE: 
            case CARVE_NONE: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 0, 240);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CLAMP: 
            case CLAMP_NONE: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 0, 240);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case NONE_CLIP: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(517, 0, 15);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case NONE_MASK: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 0, 15);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case NONE_FILL: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(517, 0, 15);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case NONE_WIPE: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(519, 0, 15);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case NONE_STAMP: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(519, 0, 15);
                gl.glStencilOpSeparate(1028, 7680, 7680, 5386);
                gl.glStencilOpSeparate(1029, 7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case NONE_CARVE: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 0, 15);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case NONE_CLAMP: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 0, 15);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case CLIP_NONE: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(517, 0, 240);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case CLIP_MEET: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(514, 255, 255);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case CLIP_MASK: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(514, 240, 255);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case CLIP_FILL: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(517, 0, 255);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case CLIP_WIPE: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(517, 0, 240);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CLIP_STAMP: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(517, 0, 240);
                gl.glStencilOpSeparate(1028, 7680, 7680, 5386);
                gl.glStencilOpSeparate(1029, 7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CLIP_CARVE: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 240, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CLIP_CLAMP: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 240, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case MASK_NONE: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(514, 0, 240);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case MASK_MEET: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(517, 255, 255);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case MASK_CLIP: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(514, 15, 255);
                gl.glStencilOp(7680, 7680, 7680);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case MASK_FILL: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 15, 255);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case MASK_WIPE: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 0, 240);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case MASK_STAMP: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 0, 240);
                gl.glStencilOpSeparate(1028, 7680, 7680, 5386);
                gl.glStencilOpSeparate(1029, 7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case MASK_CARVE: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 0, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case MASK_CLAMP: {
                gl.glEnable(2960);
                gl.glStencilMask(15);
                gl.glStencilFunc(514, 0, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case FILL_NONE: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(517, 0, 240);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case FILL_MEET: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 255, 255);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case FILL_CLIP: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 255, 255);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case FILL_MASK: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 240, 255);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case WIPE_NONE: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(519, 0, 240);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case WIPE_CLIP: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(517, 0, 15);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case WIPE_MASK: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 0, 15);
                gl.glStencilOp(7680, 7680, 0);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case STAMP_NONE: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(519, 0, 15);
                gl.glStencilOpSeparate(1028, 7680, 7680, 5386);
                gl.glStencilOpSeparate(1029, 7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case STAMP_CLIP: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(517, 0, 15);
                gl.glStencilOpSeparate(1028, 7680, 7680, 5386);
                gl.glStencilOpSeparate(1029, 7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case STAMP_MASK: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 0, 15);
                gl.glStencilOpSeparate(1028, 7680, 7680, 5386);
                gl.glStencilOpSeparate(1029, 7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case STAMP_BOTH: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(519, 0, 255);
                gl.glStencilOpSeparate(1028, 7680, 7680, 5386);
                gl.glStencilOpSeparate(1029, 7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CARVE_CLIP: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(517, 15, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CARVE_MASK: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 15, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CARVE_BOTH: {
                gl.glEnable(2960);
                gl.glStencilMask(255);
                gl.glStencilFunc(514, 0, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(false, false, false, false);
                break;
            }
            case CLAMP_CLIP: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 15, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(true, true, true, true);
                break;
            }
            case CLAMP_MASK: {
                gl.glEnable(2960);
                gl.glStencilMask(240);
                gl.glStencilFunc(514, 0, 255);
                gl.glStencilOp(7680, 7680, 5386);
                gl.glColorMask(true, true, true, true);
            }
        }
    }

    public static enum Effect {
        NATIVE,
        NONE,
        CLIP,
        MASK,
        FILL,
        WIPE,
        STAMP,
        CARVE,
        CLAMP,
        NONE_CLIP,
        NONE_MASK,
        NONE_FILL,
        NONE_WIPE,
        NONE_STAMP,
        NONE_CARVE,
        NONE_CLAMP,
        CLIP_JOIN,
        CLIP_MEET,
        CLIP_NONE,
        CLIP_MASK,
        CLIP_FILL,
        CLIP_WIPE,
        CLIP_STAMP,
        CLIP_CARVE,
        CLIP_CLAMP,
        MASK_JOIN,
        MASK_MEET,
        MASK_NONE,
        MASK_CLIP,
        MASK_FILL,
        MASK_WIPE,
        MASK_STAMP,
        MASK_CARVE,
        MASK_CLAMP,
        FILL_JOIN,
        FILL_MEET,
        FILL_NONE,
        FILL_MASK,
        FILL_CLIP,
        WIPE_NONE,
        WIPE_MASK,
        WIPE_CLIP,
        STAMP_NONE,
        STAMP_CLIP,
        STAMP_MASK,
        STAMP_BOTH,
        CARVE_NONE,
        CARVE_CLIP,
        CARVE_MASK,
        CARVE_BOTH,
        CLAMP_NONE,
        CLAMP_CLIP,
        CLAMP_MASK;

    }
}

