/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class Scissor {
    private Affine2 scissor = new Affine2();
    private Affine2 inverse = new Affine2();
    private Affine2 transform = new Affine2();
    private Rectangle bounds = new Rectangle();
    private float fringe;

    public Scissor() {
        this.scissor = new Affine2();
        this.inverse = new Affine2();
        this.transform = new Affine2();
        this.bounds = new Rectangle();
        this.setZero();
    }

    public Scissor(Scissor mask) {
        this.set(mask);
    }

    public Scissor(float x, float y, float w, float h) {
        this();
        this.set(x, y, w, h, 0.0f);
    }

    public Scissor(Rectangle rect) {
        this();
        this.set(rect.x, rect.y, rect.width, rect.height, 0.0f);
    }

    public Scissor(float x, float y, float w, float h, float fringe) {
        this();
        this.set(w, y, w, h, fringe);
    }

    public Scissor(Rectangle rect, float fringe) {
        this();
        this.set(rect, fringe);
    }

    public Scissor(Rectangle rect, Affine2 aff, float fringe) {
        this();
        this.set(rect, aff, fringe);
    }

    public Scissor(Rectangle rect, Matrix4 mat, float fringe) {
        this();
        this.set(rect, mat, fringe);
    }

    public Scissor setZero() {
        this.inverse.idt();
        this.transform.idt();
        this.bounds.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.fringe = 1.0f;
        return this;
    }

    public Scissor set(Scissor mask) {
        this.scissor.set(mask.scissor);
        this.inverse.set(mask.inverse);
        this.transform.set(mask.transform);
        this.bounds.set(mask.bounds);
        this.fringe = mask.fringe;
        return this;
    }

    public Scissor set(float x, float y, float w, float h, float fringe) {
        this.transform.idt();
        this.bounds.set(x, y, w, h);
        this.fringe = fringe;
        this.recompute();
        return this;
    }

    public Scissor set(Rectangle rect, float fringe) {
        this.transform.idt();
        this.bounds.set(rect);
        this.fringe = fringe;
        this.recompute();
        return this;
    }

    public Scissor set(Rectangle rect, Affine2 aff, float fringe) {
        this.transform.set(aff);
        this.bounds.set(rect);
        this.fringe = fringe;
        this.recompute();
        return this;
    }

    public Scissor set(Rectangle rect, Matrix4 mat, float fringe) {
        this.transform.set(mat);
        this.bounds = rect;
        this.fringe = fringe;
        this.recompute();
        return this;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public void setBounds(Rectangle bounds) {
        this.bounds.set(bounds);
        this.recompute();
    }

    public Affine2 getTransform() {
        return new Affine2(this.transform);
    }

    public void setTransform(Affine2 transform) {
        this.transform = transform;
        this.recompute();
    }

    public void setTransform(Matrix4 transform) {
        this.transform.set(transform);
        this.recompute();
    }

    public float getFringe() {
        return this.fringe;
    }

    public void setFringe(float fringe) {
        this.fringe = fringe;
    }

    public Scissor rotate(float angle) {
        this.transform.rotate(angle);
        this.recompute();
        return this;
    }

    public Scissor scale(float value) {
        if (value == 0.0f) {
            this.setZero();
        } else {
            this.transform.scale(value, value);
        }
        this.recompute();
        return this;
    }

    public Scissor scale(Vector2 s) {
        if (s.x == 0.0f || s.y == 0.0f) {
            this.setZero();
        } else {
            this.transform.scale(s);
        }
        this.recompute();
        return this;
    }

    public Scissor scale(float sx, float sy) {
        if (sx == 0.0f || sy == 0.0f) {
            this.setZero();
        } else {
            this.transform.scale(sx, sy);
        }
        this.recompute();
        return this;
    }

    public Scissor translate(Vector2 t) {
        this.transform.translate(t);
        this.recompute();
        return this;
    }

    public Scissor translate(float tx, float ty) {
        this.transform.translate(tx, ty);
        this.recompute();
        return this;
    }

    public Scissor mul(Matrix4 mat) {
        Affine2 aff = new Affine2();
        aff.set(mat);
        return this.mul(aff);
    }

    public Scissor mul(Affine2 mat) {
        this.transform.mul(mat);
        this.recompute();
        return this;
    }

    private void rectIntersect(Rectangle rect1, Rectangle rect2) {
        float minX = Math.max(rect1.getX(), rect2.getX());
        float minY = Math.max(rect1.getY(), rect2.getY());
        float maxX = Math.min(rect1.getX() + rect1.getWidth(), rect2.getX() + rect2.getWidth());
        float maxY = Math.min(rect1.getY() + rect1.getHeight(), rect2.getY() + rect2.getHeight());
        if (maxX - minX < 0.0f || maxY - minY < 0.0f) {
            maxY = 0.0f;
            minY = 0.0f;
            maxX = 0.0f;
            minX = 0.0f;
        }
        rect1.set(minX, minY, maxX - minX, maxY - minY);
    }

    private void rectTransform(Rectangle rect, Affine2 transform) {
        Affine2 trans = new Affine2();
        Vector2 off = new Vector2();
        rect.getCenter(off);
        trans.translate(off);
        trans.mul(transform);
        Vector2 size = new Vector2();
        size = rect.getSize(size);
        off = new Vector2(size.x / 2.0f, size.y / 2.0f);
        off.set(off.x * Math.abs(trans.m00) + off.y * Math.abs(trans.m02), off.x * Math.abs(trans.m01) + off.y * Math.abs(trans.m10));
        rect.setX(trans.m11 - off.x);
        rect.setY(trans.m12 - off.y);
        rect.setSize(off.x * 2.0f, off.y * 2.0f);
    }

    public Scissor intersect(Scissor mask) {
        Affine2 transform = this.transform;
        transform.inv();
        this.transform.mul(transform);
        this.rectTransform(mask.bounds, transform);
        this.rectIntersect(this.bounds, mask.bounds);
        this.recompute();
        return this;
    }

    Scissor getIntersection(Scissor mask) {
        Affine2 transform = this.transform;
        transform.inv();
        transform.preMul(mask.transform);
        Scissor result = new Scissor(this);
        this.rectTransform(mask.bounds, transform);
        this.rectIntersect(result.bounds, mask.bounds);
        result.recompute();
        return result;
    }

    public float[] getData(float[] array, int offset) {
        array[offset] = this.inverse.m00;
        array[offset + 1] = this.inverse.m10;
        array[offset + 2] = 0.0f;
        array[offset + 3] = 0.0f;
        array[offset + 4] = this.inverse.m01;
        array[offset + 5] = this.inverse.m11;
        array[offset + 6] = 0.0f;
        array[offset + 7] = 0.0f;
        array[offset + 8] = this.inverse.m02;
        array[offset + 9] = this.inverse.m12;
        array[offset + 10] = 1.0f;
        array[offset + 11] = 0.0f;
        array[offset + 12] = this.bounds.width / 2.0f;
        array[offset + 13] = this.bounds.height / 2.0f;
        array[offset + 14] = (float)Math.sqrt(this.scissor.m00 * this.scissor.m00 + this.scissor.m01 * this.scissor.m01) / this.fringe;
        array[offset + 15] = (float)Math.sqrt(this.scissor.m10 * this.scissor.m10 + this.scissor.m11 * this.scissor.m11) / this.fringe;
        return array;
    }

    public float[] getComponents(float[] array, int offset) {
        array[offset] = this.inverse.m00;
        array[offset + 1] = this.inverse.m10;
        array[offset + 2] = 0.0f;
        array[offset + 3] = this.inverse.m01;
        array[offset + 4] = this.inverse.m11;
        array[offset + 5] = 0.0f;
        array[offset + 6] = this.inverse.m02;
        array[offset + 7] = this.inverse.m12;
        array[offset + 8] = 1.0f;
        array[offset + 9] = this.bounds.width / 2.0f;
        array[offset + 10] = this.bounds.height / 2.0f;
        array[offset + 11] = (float)Math.sqrt(this.scissor.m00 * this.scissor.m00 + this.scissor.m01 * this.scissor.m01) / this.fringe;
        array[offset + 12] = (float)Math.sqrt(this.scissor.m10 * this.scissor.m10 + this.scissor.m11 * this.scissor.m11) / this.fringe;
        return array;
    }

    public String toString() {
        Object result = "Scissor\n";
        result = (String)result + String.format("|  %.4f, %.4f, %.4f  |   |  %.4f | \n", Float.valueOf(this.scissor.m00), Float.valueOf(this.scissor.m01), Float.valueOf(this.scissor.m02), Float.valueOf(this.bounds.width / 2.0f));
        result = (String)result + String.format("|  %.4f, %.4f, %.4f  |;  |  %.4f |; ", Float.valueOf(this.scissor.m10), Float.valueOf(this.scissor.m11), Float.valueOf(this.scissor.m12), Float.valueOf(this.bounds.height / 2.0f));
        float a = (float)Math.sqrt(this.scissor.m00 * this.scissor.m00 + this.scissor.m01 * this.scissor.m01) / this.fringe;
        float b = (float)Math.sqrt(this.scissor.m10 * this.scissor.m10 + this.scissor.m11 * this.scissor.m11) / this.fringe;
        result = (String)result + String.format(" %.4f x %.4f", Float.valueOf(a), Float.valueOf(b));
        return result;
    }

    void recompute() {
        this.scissor.idt();
        this.scissor.preTranslate(this.bounds.x + this.bounds.width / 2.0f, this.bounds.y + this.bounds.height / 2.0f);
        this.scissor.mul(this.transform);
        this.inverse.set(this.scissor);
        this.inverse.inv();
    }
}

