/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.backend.audio;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import edu.cornell.gdiac.audio.AudioSource;
import edu.cornell.gdiac.audio.AudioStream;
import edu.cornell.gdiac.backend.audio.WavInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WavSource
implements AudioSource {
    protected FileHandle source;
    protected int channels;
    protected int sampleRate;
    protected float duration;
    protected long byteSize;
    protected WavInputStream input;

    public WavSource(FileHandle file) {
        this.source = file;
        this.input = new WavInputStream(file);
        this.channels = this.input.channels;
        this.sampleRate = this.input.sampleRate;
        this.byteSize = this.input.dataRemaining;
        long samples = this.byteSize / (long)(2 * this.channels);
        this.duration = (float)samples / (float)this.sampleRate;
    }

    @Override
    public void dispose() {
        this.input = null;
        this.source = null;
        this.channels = 0;
        this.sampleRate = 0;
        this.duration = 0.0f;
        this.byteSize = 0L;
    }

    @Override
    public FileHandle getFile() {
        return this.source;
    }

    @Override
    public int getChannels() {
        return this.channels;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public AudioStream getStream() {
        return new Stream();
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer result = null;
        try {
            if (this.input == null) {
                this.input = new WavInputStream(this.source);
            }
            result = ByteBuffer.allocateDirect((int)this.byteSize);
            result.order(ByteOrder.nativeOrder());
            StreamUtils.copyStream((InputStream)this.input, result, (int)this.byteSize);
        }
        catch (IOException e) {
            result = null;
        }
        finally {
            StreamUtils.closeQuietly(this.input);
        }
        return result;
    }

    public String toString() {
        return "'" + this.getFile().toString() + " [" + String.format("@%x", this.hashCode()) + "]'";
    }

    public class Stream
    implements AudioStream {
        private WavInputStream input;
        private long byteOffs;
        private byte[] tempBytes;

        public Stream() {
            this.input = new WavInputStream(WavSource.this.source);
            this.byteOffs = 0L;
        }

        @Override
        public AudioSource getSource() {
            return WavSource.this;
        }

        @Override
        public long getByteSize() {
            return WavSource.this.byteSize;
        }

        @Override
        public long getByteOffset() {
            return this.byteOffs;
        }

        @Override
        public long getSampleSize() {
            return WavSource.this.byteSize / 2L;
        }

        @Override
        public long getSampleOffset() {
            return this.byteOffs / 2L;
        }

        @Override
        public int read(byte[] buffer) {
            if (this.input == null) {
                this.input = new WavInputStream(WavSource.this.source);
            }
            try {
                int chunk = this.input.read(buffer);
                this.byteOffs += (long)chunk;
                return chunk;
            }
            catch (IOException ex) {
                throw new GdxRuntimeException("Error reading WAV file: " + WavSource.this.source, ex);
            }
        }

        @Override
        public int read(short[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.read(this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                buffer[ii] = (short)(upper << 8 | lower);
            }
            return length / 2;
        }

        @Override
        public int read(float[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.read(this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                short value = (short)(upper << 8 | lower);
                buffer[ii] = (float)value / 32767.0f;
            }
            return length / 2;
        }

        @Override
        public int seek(long pos, byte[] buffer) {
            if (pos <= 0L || buffer.length <= 1) {
                throw new IllegalArgumentException("Illegal seek parameters");
            }
            byte[] temp = new byte[buffer.length / 2];
            if (pos < this.byteOffs) {
                StreamUtils.closeQuietly(this.input);
                this.input = new WavInputStream(WavSource.this.source);
                this.byteOffs = 0L;
            }
            try {
                int chunk = 1;
                while (chunk > 0 && this.byteOffs < pos) {
                    chunk = this.input.read(temp);
                    this.byteOffs += (long)chunk;
                }
                if (this.byteOffs < pos) {
                    this.reset();
                    return 0;
                }
                int mark = (int)(this.byteOffs - pos);
                System.arraycopy(temp, mark, buffer, 0, chunk - mark);
                mark = chunk - mark;
                chunk = this.input.read(temp);
                System.arraycopy(temp, 0, buffer, mark, chunk);
                return chunk + mark;
            }
            catch (Exception e) {
                this.reset();
                return 0;
            }
        }

        @Override
        public int seek(long pos, short[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.seek(pos, this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                buffer[ii] = (short)(upper << 8 | lower);
            }
            return length / 2;
        }

        @Override
        public int seek(long pos, float[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.seek(pos, this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                short value = (short)(upper << 8 | lower);
                buffer[ii] = (float)value / 32767.0f;
            }
            return length / 2;
        }

        @Override
        public void reset() {
            StreamUtils.closeQuietly(this.input);
            this.input = null;
            this.byteOffs = 0L;
        }

        @Override
        public void loop() {
            StreamUtils.closeQuietly(this.input);
            this.input = null;
            this.byteOffs = 0L;
        }
    }
}

