/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.MaterialLibLoader;
import edu.cornell.gdiac.assets.ObjModelLoader;
import edu.cornell.gdiac.graphics.obj.MaterialInfo;
import edu.cornell.gdiac.graphics.obj.Model;

public class ObjModelParser
implements AssetParser<Model> {
    private JsonValue root;
    private JsonValue obj;

    @Override
    public Class<Model> getType() {
        return Model.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.obj = this.root.getChild("objs");
    }

    @Override
    public boolean hasNext() {
        return this.obj != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        ObjModelLoader.ModelParameters params = new ObjModelLoader.ModelParameters();
        if (this.obj.isString()) {
            params.name = this.obj.name;
            params.source = this.obj.asString();
        } else {
            params.name = this.obj.name;
            params.source = this.obj.getString("file", null);
            if (this.obj.has("texture")) {
                String key = this.obj.getString("texture", "");
                String path = this.getTexturePath(key);
                if (path != null) {
                    params.material = new MaterialLibLoader.MaterialLibParameters();
                    params.material.name = key + ":__implicit__";
                    params.material.source = params.source + params.material.name;
                    params.material.material = new MaterialInfo();
                    params.material.material.Kd = Color.WHITE;
                    params.material.material.map_Kd = new MaterialInfo.LightMap();
                    params.material.material.map_Kd.name = key;
                    params.material.material.map_Kd.path = path;
                    params.material.textures.put(key, path);
                }
            } else if (this.obj.hasChild("mtllib")) {
                for (JsonValue mtl = this.obj.getChild("mtllib"); mtl != null; mtl = mtl.next()) {
                    if (!mtl.isString()) continue;
                    String key = mtl.asString();
                    String path = this.getMaterialPath(key);
                    params.libraries.put(mtl.name, path == null ? key : path);
                }
            }
        }
        keymap.put(this.obj.name(), params.source);
        manager.load(params.source, Model.class, params);
        this.obj = this.obj.next();
    }

    public boolean equals(Object o) {
        return o instanceof ObjModelParser;
    }

    private String getMaterialPath(String key) {
        for (JsonValue mtls = this.root.getChild("mtls"); mtls != null; mtls = mtls.next()) {
            if (!key.equals(mtls.name)) continue;
            if (mtls.isString()) {
                return mtls.asString();
            }
            return mtls.getString("file", null);
        }
        return null;
    }

    private String getTexturePath(String key) {
        for (JsonValue txts = this.root.getChild("textures"); txts != null; txts = txts.next()) {
            if (!key.equals(txts.name)) continue;
            if (txts.isString()) {
                return txts.asString();
            }
            return txts.getString("file", null);
        }
        return null;
    }
}

