/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.audio.AudioEngine;
import edu.cornell.gdiac.audio.AudioSource;
import edu.cornell.gdiac.audio.MusicQueue;

public class MusicQueueLoader
extends AsynchronousAssetLoader<MusicQueue, MusicQueueParameters> {
    private MusicQueue cachedBuffer;

    public MusicQueueLoader() {
        this(new InternalFileHandleResolver());
    }

    public MusicQueueLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    protected MusicQueue getLoadedMusic() {
        return this.cachedBuffer;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, MusicQueueParameters params) {
        if (params == null) {
            params = new MusicQueueParameters();
        }
        if (params.sources.size == 0) {
            this.cachedBuffer = ((AudioEngine)Gdx.audio).newMusicQueue(params.isMono, params.sampleRate);
        } else {
            AudioSource first = manager.get(manager.getDependencies(fileName).first(), AudioSource.class);
            this.cachedBuffer = ((AudioEngine)Gdx.audio).newMusicQueue(first.getChannels() == 1, first.getSampleRate());
        }
        this.cachedBuffer.setVolume(params.volume);
        this.cachedBuffer.setPitch(params.pitch);
        this.cachedBuffer.setPan(params.panning);
        this.cachedBuffer.setLooping(params.looping);
        this.cachedBuffer.setLoopBehavior(params.shortLoop);
        for (String deps : manager.getDependencies(fileName)) {
            this.cachedBuffer.addSource(manager.get(deps, AudioSource.class));
        }
    }

    @Override
    public MusicQueue loadSync(AssetManager manager, String fileName, FileHandle file, MusicQueueParameters params) {
        MusicQueue music = this.cachedBuffer;
        this.cachedBuffer = null;
        return music;
    }

    @Override
    public FileHandle resolve(String fileName) {
        return null;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, MusicQueueParameters params) {
        if (params == null) {
            params = new MusicQueueParameters();
        }
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>(params.sources.size);
        for (String name : params.sources) {
            deps.add(new AssetDescriptor<AudioSource>(name, AudioSource.class));
        }
        return deps;
    }

    public static class MusicQueueParameters
    extends AssetLoaderParameters<MusicQueue> {
        public Array<String> sources;
        public boolean isMono;
        public int sampleRate;
        public float volume;
        public float pitch;
        public float panning;
        public boolean looping;
        public boolean shortLoop;

        public MusicQueueParameters() {
            this(false, 44100);
        }

        public MusicQueueParameters(String fileName) {
            this(false, 0);
            this.sources.add(fileName);
        }

        public MusicQueueParameters(boolean isMono, int sampleRate) {
            this.isMono = isMono;
            this.sampleRate = sampleRate;
            this.sources = new Array();
            this.volume = 1.0f;
            this.pitch = 1.0f;
            this.panning = 0.0f;
            this.looping = false;
            this.shortLoop = false;
        }
    }
}

