/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.audio.AudioEngine;
import edu.cornell.gdiac.audio.AudioSource;

public class AudioSourceLoader
extends AsynchronousAssetLoader<AudioSource, AudioSourceParameters> {
    private AudioSource cachedSource;

    public AudioSourceLoader() {
        this(new InternalFileHandleResolver());
    }

    public AudioSourceLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    protected AudioSource getLoadedSource() {
        return this.cachedSource;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, AudioSourceParameters params) {
        this.cachedSource = ((AudioEngine)Gdx.audio).newSource(file);
    }

    @Override
    public AudioSource loadSync(AssetManager manager, String fileName, FileHandle file, AudioSourceParameters params) {
        AudioSource source = this.cachedSource;
        this.cachedSource = null;
        return source;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, AudioSourceParameters params) {
        return null;
    }

    public static class AudioSourceParameters
    extends AssetLoaderParameters<AudioSource> {
    }
}

