/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.ailab.Ship;
import edu.cornell.gdiac.graphics.obj.Material;
import edu.cornell.gdiac.graphics.obj.ModelRef;
import edu.cornell.gdiac.graphics.obj.ObjPipeline;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ShipList
implements Iterable<Ship> {
    private ModelRef enemyModel;
    private ModelRef playerModel;
    private ModelRef fireModel;
    private Ship[] ships;
    private float time;
    private ShipIterator iterator = new ShipIterator();

    public ShipList(JsonValue constants) {
        int size = constants.getInt("capacity");
        Ship.setConstants(constants);
        this.ships = new Ship[size];
        for (int ii = 0; ii < size; ++ii) {
            this.ships[ii] = new Ship(ii, 0.0f, 0.0f);
        }
    }

    public int size() {
        return this.ships.length;
    }

    public Ship get(int id) {
        return this.ships[id];
    }

    public Ship getPlayer() {
        return this.ships[0];
    }

    public int numActive() {
        int shipsActive = 0;
        for (Ship s : this) {
            if (!s.isActive()) continue;
            ++shipsActive;
        }
        return shipsActive;
    }

    public int numAlive() {
        int shipsAlive = 0;
        for (Ship s : this) {
            if (!s.isAlive()) continue;
            ++shipsAlive;
        }
        return shipsAlive;
    }

    public ModelRef getPlayerModel() {
        return this.playerModel;
    }

    public void setPlayerModel(ModelRef model) {
        this.playerModel = model;
    }

    public ModelRef getEnemyModel() {
        return this.enemyModel;
    }

    public void setEnemyModel(ModelRef model) {
        this.enemyModel = model;
    }

    public ModelRef getFireModel() {
        return this.fireModel;
    }

    public void setFireModel(ModelRef model) {
        this.fireModel = model;
    }

    public void draw(ObjPipeline pipeline) {
        Quaternion rot;
        float size;
        this.time += 0.05f;
        Gdx.gl20.glBlendFuncSeparate(1, 771, 770, 771);
        for (Ship s : this) {
            ModelRef model = s.getId() == 0 ? this.playerModel : this.enemyModel;
            size = s.getSize();
            rot = s.getRotation();
            model.setPosition(s.getX(), s.getY(), s.getFallDistance());
            model.setRotation(rot);
            model.setScale(size, size, size);
            pipeline.draw(model);
        }
        Gdx.gl20.glBlendFuncSeparate(770, 1, 1, 0);
        for (Ship s : this) {
            Material m = this.fireModel.getModel().getSurface(0).getMaterial();
            m.getDiffuseTint().a = this.generateNoise(this.time % 1.0f) * Math.min(1.0f, s.getVelocity().len2());
            size = s.getSize();
            rot = s.getRotation();
            this.fireModel.setPosition(s.getX(), s.getY(), s.getFallDistance());
            this.fireModel.setRotation(rot);
            this.fireModel.setScale(size, size, size);
            pipeline.draw(this.fireModel);
        }
    }

    private float generateNoise(float fx) {
        float noise = (float)(188768.0 * Math.pow(fx, 10.0));
        noise -= (float)(874256.0 * Math.pow(fx, 9.0));
        noise += (float)(1701310.0 * Math.pow(fx, 8.0));
        noise -= (float)(1804590.0 * Math.pow(fx, 7.0));
        noise += (float)(1130570.0 * Math.pow(fx, 6.0));
        noise -= (float)(422548.0 * Math.pow(fx, 5.0));
        noise += (float)(89882.7 * Math.pow(fx, 4.0));
        noise -= (float)(9425.33 * Math.pow(fx, 3.0));
        noise += (float)(276.413 * (double)fx * (double)fx);
        return noise += (float)(14.3214 * (double)fx);
    }

    @Override
    public Iterator<Ship> iterator() {
        this.iterator.pos = 0;
        return this.iterator;
    }

    private class ShipIterator
    implements Iterator<Ship> {
        public int pos = 0;

        private ShipIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < ShipList.this.ships.length;
        }

        @Override
        public Ship next() {
            if (this.pos >= ShipList.this.ships.length) {
                throw new NoSuchElementException();
            }
            int idx = this.pos;
            do {
                ++this.pos;
            } while (this.pos < ShipList.this.ships.length && !ShipList.this.ships[this.pos].isAlive());
            return ShipList.this.ships[idx];
        }
    }
}

