/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.JsonValue;
import java.util.Random;

public class Ship {
    private static final float FULL_CIRCLE = 360.0f;
    private static final float HALF_CIRCLE = 180.0f;
    private static float SHIP_SIZE;
    private static float MOVE_SPEED;
    private static float TURN_SPEED;
    private static int COOLDOWN;
    private static float FALL_RATE;
    private static float MIN_FALL;
    private static float MAX_FALL;
    private static float FALL_OFFSET;
    private static float FALL_X_SKEW;
    private static float FALL_Z_SKEW;
    private static float RAND_FACTOR;
    private static float RAND_OFFSET;
    private static float DRIFT_TOLER;
    private static float DRIFT_SPEED;
    private static float SPEED_DAMP;
    private static float EPSILON;
    private static final Random random;
    private int id;
    private Vector2 position;
    private Vector2 velocity;
    private float angle;
    private float dstAng;
    private boolean isAlive;
    public float fallAmount;
    private int fireCool;
    private Quaternion rotation;
    private Quaternion tempQuat;

    public static void setConstants(JsonValue constants) {
        SHIP_SIZE = constants.getFloat("diameter");
        MOVE_SPEED = constants.get("speed").getFloat(0);
        TURN_SPEED = constants.get("speed").getFloat(1);
        COOLDOWN = constants.getInt("cooldown");
        FALL_RATE = constants.getFloat("fall rate");
        MIN_FALL = constants.get("fall range").getFloat(0);
        MAX_FALL = constants.get("fall range").getFloat(1);
        FALL_OFFSET = constants.getFloat("fall offset");
        FALL_X_SKEW = constants.get("fall skew").getFloat(0);
        FALL_Z_SKEW = constants.get("fall skew").getFloat(2);
        RAND_FACTOR = constants.getFloat("random factor");
        RAND_OFFSET = RAND_FACTOR / 2.0f;
        DRIFT_TOLER = constants.get("drift").getFloat(0);
        DRIFT_SPEED = constants.get("drift").getFloat(1);
        SPEED_DAMP = constants.getInt("damping");
        EPSILON = constants.getInt("epsilon");
    }

    public Ship(int id, float x, float y) {
        this.id = id;
        this.position = new Vector2(x, y);
        this.velocity = new Vector2();
        this.angle = 90.0f;
        this.dstAng = 90.0f;
        this.isAlive = true;
        this.fallAmount = 0.0f;
        this.fireCool = 0;
        this.rotation = new Quaternion();
        this.tempQuat = new Quaternion();
    }

    public int getId() {
        return this.id;
    }

    public float getSize() {
        return SHIP_SIZE;
    }

    public float getX() {
        return this.position.x;
    }

    public void setX(float value) {
        this.position.x = value;
    }

    public float getY() {
        return this.position.y;
    }

    public void setY(float value) {
        this.position.y = value;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public float getVX() {
        return this.velocity.x;
    }

    public void setVX(float value) {
        this.velocity.x = value;
    }

    public float getVY() {
        return this.velocity.y;
    }

    public void setVY(float value) {
        this.velocity.y = value;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isActive() {
        return this.isAlive && this.fallAmount == 0.0f;
    }

    public boolean isFalling() {
        return this.fallAmount > 0.0f;
    }

    public float getFallDistance() {
        return this.fallAmount + FALL_OFFSET;
    }

    public void destroy() {
        this.fallAmount = MIN_FALL;
    }

    public void setAlive(boolean value) {
        this.isAlive = value;
    }

    public boolean canFire() {
        return this.fireCool <= 0;
    }

    public Quaternion getRotation() {
        this.rotation.set(Vector3.X, (float)Math.toDegrees(FALL_X_SKEW * this.fallAmount));
        this.tempQuat.set(Vector3.Z, this.angle + (float)Math.toDegrees(FALL_Z_SKEW * this.fallAmount));
        this.rotation.mul(this.tempQuat);
        this.tempQuat.set(Vector3.Y, 180.0f);
        this.rotation.mul(this.tempQuat);
        this.tempQuat.set(Vector3.X, 90.0f);
        this.rotation.mul(this.tempQuat);
        return this.rotation;
    }

    public void update(int controlCode) {
        boolean movingDown;
        if (!this.isAlive) {
            return;
        }
        if (this.fallAmount >= MIN_FALL) {
            this.fallAmount += FALL_RATE;
            this.isAlive = !(this.fallAmount > MAX_FALL);
            return;
        }
        boolean movingLeft = (controlCode & 1) != 0;
        boolean movingRight = (controlCode & 2) != 0;
        boolean movingUp = (controlCode & 4) != 0;
        boolean bl = movingDown = (controlCode & 8) != 0;
        if (movingLeft) {
            this.dstAng = 0.0f;
            this.velocity.x = -MOVE_SPEED;
            this.velocity.y = 0.0f;
        } else if (movingRight) {
            this.dstAng = 180.0f;
            this.velocity.x = MOVE_SPEED;
            this.velocity.y = 0.0f;
        } else if (movingUp) {
            this.dstAng = 90.0f;
            this.velocity.y = -MOVE_SPEED;
            this.velocity.x = 0.0f;
        } else if (movingDown) {
            this.dstAng = 270.0f;
            this.velocity.y = MOVE_SPEED;
            this.velocity.x = 0.0f;
        } else {
            this.velocity.x *= SPEED_DAMP;
            this.velocity.y *= SPEED_DAMP;
            if (Math.abs(this.velocity.x) < EPSILON) {
                this.velocity.x = 0.0f;
            }
            if (Math.abs(this.velocity.y) < EPSILON) {
                this.velocity.y = 0.0f;
            }
        }
        this.updateRotation();
    }

    private void updateRotation() {
        float angleDifference;
        if (this.angle > this.dstAng) {
            angleDifference = this.angle - this.dstAng;
            if (angleDifference <= TURN_SPEED) {
                this.angle = this.dstAng;
            } else {
                if (angleDifference == 180.0f) {
                    angleDifference += random.nextFloat() * RAND_FACTOR - RAND_OFFSET;
                }
                this.angle = angleDifference > 180.0f ? (this.angle += TURN_SPEED) : (this.angle -= TURN_SPEED);
            }
            this.velocity.setZero();
        } else if (this.angle < this.dstAng) {
            angleDifference = this.dstAng - this.angle;
            if (angleDifference <= TURN_SPEED) {
                this.angle = this.dstAng;
            } else {
                if (angleDifference == 180.0f) {
                    angleDifference += random.nextFloat() * RAND_FACTOR - RAND_OFFSET;
                }
                this.angle = angleDifference > 180.0f ? (this.angle -= TURN_SPEED) : (this.angle += TURN_SPEED);
            }
            this.velocity.setZero();
        }
        while (this.angle > 360.0f) {
            this.angle -= 360.0f;
        }
        while (this.angle < 0.0f) {
            this.angle += 360.0f;
        }
    }

    public void coolDown(boolean flag) {
        if (flag && this.fireCool > 0) {
            --this.fireCool;
        } else if (!flag) {
            this.fireCool = COOLDOWN;
        }
    }

    public void adjustForDrift(float x, float y) {
        if (this.velocity.x == 0.0f) {
            if (x < -DRIFT_TOLER) {
                this.position.x += DRIFT_SPEED;
            } else if (x > DRIFT_TOLER) {
                this.position.x -= DRIFT_SPEED;
            }
        }
        if (this.velocity.y == 0.0f) {
            if (y < -DRIFT_TOLER) {
                this.position.y += DRIFT_SPEED;
            } else if (y > DRIFT_TOLER) {
                this.position.y -= DRIFT_SPEED;
            }
        }
    }

    static {
        random = new Random();
    }
}

