/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import edu.cornell.cis3152.ailab.InputController;
import edu.cornell.gdiac.util.Controllers;
import edu.cornell.gdiac.util.XBoxController;

public class PlayerController
implements InputController {
    private boolean keyboard = true;
    private XBoxController xbox = null;

    public PlayerController() {
        Array<XBoxController> controllers = Controllers.get().getXBoxControllers();
        if (controllers.size > 0) {
            this.xbox = controllers.get(0);
            this.keyboard = false;
        }
    }

    @Override
    public int getAction() {
        int code = 0;
        if (this.keyboard) {
            if (Gdx.input.isKeyPressed(19)) {
                code |= 4;
            }
            if (Gdx.input.isKeyPressed(21)) {
                code |= 1;
            }
            if (Gdx.input.isKeyPressed(20)) {
                code |= 8;
            }
            if (Gdx.input.isKeyPressed(22)) {
                code |= 2;
            }
            if (Gdx.input.isKeyPressed(62)) {
                code |= 0x10;
            }
        } else {
            double ANALOG_THRESH = 0.3;
            double TRIGGER_THRESH = -0.75;
            if ((double)this.xbox.getLeftY() < -ANALOG_THRESH) {
                code |= 4;
            }
            if ((double)this.xbox.getLeftX() < -ANALOG_THRESH) {
                code |= 1;
            }
            if ((double)this.xbox.getLeftY() > ANALOG_THRESH) {
                code |= 8;
            }
            if ((double)this.xbox.getLeftX() > ANALOG_THRESH) {
                code |= 2;
            }
            if ((double)this.xbox.getRightTrigger() > TRIGGER_THRESH) {
                code |= 0x10;
            }
        }
        if ((code & 4) != 0 && (code & 1) != 0) {
            code ^= 4;
        }
        if ((code & 4) != 0 && (code & 2) != 0) {
            code ^= 2;
        }
        if ((code & 8) != 0 && (code & 2) != 0) {
            code ^= 8;
        }
        if ((code & 8) != 0 && (code & 1) != 0) {
            code ^= 1;
        }
        if ((code & 1) != 0 && (code & 2) != 0) {
            code ^= 3;
        }
        if ((code & 4) != 0 && (code & 8) != 0) {
            code ^= 0xC;
        }
        return code;
    }

    @Override
    public int getSelection() {
        int code = 0;
        if (this.keyboard) {
            if (Gdx.input.isKeyJustPressed(111)) {
                code |= 3;
            }
            if (Gdx.input.isKeyJustPressed(46)) {
                code |= 2;
            }
            for (int ii = 0; ii < 255; ++ii) {
                if (!Gdx.input.isKeyPressed(ii)) continue;
                code |= 1;
            }
        } else {
            if (this.xbox.getBack()) {
                code |= 3;
            }
            if (this.xbox.getStart()) {
                code |= 2;
            }
            if (this.xbox.getA() || this.xbox.getX() || this.xbox.getY() || this.xbox.getB() || this.xbox.getStart()) {
                code |= 1;
            }
        }
        return code;
    }
}

