/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;

public class Photon {
    private static float SHOT_SPEED;
    private static int MAX_AGE;
    private Color tint = new Color();
    private Vector2 position = new Vector2();
    private Vector2 velocity = new Vector2();
    private int life = -1;
    private boolean dirty = false;
    private int ship = -1;

    public static void setConstants(JsonValue constants) {
        SHOT_SPEED = constants.getFloat("speed");
        MAX_AGE = constants.getInt("lifespan");
    }

    public void set(int ship, float x, float y, float vx, float vy, Color color) {
        this.ship = ship;
        this.position.set(x, y);
        this.velocity.set(vx, vy).scl(SHOT_SPEED);
        this.tint.set(color);
        this.dirty = false;
        this.life = MAX_AGE;
    }

    public float getX() {
        return this.position.x;
    }

    public void setX(float value) {
        this.position.x = value;
    }

    public float getY() {
        return this.position.y;
    }

    public void setY(float value) {
        this.position.y = value;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public float getVX() {
        return this.velocity.x;
    }

    public void setVX(float value) {
        this.velocity.x = value;
    }

    public float getVY() {
        return this.velocity.y;
    }

    public void setVY(float value) {
        this.velocity.y = value;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public Color getColor() {
        return this.tint;
    }

    public int getSource() {
        return this.ship;
    }

    public boolean isAlive() {
        return this.life > 0;
    }

    public float getLifeRatio() {
        return (float)this.life / (float)MAX_AGE;
    }

    public void destroy() {
        this.life = 0;
        this.dirty = true;
    }

    public void age() {
        --this.life;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public float getPushX() {
        return this.velocity.x < -SHOT_SPEED * 0.5f ? -1.0f : (this.velocity.x > SHOT_SPEED * 0.5f ? 1.0f : 0.0f);
    }

    public float getPushY() {
        return this.velocity.y < -SHOT_SPEED * 0.5f ? -1.0f : (this.velocity.y > SHOT_SPEED * 0.5f ? 1.0f : 0.0f);
    }
}

