/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import edu.cornell.cis3152.ailab.GameSession;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.TextLayout;
import edu.cornell.gdiac.graphics.obj.ObjPipeline;

public class GraphicsPipeline {
    protected SpriteBatch spriteBatch;
    public ObjPipeline objPipeline;
    private int width;
    private int height;
    private OrthographicCamera spriteCamera;
    private PerspectiveCamera objCamera;
    private Texture background;
    private BitmapFont displayFont;
    private TextLayout displayLayout;
    private GameSession session;
    private float eyepan = 0.0f;
    private static final Vector3 UP_REVERSED = new Vector3(0.0f, -1.0f, 0.0f);
    private static final Interpolation.SwingIn SWING_IN = new Interpolation.SwingIn(0.1f);
    private static final float EYE_DIST = 400.0f;
    private static final float FOV = 80.0f;
    private static final float NEAR_DIST = 10.0f;
    private static final float FAR_DIST = 500.0f;
    private static final int CLIP_X = 500;
    private static final int CLIP_Y = 450;
    private static final float INIT_TARGET_PAN = 0.1f;
    private static final float INIT_EYE_PAN = 0.05f;
    private static final String MESSG_LOAD = "Loading...";
    private Vector3 target;
    private Vector3 eye;
    private Matrix4 proj;
    private Matrix4 view;
    private Matrix4 world;
    private Matrix4 tmpMat;
    private Vector3 tmp0 = new Vector3();
    private Vector3 tmp1 = new Vector3();
    private Vector2 tmp2d;

    public GraphicsPipeline() {
        this.spriteBatch = new SpriteBatch();
        this.spriteBatch.setBlendFunction(1, 771);
        this.objPipeline = new ObjPipeline();
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.eye = new Vector3();
        this.target = new Vector3();
    }

    public void dispose() {
        this.spriteBatch.dispose();
        this.spriteBatch = null;
    }

    public void resize(int w, int h) {
        this.width = w;
        this.height = h;
        if (this.spriteCamera == null) {
            this.spriteCamera = new OrthographicCamera();
        }
        this.spriteCamera.setToOrtho(false, w, h);
        this.spriteCamera.update();
        this.spriteBatch.setProjectionMatrix(this.spriteCamera.combined);
        if (this.objCamera == null) {
            this.objCamera = new PerspectiveCamera(80.0f, w, h);
            this.objCamera.up.set(UP_REVERSED);
            this.objCamera.near = 10.0f;
            this.objCamera.far = 500.0f;
            this.objCamera.update();
        } else {
            this.objCamera.viewportWidth = w;
            this.objCamera.viewportHeight = h;
            this.objCamera.update();
        }
    }

    public float getEyePan() {
        return this.eyepan;
    }

    public void setEyePan(float value) {
        this.eyepan = value;
    }

    public void setTarget(float x, float y) {
        this.target.set(x, y, 0.0f);
    }

    public BitmapFont getFont() {
        return this.displayFont;
    }

    public void setFont(BitmapFont font) {
        this.displayFont = font;
        if (font != null) {
            this.displayLayout = new TextLayout();
            this.displayLayout.setAlignment(33);
            this.displayLayout.setFont(font);
        }
    }

    public Texture getBackground() {
        return this.background;
    }

    public void setBackground(Texture background) {
        this.background = background;
    }

    public GameSession getSession() {
        return this.session;
    }

    public void setSession(GameSession session) {
        this.session = session;
    }

    public void render(String message) {
        Gdx.gl20.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl20.glClearDepthf(1.0f);
        Gdx.gl20.glClear(16640);
        this.updateCamera();
        if (this.background != null) {
            this.spriteBatch.begin();
            this.spriteBatch.setColor(Color.WHITE);
            this.spriteBatch.setBlendMode(SpriteBatch.BlendMode.ALPHA_BLEND);
            this.spriteBatch.draw(this.background, 0.0f, 0.0f, (float)this.width, (float)this.height);
            this.spriteBatch.end();
        }
        if (this.session != null) {
            this.objPipeline.begin(this.objCamera);
            Gdx.gl20.glEnable(3042);
            Gdx.gl20.glBlendFuncSeparate(1, 771, 770, 771);
            this.session.getBoard().draw(this.objPipeline);
            this.session.getShips().draw(this.objPipeline);
            this.session.getPhotons().draw(this.objPipeline);
            this.objPipeline.end();
        }
        if (message != null) {
            this.displayLayout.setText(message);
            this.displayLayout.layout();
            this.spriteBatch.begin();
            this.spriteBatch.setColor(Color.WHITE);
            this.spriteBatch.setBlendMode(SpriteBatch.BlendMode.ALPHA_BLEND);
            this.spriteBatch.drawText(this.displayLayout, this.width / 2, this.height / 2);
            this.spriteBatch.end();
        }
    }

    private void updateCamera() {
        if (this.eyepan < 1.0f) {
            this.tmp0.set(this.target);
            this.tmp1.set(this.tmp0).scl(0.1f);
            this.target.set(this.tmp1).interpolate(this.tmp0, this.eyepan, (Interpolation)SWING_IN);
            this.tmp0.add(0.0f, 10.0f, -400.0f);
            this.tmp1.set(this.tmp0).scl(0.05f);
            this.eye.set(this.tmp1).interpolate(this.tmp0, this.eyepan, (Interpolation)SWING_IN);
        } else {
            this.eye.set(this.target).add(0.0f, 10.0f, -400.0f);
        }
        this.objCamera.position.set(this.eye);
        this.objCamera.up.set(UP_REVERSED);
        this.objCamera.lookAt(this.target);
        this.objCamera.update();
    }
}

