/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.math.Vector2;
import edu.cornell.cis3152.ailab.AIController;
import edu.cornell.cis3152.ailab.Board;
import edu.cornell.cis3152.ailab.GameSession;
import edu.cornell.cis3152.ailab.InputController;
import edu.cornell.cis3152.ailab.PhotonPool;
import edu.cornell.cis3152.ailab.PlayerController;
import edu.cornell.cis3152.ailab.Ship;
import edu.cornell.cis3152.ailab.ShipList;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.audio.SoundEffectManager;
import java.util.Random;

public class GameplayController {
    private static final float DRIFT_TOLER = 1.0f;
    private static final float DRIFT_SPEED = 0.325f;
    private GameSession session;
    protected InputController[] controls;
    protected int playerAction;
    private Random random;
    private static final float NORMAL_ANGLE = 90.0f;
    private static final float POWER_ANGLE = 45.0f;
    private static final float HALF_CIRCLE = 180.0f;

    public GameplayController(GameSession session) {
        this.session = session;
        this.initShipPositions();
        ShipList ships = session.getShips();
        this.controls = new InputController[ships.size()];
        this.controls[0] = new PlayerController();
        for (int ii = 1; ii < ships.size(); ++ii) {
            this.controls[ii] = new AIController(ii, session);
        }
    }

    private void initShipPositions() {
        Board board = this.session.getBoard();
        ShipList ships = this.session.getShips();
        float px = board.boardToScreen(board.getWidth() / 2);
        float py = board.boardToScreen(board.getHeight() / 2);
        ships.get(0).getPosition().set(px, py);
        Vector2[] positions = new Vector2[board.getWidth() * board.getHeight() - 1];
        int ii = 0;
        for (int x = 0; x < board.getWidth(); ++x) {
            for (int y = 0; y < board.getHeight(); ++y) {
                if (x == board.getWidth() / 2 && y == board.getHeight() / 2) continue;
                positions[ii++] = new Vector2(x, y);
            }
        }
        this.random = new Random();
        Vector2 rTemp = new Vector2();
        for (ii = 0; ii < positions.length; ++ii) {
            int jj = this.random.nextInt(positions.length);
            rTemp.set(positions[ii]);
            positions[ii].set(positions[jj]);
            positions[jj].set(rTemp);
        }
        for (ii = 1; ii < ships.size(); ++ii) {
            Vector2 tile = positions[ii - 1];
            float sx = board.boardToScreen((int)tile.x);
            float sy = board.boardToScreen((int)tile.y);
            ships.get(ii).getPosition().set(sx, sy);
        }
    }

    public int getPlayerSelection() {
        return this.controls[0].getSelection();
    }

    public void update() {
        Board board = this.session.getBoard();
        ShipList ships = this.session.getShips();
        for (Ship s : ships) {
            float x = board.centerOffset(s.getX());
            float y = board.centerOffset(s.getY());
            s.adjustForDrift(x, y);
            this.checkForDeath(s);
            if (!s.isFalling() && this.controls[s.getId()] != null) {
                int action = this.controls[s.getId()].getAction();
                boolean firing = (action & 0x10) != 0;
                s.update(action);
                if (firing && s.canFire()) {
                    this.fireWeapon(s);
                    continue;
                }
                s.coolDown(true);
                continue;
            }
            s.update(0);
        }
        this.session.getBoard().update();
        this.session.getPhotons().update();
    }

    private void checkForDeath(Ship ship) {
        int ty;
        Board board = this.session.getBoard();
        if (!ship.isActive()) {
            return;
        }
        int tx = board.screenToBoard(ship.getX());
        if (!board.inBounds(tx, ty = board.screenToBoard(ship.getY())) || board.isDestroyedAt(tx, ty)) {
            SoundEffectManager sounds = SoundEffectManager.getInstance();
            SoundEffect fire = this.session.getSound("fall");
            sounds.play("fall", fire);
            ship.destroy();
        }
    }

    private void fireWeapon(Ship ship) {
        float y;
        Board board = this.session.getBoard();
        PhotonPool photons = this.session.getPhotons();
        float x = ship.getX();
        boolean isPower = board.isPowerTileAtScreen(x, y = ship.getY());
        float angPlus = isPower ? 45.0f : 90.0f;
        for (float fireAngle = 0.0f; fireAngle < 360.0f; fireAngle += angPlus) {
            float vx = (float)Math.cos((double)fireAngle * Math.PI / 180.0);
            float vy = (float)Math.sin((double)fireAngle * Math.PI / 180.0);
            photons.allocate(ship.getId(), x, y, vx, vy, isPower);
        }
        SoundEffectManager sounds = SoundEffectManager.getInstance();
        SoundEffect fire = this.session.getSound("fire");
        sounds.play("fire" + ship.getId(), fire);
        ship.coolDown(false);
    }
}

