/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.ailab.Board;
import edu.cornell.cis3152.ailab.PhotonPool;
import edu.cornell.cis3152.ailab.ShipList;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.graphics.obj.Material;
import edu.cornell.gdiac.graphics.obj.Model;
import edu.cornell.gdiac.graphics.obj.ModelRef;

public class GameSession {
    private AssetDirectory assets;
    private Board board;
    private ShipList ships;
    private PhotonPool photons;

    public GameSession(AssetDirectory assets) {
        this.assets = assets;
        this.reset();
    }

    public void reset() {
        this.board = new Board(this.assets.getEntry("board", JsonValue.class));
        Texture tileImage = this.assets.getEntry("tile", Texture.class);
        ModelRef tileModel = new ModelRef(this.assets.getEntry("tile", Model.class));
        tileModel.setMaterial(new Material(tileImage));
        this.board.setTile(tileModel);
        this.ships = new ShipList(this.assets.getEntry("ship", JsonValue.class));
        Texture playerImage = this.assets.getEntry("ship1", Texture.class);
        Texture enemyImage = this.assets.getEntry("ship2", Texture.class);
        ModelRef playerModel = new ModelRef(this.assets.getEntry("ship", Model.class));
        ModelRef enemyModel = new ModelRef(this.assets.getEntry("ship", Model.class));
        ModelRef fireModel = new ModelRef(this.assets.getEntry("fire", Model.class));
        playerModel.setMaterial(new Material(playerImage));
        enemyModel.setMaterial(new Material(enemyImage));
        this.ships.setPlayerModel(playerModel);
        this.ships.setEnemyModel(enemyModel);
        this.ships.setFireModel(fireModel);
        this.photons = new PhotonPool(this.assets.getEntry("photon", JsonValue.class));
        Texture photonImage = this.assets.getEntry("photon", Texture.class);
        ModelRef photonModel = new ModelRef(this.assets.getEntry("photon", Model.class));
        photonModel.setMaterial(new Material(photonImage));
        this.photons.setPhotonModel(photonModel);
    }

    public Board getBoard() {
        return this.board;
    }

    public ShipList getShips() {
        return this.ships;
    }

    public PhotonPool getPhotons() {
        return this.photons;
    }

    public SoundEffect getSound(String key) {
        return this.assets.getEntry(key, SoundEffect.class);
    }
}

