/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.math.Vector2;
import edu.cornell.cis3152.ailab.Board;
import edu.cornell.cis3152.ailab.GameSession;
import edu.cornell.cis3152.ailab.Photon;
import edu.cornell.cis3152.ailab.PhotonPool;
import edu.cornell.cis3152.ailab.Ship;
import edu.cornell.cis3152.ailab.ShipList;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.audio.SoundEffectManager;
import java.util.Random;

public class CollisionController {
    private static final float NUDGE_AMOUNT = 0.1f;
    private static final int NUDGE_LIMIT = 100;
    private GameSession session;
    private Vector2 tmp;
    private Random random;

    public CollisionController(GameSession session) {
        this.session = session;
        this.tmp = new Vector2();
        this.random = new Random();
    }

    public void update() {
        ShipList ships = this.session.getShips();
        PhotonPool photons = this.session.getPhotons();
        for (Ship s : ships) {
            if (!s.isActive()) continue;
            this.moveIfSafe(s);
        }
        int length = ships.size();
        for (int ii = 0; ii < length - 1; ++ii) {
            for (int jj = ii + 1; jj < length; ++jj) {
                this.checkForCollision(ships.get(ii), ships.get(jj));
            }
        }
        for (Ship s : ships) {
            for (Photon p : photons) {
                this.checkForCollision(s, p);
            }
        }
    }

    private void moveIfSafe(Ship ship) {
        Board board = this.session.getBoard();
        this.tmp.set(ship.getX(), ship.getY());
        boolean safeBefore = board.isSafeAtScreen(this.tmp.x, this.tmp.y);
        this.tmp.add(ship.getVX(), ship.getVY());
        boolean safeAfter = board.isSafeAtScreen(this.tmp.x, this.tmp.y);
        if (!safeBefore || safeAfter) {
            ship.getPosition().set(this.tmp);
        }
    }

    private void safeNudge(Ship ship) {
        int tileY;
        int tileX;
        Board board = this.session.getBoard();
        int i = 0;
        do {
            float xNudge = this.random.nextFloat() * 2.0f * 0.1f - 0.1f;
            float yNudge = this.random.nextFloat() * 2.0f * 0.1f - 0.1f;
            ship.setX(ship.getX() + xNudge);
            ship.setY(ship.getY() + yNudge);
        } while (!board.isSafeAt(tileX = board.screenToBoard(ship.getX()), tileY = board.screenToBoard(ship.getY())) && ++i < 100);
    }

    private void checkForCollision(Ship ship1, Ship ship2) {
        Board board = this.session.getBoard();
        if (!ship1.isActive() || !ship2.isActive()) {
            return;
        }
        int s1x = board.screenToBoard(ship1.getX());
        int s1y = board.screenToBoard(ship1.getY());
        int s2x = board.screenToBoard(ship2.getX());
        int s2y = board.screenToBoard(ship2.getY());
        if (s1x == s2x && s1y == s2y) {
            if (ship1.getX() == ship2.getX() && ship1.getY() == ship2.getY()) {
                this.safeNudge(ship1);
                this.safeNudge(ship2);
            }
            if (this.manhattan(ship1.getX(), ship1.getX(), board.boardToScreen(s1x), board.boardToScreen(s1y)) > this.manhattan(ship2.getX(), ship2.getX(), board.boardToScreen(s2x), board.boardToScreen(s2y)) && board.isSafeAtScreen(ship1.getX() + (ship1.getX() - ship2.getX()), ship1.getY() + (ship1.getY() - ship2.getY()))) {
                ship1.getPosition().add(ship1.getX() - ship2.getX(), ship1.getY() - ship2.getY());
            } else if (board.isSafeAtScreen(ship2.getX() + (ship2.getX() - ship1.getX()), ship2.getY() + (ship2.getY() - ship1.getY()))) {
                ship2.getPosition().add(ship2.getX() - ship1.getX(), ship2.getY() - ship1.getY());
            } else {
                this.safeNudge(ship1);
                this.safeNudge(ship2);
            }
        }
    }

    private void checkForCollision(Ship ship, Photon photon) {
        Board board = this.session.getBoard();
        PhotonPool photons = this.session.getPhotons();
        if (!ship.isActive()) {
            return;
        }
        if (ship.getId() == photon.getSource()) {
            return;
        }
        int sx = board.screenToBoard(ship.getX());
        int sy = board.screenToBoard(ship.getY());
        int px = board.screenToBoard(photon.getX());
        int py = board.screenToBoard(photon.getY());
        if (sx == px && sy == py) {
            board.destroyTileAt(sx, sy);
            float x = photon.getPushX() * (board.getTileSize() + board.getTileSpacing());
            float y = photon.getPushY() * (board.getTileSize() + board.getTileSpacing());
            ship.getPosition().add(x, y);
            photons.destroy(photon);
            SoundEffectManager sounds = SoundEffectManager.getInstance();
            SoundEffect fire = this.session.getSound("bump");
            sounds.play("bump", fire);
        }
    }

    private float manhattan(float x0, float y0, float x1, float y1) {
        return Math.abs(x1 - x0) + Math.abs(y1 - y0);
    }
}

