/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import edu.cornell.cis3152.ailab.Board;
import edu.cornell.cis3152.ailab.GameSession;
import edu.cornell.cis3152.ailab.InputController;
import edu.cornell.cis3152.ailab.Ship;
import edu.cornell.cis3152.ailab.ShipList;
import java.util.ArrayDeque;
import java.util.Random;

public class AIController
implements InputController {
    private static final int CHASE_DIST = 9;
    private static final int ATTACK_DIST = 4;
    private int id;
    private Ship ship;
    private Ship target;
    private GameSession session;
    private FSMState state;
    private int move;
    private long ticks;
    private int wx = 0;
    private int wy = 0;

    public AIController(int id) {
        this.id = id;
        this.state = FSMState.SPAWN;
        this.move = 0;
        this.ticks = 0L;
        this.target = null;
    }

    public AIController(int id, GameSession session) {
        this(id);
        this.setSession(session);
    }

    public void setSession(GameSession session) {
        this.session = session;
        this.ship = session.getShips().get(this.id);
        this.selectTarget();
    }

    @Override
    public int getSelection() {
        return 0;
    }

    @Override
    public int getAction() {
        ++this.ticks;
        if (((long)this.ship.getId() + this.ticks) % 10L == 0L) {
            this.changeStateIfApplicable();
            this.markGoalTiles();
            this.move = this.getMoveAlongPathToGoalTile();
        }
        int action = this.move;
        if (this.state == FSMState.ATTACK && this.canShootTarget()) {
            action |= 0x10;
        }
        return action;
    }

    private void changeStateIfApplicable() {
        Board board = this.session.getBoard();
        Random rand = new Random();
        int sx = board.screenToBoard(this.ship.getX());
        int sy = board.screenToBoard(this.ship.getY());
        switch (this.state) {
            case SPAWN: {
                int ty;
                int dieroll = rand.nextInt(4);
                if (dieroll != 0) {
                    this.state = FSMState.WANDER;
                    break;
                }
                this.selectTarget();
                if (this.target == null) {
                    this.state = FSMState.WANDER;
                    break;
                }
                int tx = board.screenToBoard(this.target.getX());
                if (this.manhattan(sx, sy, tx, ty = board.screenToBoard(this.target.getY())) > 4) {
                    this.state = FSMState.CHASE;
                    break;
                }
                this.state = FSMState.ATTACK;
                break;
            }
            case WANDER: {
                this.selectTarget();
                if (this.target != null) {
                    int ty;
                    int tx = board.screenToBoard(this.target.getX());
                    int dist = this.manhattan(sx, sy, tx, ty = board.screenToBoard(this.target.getY()));
                    if (dist <= 4) {
                        this.state = FSMState.ATTACK;
                        this.wx = -1;
                    } else if (dist <= 9) {
                        this.state = FSMState.CHASE;
                        this.wx = -1;
                    }
                }
                if (this.wx != sx || this.wy != sy) break;
                this.wx = -1;
                this.wy = -1;
                break;
            }
            case CHASE: {
                int ty;
                int dieroll = rand.nextInt(20);
                if (dieroll == 0 || this.target == null || !this.target.isActive()) {
                    this.state = FSMState.WANDER;
                    break;
                }
                int tx = board.screenToBoard(this.target.getX());
                if (this.manhattan(sx, sy, tx, ty = board.screenToBoard(this.target.getY())) > 4) break;
                this.state = FSMState.ATTACK;
                break;
            }
            case ATTACK: {
                int dieroll = rand.nextInt(100);
                if (this.target == null || !this.target.isActive()) {
                    this.state = FSMState.WANDER;
                } else {
                    int ty;
                    int tx = board.screenToBoard(this.target.getX());
                    if (this.manhattan(sx, sy, tx, ty = board.screenToBoard(this.target.getY())) > 4) {
                        this.state = FSMState.CHASE;
                        dieroll = rand.nextInt(2);
                    }
                }
                if (dieroll != 0) break;
                this.state = FSMState.WANDER;
                break;
            }
            default: {
                assert (false);
                this.state = FSMState.WANDER;
            }
        }
    }

    private void selectTarget() {
        Board board = this.session.getBoard();
        ShipList fleet = this.session.getShips();
        int curmin = Integer.MAX_VALUE;
        Ship curbest = null;
        int sx = board.screenToBoard(this.ship.getX());
        int sy = board.screenToBoard(this.ship.getY());
        for (Ship other : fleet) {
            int ty;
            int tx;
            int dist;
            if (other == this.ship || (dist = this.manhattan(sx, sy, tx = board.screenToBoard(other.getX()), ty = board.screenToBoard(other.getY()))) >= curmin || !other.isActive()) continue;
            curmin = dist;
            curbest = other;
        }
        this.target = curbest;
    }

    private boolean canShootTargetFrom(int x, int y) {
        Board board = this.session.getBoard();
        int tx = board.screenToBoard(this.target.getX());
        int ty = board.screenToBoard(this.target.getY());
        int dx = tx > x ? tx - x : x - tx;
        int dy = ty > y ? ty - y : y - ty;
        boolean power = board.isPowerTileAt(x, y);
        boolean canhit = dx <= 4 && dy == 0;
        canhit |= dx == 0 && dy <= 4;
        canhit |= power && dx == dy && dx <= 3;
        return canhit &= board.isSafeAt(x, y);
    }

    private boolean canShootTarget() {
        Board board = this.session.getBoard();
        int sx = board.screenToBoard(this.ship.getX());
        int sy = board.screenToBoard(this.ship.getY());
        return this.ship.canFire() && this.canShootTargetFrom(sx, sy);
    }

    private void markGoalTiles() {
        Board board = this.session.getBoard();
        board.clearMarks();
        boolean setGoal = false;
        switch (this.state) {
            case SPAWN: {
                setGoal = false;
                break;
            }
            case WANDER: {
                Random random = new Random();
                if (this.wx == -1) {
                    this.wx = random.nextInt(board.getWidth() - 1) + 1;
                    this.wy = random.nextInt(board.getHeight() - 1) + 1;
                }
                board.setGoal(this.wx, this.wy);
                setGoal = true;
                break;
            }
            case CHASE: {
                int tx = board.screenToBoard(this.target.getX());
                int ty = board.screenToBoard(this.target.getY());
                board.setGoal(tx, ty);
                setGoal = true;
                break;
            }
            case ATTACK: {
                int tx = board.screenToBoard(this.target.getX());
                int ty = board.screenToBoard(this.target.getY());
                int minx = tx < 4 ? 0 : tx - 4;
                int maxx = tx >= board.getWidth() - 4 ? board.getWidth() - 1 : tx + 4;
                int miny = ty < 4 ? 0 : ty - 4;
                int maxy = ty >= board.getHeight() - 4 ? board.getHeight() - 1 : ty + 4;
                for (int ii = minx; ii <= maxx; ++ii) {
                    for (int jj = miny; jj <= maxy; ++jj) {
                        if (!this.canShootTargetFrom(ii, jj)) continue;
                        board.setGoal(ii, jj);
                        setGoal = true;
                    }
                }
                if (setGoal) break;
                tx = board.screenToBoard(this.target.getX());
                ty = board.screenToBoard(this.target.getY());
                board.setGoal(tx, ty);
                setGoal = true;
            }
        }
        if (!setGoal) {
            int sx = board.screenToBoard(this.ship.getX());
            int sy = board.screenToBoard(this.ship.getY());
            board.setGoal(sx, sy);
        }
    }

    private int getMoveAlongPathToGoalTile() {
        Board board = this.session.getBoard();
        ArrayDeque<PathNode> queue = new ArrayDeque<PathNode>();
        PathNode curr = new PathNode(board.screenToBoard(this.ship.getX()), board.screenToBoard(this.ship.getY()), 0);
        queue.add(curr);
        board.setVisited(curr.x, curr.y);
        while (queue.size() != 0) {
            curr = (PathNode)queue.pollFirst();
            if (board.isGoal(curr.x, curr.y)) {
                return curr.act;
            }
            boolean horiz = this.choosePriority(curr);
            for (int ii = 0; ii < 2; ++ii) {
                for (int jj = 0; jj < 2; ++jj) {
                    PathNode next = new PathNode(curr.x, curr.y, curr.act);
                    if (ii == 0 && horiz || ii == 1 && !horiz) {
                        next.x = next.x + (jj == 0 ? -1 : 1);
                    } else {
                        next.y = next.y + (jj == 0 ? -1 : 1);
                    }
                    if (board.isVisited(next.x, next.y) || !board.isSafeAt(next.x, next.y)) continue;
                    int dir = ii == 0 && horiz || ii == 1 && !horiz ? (jj == 0 ? 1 : 2) : (jj == 0 ? 4 : 8);
                    next.act = curr.act == 0 ? dir : curr.act;
                    board.setVisited(next.x, next.y);
                    queue.add(next);
                }
            }
        }
        return 0;
    }

    private boolean choosePriority(PathNode curr) {
        Board board = this.session.getBoard();
        boolean horiz = true;
        if (this.state == FSMState.CHASE) {
            int dx = Math.abs(curr.x - board.screenToBoard(this.target.getX()));
            int dy = Math.abs(curr.y - board.screenToBoard(this.target.getY()));
            if (dy > dx) {
                horiz = false;
            }
        } else if (this.state == FSMState.ATTACK) {
            float a = this.ship.getAngle();
            horiz = 0.0f <= a && a < 45.0f || 135.0f < a && a < 225.0f || 335.0f < a && a <= 360.0f;
        }
        return horiz;
    }

    private int manhattan(int x0, int y0, int x1, int y1) {
        return Math.abs(x1 - x0) + Math.abs(y1 - y0);
    }

    private static enum FSMState {
        SPAWN,
        WANDER,
        CHASE,
        ATTACK;

    }

    private static class PathNode {
        public int x;
        public int y;
        public int act;

        public PathNode(int x, int y, int act) {
            this.x = x;
            this.y = y;
            this.act = act;
        }
    }
}

