/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2.layout;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.scene2.SceneNode;
import edu.cornell.gdiac.scene2.layout.Layout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FloatLayout
extends Layout {
    private static final String UNKNOWN_STR = "<unknown>";
    protected List<String> priority = new ArrayList<String>();
    protected Map<String, Entry> entries = new HashMap<String, Entry>();
    protected boolean horizontal;
    protected Alignment alignment;

    public FloatLayout() {
        this.alignment = Alignment.TOP_LEFT;
        this.horizontal = true;
    }

    public FloatLayout(JsonValue data) {
        String orient = data.getString("orientation", UNKNOWN_STR);
        this.horizontal = !orient.equals("vertical");
        String horz = data.getString("x_alignment", "middle");
        String vert = data.getString("y_alignment", "middle");
        this.alignment = Alignment.TOP_LEFT;
        if (horz.equals("left")) {
            this.alignment = vert.equals("top") ? Alignment.TOP_LEFT : (vert.equals("bottom") ? Alignment.BOTTOM_LEFT : Alignment.MIDDLE_LEFT);
        } else if (horz.equals("right")) {
            this.alignment = vert.equals("top") ? Alignment.TOP_RIGHT : (vert.equals("bottom") ? Alignment.BOTTOM_RIGHT : Alignment.MIDDLE_RIGHT);
        } else if (horz.equals("center")) {
            this.alignment = vert.equals("top") ? Alignment.TOP_CENTER : (vert.equals("bottom") ? Alignment.BOTTOM_CENTER : Alignment.CENTER);
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean value) {
        this.horizontal = value;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment value) {
        this.alignment = value;
    }

    @Override
    public boolean add(String key, JsonValue data) {
        if (this.entries.containsKey(key)) {
            assert (false) : String.format("key '%s' is already in use", key);
            return false;
        }
        Entry entry = new Entry();
        entry.priority = data.getLong("priority", -1L);
        if (data.has("padding")) {
            JsonValue padding = data.get("padding");
            assert (padding.size >= 2) : "'padding' must be a four element number array";
            entry.padLeft = padding.get(0).asFloat();
            entry.padRight = padding.get(2).asFloat();
            entry.padTop = padding.get(3).asFloat();
            entry.padBottom = padding.get(1).asFloat();
        } else {
            entry.padLeft = 0.0f;
            entry.padRight = 0.0f;
            entry.padTop = 0.0f;
            entry.padBottom = 0.0f;
        }
        this.entries.put(key, entry);
        this.priority.add(key);
        return true;
    }

    @Override
    public boolean remove(String key) {
        if (!this.entries.containsKey(key)) {
            return false;
        }
        this.entries.remove(key);
        int position = this.priority.indexOf(key);
        if (position != -1) {
            this.priority.remove(position);
        }
        return true;
    }

    @Override
    public void layout(SceneNode node) {
        if (this.horizontal) {
            this.layoutHorizontal(node);
        } else {
            this.layoutVertical(node);
        }
    }

    protected void layoutHorizontal(SceneNode node) {
        this.prioritize();
        Rectangle bounds = node.getLayoutBounds();
        Rectangle limit = new Rectangle();
        ArrayList<Float> height = new ArrayList<Float>();
        ArrayList<Float> width = new ArrayList<Float>();
        ArrayList<Integer> count = new ArrayList<Integer>();
        width.add(Float.valueOf(0.0f));
        height.add(Float.valueOf(0.0f));
        count.add(0);
        boolean stop = false;
        for (String key : this.priority) {
            if (stop) break;
            SceneNode child = node.getChildByName(key);
            if (child == null) continue;
            Vector2 extra = child.getSize();
            Entry entry = this.entries.get(key);
            if (entry != null) {
                extra.x += entry.padLeft + entry.padRight;
                extra.y += entry.padTop + entry.padBottom;
            }
            if (extra.x > bounds.width) {
                stop = true;
                continue;
            }
            if (((Float)width.get(width.size() - 1)).floatValue() + extra.x > bounds.width) {
                if (((Float)height.get(height.size() - 1)).floatValue() + extra.y > bounds.height) {
                    stop = true;
                    continue;
                }
                limit.width = Math.max(limit.width, ((Float)width.get(width.size() - 1)).floatValue());
                limit.height += ((Float)height.get(height.size() - 1)).floatValue();
                width.add(Float.valueOf(extra.x));
                height.add(Float.valueOf(extra.y));
                count.add(1);
                continue;
            }
            width.set(width.size() - 1, Float.valueOf(((Float)width.get(width.size() - 1)).floatValue() + extra.x));
            height.set(height.size() - 1, Float.valueOf(Math.max(extra.y, ((Float)height.get(height.size() - 1)).floatValue())));
            count.set(count.size() - 1, (Integer)count.get(count.size() - 1) + 1);
        }
        limit.width = Math.max(limit.width, ((Float)width.get(width.size() - 1)).floatValue());
        limit.height += ((Float)height.get(height.size() - 1)).floatValue();
        switch (this.alignment) {
            case BOTTOM_LEFT: {
                limit.setPosition(ZERO);
                break;
            }
            case BOTTOM_CENTER: {
                limit.setPosition(new Vector2((bounds.width - limit.width) / 2.0f, 0.0f));
                break;
            }
            case BOTTOM_RIGHT: {
                limit.setPosition(new Vector2(bounds.width - limit.width / 2.0f, 0.0f));
                break;
            }
            case MIDDLE_LEFT: {
                limit.setPosition(new Vector2(0.0f, (bounds.height - limit.height) / 2.0f));
                break;
            }
            case CENTER: {
                limit.setPosition(new Vector2((bounds.width - limit.width) / 2.0f, (bounds.height - limit.height) / 2.0f));
                break;
            }
            case MIDDLE_RIGHT: {
                limit.setPosition(new Vector2(bounds.width - limit.width, (bounds.height - limit.height) / 2.0f));
                break;
            }
            case TOP_LEFT: {
                limit.setPosition(new Vector2(0.0f, bounds.height - limit.height));
                break;
            }
            case TOP_CENTER: {
                limit.setPosition(new Vector2((bounds.width - limit.width) / 2.0f, bounds.height - limit.height));
                break;
            }
            case TOP_RIGHT: {
                limit.setPosition(new Vector2(bounds.width - limit.width, bounds.height - limit.height));
            }
        }
        float ypos = 0.0f;
        switch (this.alignment) {
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: {
                ypos = bounds.y + limit.height;
                break;
            }
            case MIDDLE_LEFT: 
            case CENTER: 
            case MIDDLE_RIGHT: {
                ypos = bounds.y + (bounds.height + limit.height) / 2.0f;
                break;
            }
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                ypos = bounds.y + bounds.height;
            }
        }
        Iterator<String> jt = this.priority.iterator();
        for (int row = 0; row < count.size(); ++row) {
            float xpos = 0.0f;
            float rowh = ((Float)height.get(row)).floatValue();
            switch (this.alignment) {
                case BOTTOM_LEFT: 
                case MIDDLE_LEFT: 
                case TOP_LEFT: {
                    xpos = bounds.x;
                    break;
                }
                case BOTTOM_CENTER: 
                case CENTER: 
                case TOP_CENTER: {
                    xpos = bounds.x + (bounds.width - ((Float)width.get(row)).floatValue()) / 2.0f;
                    break;
                }
                case BOTTOM_RIGHT: 
                case MIDDLE_RIGHT: 
                case TOP_RIGHT: {
                    xpos = bounds.x + bounds.width - ((Float)width.get(row)).floatValue();
                }
            }
            for (int col = 0; col < (Integer)count.get(row); ++col) {
                String key = jt.next();
                SceneNode child = node.getChildByName(key);
                if (child == null) continue;
                Vector2 tmp = child.getSize();
                float padLeft = 0.0f;
                float padRight = 0.0f;
                float padBottom = 0.0f;
                float padTop = 0.0f;
                Entry entry = this.entries.get(key);
                if (entry != null) {
                    padLeft = entry.padLeft;
                    padRight = entry.padRight;
                    padBottom = entry.padBottom;
                    padTop = entry.padTop;
                }
                switch (this.alignment) {
                    case BOTTOM_LEFT: 
                    case BOTTOM_CENTER: 
                    case BOTTOM_RIGHT: {
                        child.setAnchor(ANCHOR_BOTTOM_LEFT);
                        child.setPosition(xpos + padLeft, ypos - rowh + padBottom);
                        break;
                    }
                    case MIDDLE_LEFT: 
                    case CENTER: 
                    case MIDDLE_RIGHT: {
                        child.setAnchor(ANCHOR_MIDDLE_LEFT);
                        child.setPosition(xpos + padLeft, ypos - rowh / 2.0f + (padBottom - padTop) / 2.0f);
                        break;
                    }
                    case TOP_LEFT: 
                    case TOP_CENTER: 
                    case TOP_RIGHT: {
                        child.setAnchor(ANCHOR_TOP_LEFT);
                        child.setPosition(xpos + padLeft, ypos - padTop);
                    }
                }
                xpos += tmp.x + padLeft + padRight;
            }
            ypos -= ((Float)height.get(row)).floatValue();
        }
    }

    public void layoutVertical(SceneNode node) {
        this.prioritize();
        Rectangle bounds = node.getLayoutBounds();
        Rectangle limit = new Rectangle();
        ArrayList<Float> height = new ArrayList<Float>();
        ArrayList<Float> width = new ArrayList<Float>();
        ArrayList<Integer> count = new ArrayList<Integer>();
        width.add(Float.valueOf(0.0f));
        height.add(Float.valueOf(0.0f));
        count.add(0);
        boolean stop = false;
        for (String childName : this.priority) {
            if (stop) break;
            SceneNode child = node.getChildByName(childName);
            if (child == null) continue;
            Vector2 extra = child.getSize();
            Entry entry = this.entries.get(childName);
            if (entry != null) {
                extra.x += entry.padLeft + entry.padRight;
                extra.y += entry.padTop + entry.padBottom;
            }
            if (extra.y > bounds.height) {
                stop = true;
                continue;
            }
            if (((Float)height.get(height.size() - 1)).floatValue() + extra.y > bounds.height) {
                if (((Float)width.get(width.size() - 1)).floatValue() + extra.x > bounds.width) {
                    stop = true;
                    continue;
                }
                limit.height = Math.max(limit.height, ((Float)height.get(height.size() - 1)).floatValue());
                limit.width += ((Float)width.get(width.size() - 1)).floatValue();
                width.add(Float.valueOf(extra.x));
                height.add(Float.valueOf(extra.y));
                count.add(1);
                continue;
            }
            height.set(height.size() - 1, Float.valueOf(((Float)height.get(height.size() - 1)).floatValue() + extra.y));
            width.set(width.size() - 1, Float.valueOf(Math.max(extra.x, ((Float)width.get(width.size() - 1)).floatValue())));
            count.set(count.size() - 1, (Integer)count.get(count.size() - 1) + 1);
        }
        limit.height = Math.max(limit.height, ((Float)height.get(height.size() - 1)).floatValue());
        limit.width += ((Float)width.get(width.size() - 1)).floatValue();
        switch (this.alignment) {
            case BOTTOM_LEFT: {
                limit.setPosition(ZERO);
                break;
            }
            case BOTTOM_CENTER: {
                limit.setPosition(new Vector2((bounds.width - limit.width) / 2.0f, 0.0f));
                break;
            }
            case BOTTOM_RIGHT: {
                limit.setPosition(new Vector2(bounds.width - limit.width / 2.0f, 0.0f));
                break;
            }
            case MIDDLE_LEFT: {
                limit.setPosition(new Vector2(0.0f, (bounds.height - limit.height) / 2.0f));
                break;
            }
            case CENTER: {
                limit.setPosition(new Vector2((bounds.width - limit.width) / 2.0f, (bounds.height - limit.height) / 2.0f));
                break;
            }
            case MIDDLE_RIGHT: {
                limit.setPosition(new Vector2(bounds.width - limit.width, (bounds.height - limit.height) / 2.0f));
                break;
            }
            case TOP_LEFT: {
                limit.setPosition(new Vector2(0.0f, bounds.height - limit.height));
                break;
            }
            case TOP_CENTER: {
                limit.setPosition(new Vector2((bounds.width - limit.width) / 2.0f, bounds.height - limit.height));
                break;
            }
            case TOP_RIGHT: {
                limit.setPosition(new Vector2(bounds.width - limit.width, bounds.height - limit.height));
            }
        }
        float xpos = 0.0f;
        switch (this.alignment) {
            case BOTTOM_LEFT: 
            case MIDDLE_LEFT: 
            case TOP_LEFT: {
                xpos = 0.0f;
                break;
            }
            case BOTTOM_CENTER: 
            case CENTER: 
            case TOP_CENTER: {
                xpos = bounds.x + (bounds.width - limit.width) / 2.0f;
                break;
            }
            case BOTTOM_RIGHT: 
            case MIDDLE_RIGHT: 
            case TOP_RIGHT: {
                xpos = bounds.x + bounds.width - limit.width;
            }
        }
        Iterator<String> jt = this.priority.iterator();
        for (int col = 0; col < count.size(); ++col) {
            float ypos = 0.0f;
            float colw = ((Float)width.get(col)).floatValue();
            switch (this.alignment) {
                case BOTTOM_LEFT: 
                case BOTTOM_CENTER: 
                case BOTTOM_RIGHT: {
                    ypos = ((Float)height.get(col)).floatValue();
                    break;
                }
                case MIDDLE_LEFT: 
                case CENTER: 
                case MIDDLE_RIGHT: {
                    ypos = bounds.y + (bounds.height + ((Float)height.get(col)).floatValue()) / 2.0f;
                    break;
                }
                case TOP_LEFT: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    ypos = bounds.y + bounds.height;
                }
            }
            for (int row = 0; row < (Integer)count.get(col); ++row) {
                String key = jt.next();
                SceneNode child = node.getChildByName(key);
                if (child == null) continue;
                Vector2 tmp = child.getSize();
                float padLeft = 0.0f;
                float padRight = 0.0f;
                float padBottom = 0.0f;
                float padTop = 0.0f;
                Entry entry = this.entries.get(key);
                if (entry != null) {
                    padLeft = entry.padLeft;
                    padRight = entry.padRight;
                    padBottom = entry.padBottom;
                    padTop = entry.padTop;
                }
                switch (this.alignment) {
                    case BOTTOM_LEFT: 
                    case MIDDLE_LEFT: 
                    case TOP_LEFT: {
                        child.setAnchor(ANCHOR_TOP_LEFT);
                        child.setPosition(xpos + padLeft, ypos - padTop);
                        child.setAnchor(ANCHOR_BOTTOM_LEFT);
                        break;
                    }
                    case BOTTOM_CENTER: 
                    case CENTER: 
                    case TOP_CENTER: {
                        child.setAnchor(ANCHOR_TOP_CENTER);
                        child.setPosition(xpos + colw / 2.0f + (padLeft - padRight) / 2.0f, ypos - padTop);
                        break;
                    }
                    case BOTTOM_RIGHT: 
                    case MIDDLE_RIGHT: 
                    case TOP_RIGHT: {
                        child.setAnchor(ANCHOR_TOP_RIGHT);
                        child.setPosition(xpos + colw - padRight, ypos - padTop);
                    }
                }
                ypos -= tmp.y + padTop + padBottom;
            }
            xpos += colw;
        }
    }

    public void prioritize() {
        Comparator sortrule = (s1, s2) -> {
            Entry a = this.entries.get(s1);
            Entry b = this.entries.get(s2);
            if (a == null) {
                return b == null ? s1.compareTo((String)s2) : 1;
            }
            if (b == null) {
                return -1;
            }
            if (a.priority < 0L) {
                return b.priority < 0L ? Long.compare(b.priority, a.priority) : 1;
            }
            if (b.priority < 0L) {
                return -1;
            }
            return Long.compare(a.priority, b.priority);
        };
        Collections.sort(this.priority, sortrule);
    }

    public static enum Alignment {
        BOTTOM_LEFT,
        MIDDLE_LEFT,
        TOP_LEFT,
        BOTTOM_CENTER,
        CENTER,
        TOP_CENTER,
        BOTTOM_RIGHT,
        MIDDLE_RIGHT,
        TOP_RIGHT;

    }

    protected static class Entry {
        public long priority = 0L;
        public float padLeft = 0.0f;
        public float padRight = 0.0f;
        public float padTop = 0.0f;
        public float padBottom = 0.0f;
    }
}

