/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.Scissor;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.scene2.GeometryUtils;
import edu.cornell.gdiac.scene2.SceneNode;

public class ScrollPane
extends SceneNode {
    private static final float ZOOM_MIN = 0.1f;
    private static final float ZOOM_MAX = 5.0f;
    protected Rectangle interior;
    protected Affine2 paneTransform = new Affine2();
    protected boolean constrained;
    protected boolean reoriented;
    protected boolean simple;
    protected float zoomMin;
    protected float zoomMax;
    protected float zoomAmount;
    protected Scissor paneMask;
    private final Vector2 vectorCacheScroll = new Vector2();
    private final Vector2 vectorCacheScroll1 = new Vector2();
    private final Affine2 affine2CacheScroll = new Affine2();
    private final Rectangle rectCacheScroll = new Rectangle();
    private final Color colorCacheScroll = new Color();
    private final Scissor scissorCacheScroll = new Scissor();

    private void init() {
        this.paneTransform.idt();
        this.zoomMin = 0.1f;
        this.zoomMax = 5.0f;
        this.zoomAmount = 1.0f;
        this.reoriented = false;
        this.paneMask = null;
        this.simple = true;
        this.classname = "ScrollPane";
    }

    public ScrollPane(Vector2 size) {
        this.init();
        super.set(size);
        this.interior = new Rectangle(0.0f, 0.0f, size.x, size.y);
        this.constrained = false;
        this.paneMask = null;
    }

    public ScrollPane(float width, float height) {
        this(new Vector2(width, height));
    }

    public ScrollPane(Rectangle rect) {
        super(rect);
        this.init();
        this.interior = new Rectangle(rect.x, rect.y, rect.getWidth(), rect.getHeight());
        this.constrained = false;
        this.paneMask = null;
    }

    public ScrollPane(float x, float y, float width, float height) {
        this(new Rectangle(x, y, width, height));
    }

    public ScrollPane(Vector2 size, Rectangle interior, boolean mask) {
        this.init();
        super.set(size);
        this.interior = new Rectangle(interior.x, interior.y, interior.getWidth(), interior.getHeight());
        this.constrained = true;
        this.resetPane();
        this.setMasked(mask);
    }

    public ScrollPane(Rectangle bounds, Rectangle interior, boolean mask) {
        super(bounds);
        this.interior = new Rectangle(interior.x, interior.y, interior.getWidth(), interior.getHeight());
        this.constrained = true;
        this.resetPane();
        this.setMasked(mask);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScrollPane(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        this.init();
        if (data.has("interior")) {
            JsonValue rect = data.get("interior");
            if (rect.size == 2) {
                this.interior.width = rect.get(0).asFloat();
                this.interior.height = rect.get(1).asFloat();
            } else {
                if (rect.size != 4) throw new IllegalArgumentException("'interior' must be a two or four element number array");
                this.interior.x = rect.get(0).asFloat();
                this.interior.y = rect.get(1).asFloat();
                this.interior.width = rect.get(2).asFloat();
                this.interior.height = rect.get(3).asFloat();
            }
        } else {
            Vector2 size = this.getSize(this.vectorCacheScroll);
            this.interior.setSize(size.x, size.y);
        }
        this.constrained = data.getBoolean("constrain", true);
        this.setMasked(data.getBoolean("mask", false));
        this.setMinZoom(data.getFloat("zoom min", 0.1f));
        this.setMaxZoom(data.getFloat("zoom max", 5.0f));
        Vector2 pan = new Vector2();
        if (data.has("pan")) {
            JsonValue pos = data.get("pan");
            if (pos.size != 2) throw new IllegalArgumentException("'pan' must be a two element number array");
            pan.x = pos.get(0).asFloat();
            pan.y = pos.get(1).asFloat();
        }
        float zoom = data.getFloat("zoom", 1.0f);
        zoom = Math.max(zoom, this.zoomMin);
        zoom = Math.min(zoom, this.zoomMax);
        float spin = data.getFloat("spin", 0.0f);
        this.applySpin(spin);
        this.applyZoom(zoom);
        this.applyPan(pan);
        if (!this.constrained) return;
        Affine2 inverse = new Affine2(this.paneTransform).inv();
        Rectangle viewport = new Rectangle(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight());
        boolean valid = true;
        for (int i = 0; i < 4 && valid; ++i) {
            Vector2 corner = new Vector2();
            GeometryUtils.rectCorner(viewport, i, corner);
            Vector2 shifted = new Vector2(corner);
            inverse.applyTo(shifted);
            if (!(shifted.x < this.interior.getX() || shifted.x > this.interior.getX() + this.interior.getWidth() || shifted.y < this.interior.getY()) && !(shifted.y > this.interior.getY() + this.interior.getHeight())) continue;
            valid = false;
        }
        this.constrained = valid;
    }

    @Override
    public Affine2 getNodeToWorldTransform(Affine2 result) {
        result.set(this.combined);
        result.preMul(this.paneTransform);
        if (this.parent != null) {
            result.preMul(this.parent.getNodeToWorldTransform());
        }
        return result;
    }

    @Override
    public boolean inContentBounds(Vector2 point) {
        Vector2 local = this.vectorCacheScroll;
        this.paneTransform.applyTo(this.screenToNodeCoords(point, local));
        if (this.rectCacheScroll.set(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight()).contains(local)) {
            if (this.parent != null) {
                return this.parent.inContentBounds(point);
            }
            return true;
        }
        return false;
    }

    public Rectangle getInterior() {
        return this.interior;
    }

    public void setInterior(Rectangle bounds) {
        this.interior.set(bounds);
        if (this.layout != null) {
            this.doLayout();
        }
        this.resetPane();
    }

    @Override
    public Rectangle getLayoutBounds(Rectangle result) {
        result.set(this.interior);
        return result;
    }

    @Override
    public Rectangle getLayoutBounds() {
        return new Rectangle(this.interior);
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public boolean setConstrained(boolean value) {
        boolean oldVal = this.constrained;
        this.constrained = value;
        if (value && value != oldVal) {
            this.resetPane();
        }
        return oldVal != value;
    }

    public boolean isMasked() {
        return this.paneMask != null;
    }

    public void setMasked(boolean value) {
        this.paneMask = value ? new Scissor(new Rectangle(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight()), 0.5f) : null;
    }

    public float getZoom() {
        return this.zoomAmount;
    }

    public float getMinZoom() {
        return this.zoomMin;
    }

    public boolean setMinZoom(float value) {
        if (value <= 0.0f) {
            throw new IllegalArgumentException("Minimum zoom must be positive");
        }
        if (value < this.zoomAmount) {
            this.zoomMin = value;
            return true;
        }
        return false;
    }

    public float getMaxZoom() {
        return this.zoomMax;
    }

    public boolean setMaxZoom(float value) {
        if (value > this.zoomAmount) {
            this.zoomMax = value;
            return true;
        }
        return false;
    }

    public Affine2 getPaneTransform() {
        return this.paneTransform;
    }

    public Vector2 applyPan(Vector2 delta) {
        this.reoriented = true;
        Vector2 result = delta;
        if (this.constrained) {
            Rectangle view = this.rectCacheScroll.set(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight());
            if (this.simple) {
                result = GeometryUtils.clampPan1(view, this.interior, this.paneTransform, delta, this.vectorCacheScroll);
                this.paneTransform.preTranslate(result);
            } else {
                result = GeometryUtils.clampPan2(view, this.interior, this.paneTransform, delta, this.vectorCacheScroll);
                this.paneTransform.preTranslate(result);
            }
        } else {
            this.paneTransform.preTranslate(delta);
        }
        return result;
    }

    public Vector2 applyPan(float dx, float dy) {
        return this.applyPan(this.vectorCacheScroll1.set(dx, dy));
    }

    public float applySpin(float angle) {
        this.reoriented = true;
        this.simple = false;
        Vector2 center = this.vectorCacheScroll.set(this.anchor).scl(this.getContentSize());
        if (this.constrained) {
            Rectangle view = this.rectCacheScroll.set(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight());
            angle = GeometryUtils.clampSpin(view, this.interior, this.paneTransform, center, angle);
        }
        this.paneTransform.preTranslate(-center.x, -center.y);
        this.paneTransform.preRotate(angle);
        this.paneTransform.preTranslate(center.x, center.y);
        return angle;
    }

    public float applyZoom(float scale) {
        float totalZoom;
        this.reoriented = true;
        this.simple = false;
        Vector2 center = this.vectorCacheScroll.set(this.anchor).scl(this.getContentSize());
        if (this.constrained) {
            Rectangle view = this.rectCacheScroll.set(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight());
            scale = GeometryUtils.clampZoom(view, this.interior, this.paneTransform, center, scale);
        }
        if ((totalZoom = this.zoomAmount * scale) < this.zoomMin) {
            scale = this.zoomMin / this.zoomAmount;
        } else if (totalZoom > this.zoomMax) {
            scale = this.zoomMax / this.zoomAmount;
        }
        this.zoomAmount *= scale;
        this.paneTransform.preTranslate(-center.x, -center.y);
        this.paneTransform.preScale(scale, scale);
        this.paneTransform.preTranslate(center.x, center.y);
        return scale;
    }

    public void resetPane() {
        this.paneTransform.idt();
        if (this.interior.getWidth() < this.getContentWidth() || this.interior.getHeight() < this.getContentHeight()) {
            this.constrained = false;
        } else if (this.constrained) {
            Vector2 offset = this.vectorCacheScroll;
            if (this.interior.getX() > 0.0f) {
                offset.x = -this.interior.getX();
            } else if (this.interior.getX() + this.interior.getWidth() < this.getContentWidth()) {
                offset.x = this.getContentWidth() - this.interior.getX() - this.interior.getWidth();
            }
            if (this.interior.getY() > 0.0f) {
                offset.y = -this.interior.getY();
            } else if (this.interior.getY() + this.interior.getHeight() < this.getContentHeight()) {
                offset.y = this.getContentHeight() - this.interior.getY() - this.interior.getHeight();
            }
            this.paneTransform.translate(offset);
        }
    }

    @Override
    public void render(SpriteBatch batch, Affine2 transform, Color tint) {
        Scissor local;
        if (!this.isVisible()) {
            return;
        }
        Affine2 matrix = this.affine2CacheScroll.set(this.combined).preMul(transform);
        this.colorCacheScroll.set(this.tintColor);
        if (this.hasParentColor) {
            this.colorCacheScroll.mul(tint);
        }
        Scissor active = batch.getScissor();
        if (this.paneMask != null) {
            local = this.scissorCacheScroll.set(this.paneMask);
            local.mul(matrix);
            if (active != null) {
                local.intersect(active);
            }
            batch.setScissor(local);
        } else if (this.scissor != null) {
            local = this.scissorCacheScroll.set(this.scissor);
            local.mul(matrix);
            if (active != null) {
                local.intersect(active);
            }
            batch.setScissor(local);
        }
        this.draw(batch, matrix, this.colorCacheScroll);
        matrix.mul(this.paneTransform);
        for (SceneNode child : this.children) {
            child.render(batch, matrix, this.colorCacheScroll);
        }
        if (this.scissor != null || this.paneMask != null) {
            batch.setScissor(active);
        }
    }
}

