/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.scene2.CameraHelper;
import edu.cornell.gdiac.scene2.SceneNode;
import java.util.ArrayList;
import java.util.List;

public class Scene
extends InputMultiplexer {
    protected Camera camera;
    protected String name;
    protected Vector2 size;
    protected boolean active;
    protected SpriteBatch batch;
    protected List<SceneNode> children = new ArrayList<SceneNode>();
    protected Color color;
    protected InputProcessor userInputProcessor;
    protected int blendEquation;
    protected int srcFactor;
    protected int dstFactor;
    private static Vector3 cacheCoords1 = new Vector3();
    private static Vector2 cacheCoords2 = new Vector2();
    private static Rectangle cacheViewport = new Rectangle();
    private Affine2 cacheAffine = new Affine2();

    public Scene() {
        this.name = "";
        this.size = new Vector2();
        this.size.x = Gdx.graphics.getWidth();
        this.size.y = Gdx.graphics.getHeight();
        this.camera = new OrthographicCamera(this.size.x, this.size.y);
        this.camera.position.set(this.size.x / 2.0f, this.size.y / 2.0f, 0.0f);
        this.camera.update();
        this.active = true;
        this.color = Color.WHITE;
        this.blendEquation = 32774;
        this.srcFactor = 770;
        this.dstFactor = 771;
        this.createAndSetUIInputProcessor();
    }

    public Scene(Vector2 hint) {
        if (hint.x < 0.0f || hint.y < 0.0f) {
            System.err.printf("Size hint (%f,%f) must be nonnegative%n", Float.valueOf(hint.x), Float.valueOf(hint.y));
            return;
        }
        this.name = "";
        this.size = new Vector2();
        this.size.x = Gdx.graphics.getWidth();
        this.size.y = Gdx.graphics.getHeight();
        this.color = Color.WHITE;
        this.blendEquation = 32774;
        this.srcFactor = 770;
        this.dstFactor = 771;
        if (hint.x == 0.0f && hint.y == 0.0f) {
            return;
        }
        if (hint.x > 0.0f && hint.y > 0.0f) {
            Input.Orientation orientation = Gdx.input.getNativeOrientation();
            if (orientation == Input.Orientation.Portrait) {
                hint.y = 0.0f;
            } else {
                hint.x = 0.0f;
            }
        }
        this.size = hint.x > 0.0f ? this.size.scl(hint.x / this.size.y) : this.size.scl(hint.y / this.size.y);
        this.camera = new OrthographicCamera(this.size.x, this.size.y);
        this.active = true;
        this.createAndSetUIInputProcessor();
    }

    public Scene(float width, float height) {
        this(new Vector2(width, height));
    }

    public void dispose() {
        this.batch.dispose();
        this.camera = null;
        this.active = false;
        this.size.x = 0.0f;
        this.size.y = 0.0f;
        this.name = "";
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append(verbose ? "Scene(name:" : "(name:");
        sb.append(this.name).append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Vector2 getSize() {
        if (this.camera == null) {
            return this.size;
        }
        return new Vector2(this.camera.viewportWidth, this.camera.viewportHeight);
    }

    public void getSize(Vector2 size) {
        if (this.camera == null) {
            this.size.x = size.x;
            this.size.y = size.y;
        } else {
            this.size.x = this.camera.viewportWidth;
            this.size.y = this.camera.viewportHeight;
        }
    }

    public Rectangle getBounds() {
        return this.camera == null ? new Rectangle(0.0f, 0.0f, this.size.x, this.size.y) : new Rectangle(this.camera.position.x, this.camera.position.y, this.camera.viewportWidth, this.camera.viewportHeight);
    }

    public void setUserInputProcessor(InputProcessor processor) {
        if (processor == this.userInputProcessor) {
            return;
        }
        if (this.userInputProcessor != null) {
            this.removeProcessor(this.userInputProcessor);
        }
        this.userInputProcessor = processor;
        if (processor != null) {
            this.addProcessor(processor);
        }
    }

    public Vector3 screenToWorldCoords(Vector2 screenCoords) {
        return this.camera == null ? new Vector3(screenCoords.x, screenCoords.y, 0.0f) : this.camera.unproject(CameraHelper.screenToWindowCoords(screenCoords, cacheCoords1));
    }

    public Vector2 worldToScreenCoords(Vector3 worldCoords) {
        if (this.camera == null) {
            return new Vector2(worldCoords.x, worldCoords.y);
        }
        return CameraHelper.windowToScreenCoords(this.camera.project(worldCoords), cacheCoords2);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
        if (value) {
            Gdx.input.setInputProcessor((InputProcessor)this);
        } else {
            Gdx.input.setInputProcessor(null);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public SceneNode getChild(int pos) {
        if (pos >= this.children.size()) {
            throw new IndexOutOfBoundsException("Position index out of bounds");
        }
        return this.children.get(pos);
    }

    public SceneNode getChildByTag(int tag) {
        for (SceneNode child : this.children) {
            if (child.getTag() != tag) continue;
            return child;
        }
        return null;
    }

    public SceneNode getChildByName(String name) {
        for (SceneNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public List<SceneNode> getChildren() {
        return this.children;
    }

    public void addChild(SceneNode child) {
        if (child.childOffset != -1 || child.graph != null) {
            throw new IllegalArgumentException("The child is already in a scene graph");
        }
        child.childOffset = this.children.size();
        this.children.add(child);
        child.setParent(null);
        child.pushScene(this);
    }

    void addChildWithTag(SceneNode child, int tag) {
        this.addChild(child);
        child.tag = tag;
    }

    void addChildWithName(SceneNode child, String name) {
        this.addChild(child);
        child.name = name;
    }

    public void swapChild(SceneNode child1, SceneNode child2, boolean inherit) {
        int index = child1.childOffset;
        this.children.set(index, child2);
        child2.childOffset = index;
        child2.setParent(null);
        child1.setParent(null);
        child2.pushScene(this);
        child1.pushScene(null);
        if (inherit) {
            List<SceneNode> grandchildren = child1.getChildren();
            child1.removeAllChildren();
            for (SceneNode grandchild : grandchildren) {
                child2.addChild(grandchild);
            }
        }
    }

    public void removeChild(int pos) {
        if (pos >= this.children.size()) {
            throw new IndexOutOfBoundsException("Position index out of bounds");
        }
        SceneNode child = this.children.get(pos);
        child.setParent(null);
        child.pushScene(null);
        child.childOffset = -1;
        for (int i = pos; i < this.children.size() - 1; ++i) {
            this.children.set(i, this.children.get(i + 1));
            this.children.get((int)i).childOffset = i;
        }
        this.children.remove(this.children.size() - 1);
    }

    public void removeChild(SceneNode child) {
        if (this.children.get(child.childOffset) != child) {
            throw new IllegalArgumentException("The child is not in this scene graph");
        }
        this.removeChild(child.childOffset);
    }

    public void removeChildByTag(int tag) {
        SceneNode child = this.getChildByTag(tag);
        if (child != null) {
            this.removeChild(child.childOffset);
        }
    }

    public void removeChildByName(String name) {
        SceneNode child = this.getChildByName(name);
        if (child != null) {
            this.removeChild(child.childOffset);
        }
    }

    public void removeAllChildren() {
        for (SceneNode child : this.children) {
            child.setParent(null);
            child.childOffset = -1;
            child.pushScene(null);
        }
        this.children.clear();
    }

    public SpriteBatch getSpriteBatch() {
        return this.batch;
    }

    public void setSpriteBatch(SpriteBatch batch) {
        this.batch = batch;
    }

    public void render() {
        if (this.batch == null) {
            return;
        }
        if (this.batch.isDrawing()) {
            this.batch.end();
        }
        this.batch.begin();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.setBlendSrcFunc(this.srcFactor);
        this.batch.setBlendDstFunc(this.dstFactor);
        this.batch.setBlendEquation(this.blendEquation);
        this.cacheAffine.idt();
        for (SceneNode child : this.children) {
            child.render(this.batch, this.cacheAffine, this.color);
        }
        this.batch.end();
    }

    private void createAndSetUIInputProcessor() {
        this.addProcessor((InputProcessor)new InputAdapter(){

            public boolean keyDown(int keycode) {
                return Scene.this.children.stream().anyMatch(child -> child.keyDown(keycode));
            }

            public boolean keyUp(int keycode) {
                return Scene.this.children.stream().anyMatch(child -> child.keyUp(keycode));
            }

            public boolean keyTyped(char character) {
                return Scene.this.children.stream().anyMatch(child -> child.keyTyped(character));
            }

            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                return Scene.this.children.stream().anyMatch(child -> child.touchDown(screenX, screenY, pointer, button));
            }

            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                return Scene.this.children.stream().anyMatch(child -> child.touchUp(screenX, screenY, pointer, button));
            }

            public boolean touchDragged(int screenX, int screenY, int pointer) {
                return Scene.this.children.stream().anyMatch(child -> child.touchDragged(screenX, screenY, pointer));
            }

            public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
                return Scene.this.children.stream().anyMatch(child -> child.touchCancelled(screenX, screenY, pointer, button));
            }

            public boolean mouseMoved(int screenX, int screenY) {
                return Scene.this.children.stream().anyMatch(child -> child.mouseMoved(screenX, screenY));
            }

            public boolean scrolled(float amountX, float amountY) {
                return Scene.this.children.stream().anyMatch(child -> child.scrolled(amountX, amountY));
            }
        });
        Gdx.input.setInputProcessor((InputProcessor)this);
    }
}

