/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class GeometryUtils {
    private static final float EPSILON = 0.001f;
    private static final Vector2 vector2Cache1 = new Vector2();
    private static final Vector2 vector2Cache2 = new Vector2();
    private static final Vector2 vector2Cache3 = new Vector2();
    private static final Vector2 vector2Cache4 = new Vector2();
    private static final Vector2 vector2Cache5 = new Vector2();
    private static final Vector2 vector2Cache6 = new Vector2();
    private static final Vector2 vector2Cache7 = new Vector2();
    private static final Affine2 affineCache = new Affine2();
    private static Vector2[] vectorArrayCache = new Vector2[8];

    private GeometryUtils() {
    }

    public static Vector2 rectCorner(Rectangle rect, int pos, Vector2 corner) {
        if ((pos %= 4) < 0) {
            pos += 4;
        }
        corner.set(vector2Cache1.set(rect.x, rect.y));
        if (pos > 0 && pos < 3) {
            corner.x += rect.getWidth();
        }
        if (pos > 1) {
            corner.y += rect.getHeight();
        }
        return corner;
    }

    public static boolean orthoProj(Vector2 p, Vector2 a, Vector2 b) {
        float d;
        Vector2 c = vector2Cache1.set(b).sub(a);
        if (c.isZero()) {
            return false;
        }
        Vector2 q = vector2Cache2.set(p).sub(a);
        float n = q.dot(c);
        if (n / (d = c.dot(c)) > 1.0f || n / d < 0.0f) {
            return false;
        }
        p.set(c.scl(n / d).add(a));
        return true;
    }

    public static boolean lineIntersect(Vector2 A, Vector2 B, Vector2 C, Vector2 D, Vector2 res) {
        if (A.x == B.x && A.y == B.y || C.x == D.x && C.y == D.y) {
            return false;
        }
        float denom = vector2Cache6.set(B).sub(A).crs(vector2Cache7.set(D).sub(C));
        if (denom == 0.0f) {
            return false;
        }
        res.x = vector2Cache6.set(D).sub(C).crs(vector2Cache7.set(A).sub(C)) / denom;
        res.y = vector2Cache6.set(B).sub(A).crs(vector2Cache7.set(A).sub(C)) / denom;
        return true;
    }

    public static boolean rayIntersect(Vector2 p, Vector2 q, Vector2 u, Vector2 v, Vector2 out) {
        GeometryUtils.lineIntersect(p, q, u, v, out);
        float s = out.x;
        float t = out.y;
        if ((double)s >= 0.0 && (double)s <= 1.0 && t >= 0.0f) {
            out.set(p).add(vector2Cache6.set(q).sub(p).scl(s));
            return true;
        }
        return false;
    }

    public static boolean tangents(Vector2 center, float radius, Vector2 p, Vector2 u, Vector2 v) {
        Vector2 delta = vector2Cache4.set(p).sub(center);
        float dxr = -delta.y;
        float dyr = delta.x;
        float d = delta.len();
        if (d >= radius) {
            float rho = radius / d;
            float ad = rho * rho;
            float bd = rho * (float)Math.sqrt(1.0f - rho * rho);
            u.set(center.x + ad * delta.x + bd * dxr, center.y + ad * delta.x + bd * dyr);
            v.set(center.x + ad * delta.x - bd * dxr, center.y + ad * delta.y - bd * dyr);
            return true;
        }
        return false;
    }

    public static float segAngle(Vector2 p, Vector2 q, Vector2 c, float sgn) {
        float angle;
        Vector2 temp = vector2Cache4.set(p).sub(c);
        float a = (float)Math.atan2(temp.y, temp.x);
        temp = vector2Cache4.set(q).sub(c);
        float b = (float)Math.atan2(temp.y, temp.x);
        if (sgn > 0.0f) {
            while ((double)angle >= Math.PI * 2) {
                angle -= (float)Math.PI * 2;
            }
            while (angle < 0.0f) {
                angle += (float)Math.PI * 2;
            }
        } else {
            for (angle = b - a; angle >= 0.0f; angle -= (float)Math.PI * 2) {
            }
            while ((double)angle < Math.PI * -2) {
                angle += (float)Math.PI * 2;
            }
        }
        return angle;
    }

    public static float clampSpin(Rectangle viewport, Rectangle contents, Affine2 transform, Vector2 anchor, float angle) {
        float result = angle;
        float maxRadius = 0.0f;
        for (int i = 0; i < 4; ++i) {
            Vector2 corner = GeometryUtils.rectCorner(viewport, i, vector2Cache1);
            float distance = corner.dst(anchor);
            if (!(distance > maxRadius)) continue;
            maxRadius = distance;
        }
        Vector2[] exclude = vectorArrayCache;
        Vector2 a = GeometryUtils.rectCorner(contents, 3, vector2Cache1);
        transform.applyTo(a);
        for (int i = 0; i < 4; ++i) {
            int excludeSize = 0;
            Vector2 b = GeometryUtils.rectCorner(contents, i, vector2Cache2);
            transform.applyTo(b);
            Vector2 q = vector2Cache3.set(anchor);
            if (GeometryUtils.orthoProj(q, a, b)) {
                int j;
                float radius = anchor.dst(q);
                if (radius <= maxRadius) {
                    for (j = 0; j < 4; ++j) {
                        Vector2 t2;
                        Vector2 t1;
                        Vector2 corner = GeometryUtils.rectCorner(viewport, j, vector2Cache4);
                        float dist = corner.dst(anchor);
                        if (!(dist >= radius) || !GeometryUtils.tangents(anchor, radius, corner, t1 = vector2Cache5, t2 = vector2Cache6)) continue;
                        exclude[excludeSize++].set(t1);
                        exclude[excludeSize++].set(t2);
                    }
                }
                for (j = 0; j < excludeSize; j += 2) {
                    float t;
                    float s;
                    float u = GeometryUtils.segAngle(q, exclude[j], anchor, result);
                    float v = GeometryUtils.segAngle(q, exclude[j + 1], anchor, result);
                    if (result > 0.0f) {
                        s = Math.min(u, v);
                        t = Math.max(u, v);
                    } else {
                        s = Math.max(u, v);
                        t = Math.min(u, v);
                    }
                    if (Math.abs(s) < 0.001f) {
                        s = 0.0f;
                    }
                    if ((double)Math.abs(t - s) > Math.PI) {
                        if (s == 0.0f && !(t * result < 0.0f)) continue;
                        result = 0.0f;
                        continue;
                    }
                    if (result > 0.0f && result > s) {
                        result = s;
                        continue;
                    }
                    if (!(result < 0.0f) || !(result < s)) continue;
                    result = s;
                }
            }
            a = b;
        }
        return result;
    }

    public static float clampZoom(Rectangle viewport, Rectangle contents, Affine2 transform, Vector2 anchor, float scale) {
        if (scale > 1.0f) {
            return scale;
        }
        float result = scale;
        for (int i = 0; i < 4; ++i) {
            Vector2 v = GeometryUtils.rectCorner(viewport, i, vector2Cache1);
            Vector2 a = GeometryUtils.rectCorner(contents, 3, vector2Cache2);
            transform.applyTo(a);
            for (int j = 0; j < 4; ++j) {
                Vector2 b = GeometryUtils.rectCorner(contents, j, vector2Cache3);
                transform.applyTo(b);
                Vector2 q = vector2Cache4.set(anchor);
                Vector2 p = vector2Cache5;
                if (GeometryUtils.rayIntersect(a, b, q, v, p)) {
                    float r = q.dst(p);
                    float s = q.dst(v);
                    float percent = 0.0f;
                    if (s > 0.0f) {
                        percent = r * result / s;
                    }
                    if (percent == 0.0f || s == 0.0f) {
                        result = 1.0f;
                    } else if (percent < 1.0f) {
                        result = s / r;
                    }
                }
                a = b;
            }
        }
        return result;
    }

    public static Vector2 clampPan1(Rectangle viewport, Rectangle contents, Affine2 transform, Vector2 offset, Vector2 result) {
        result.set(offset);
        Vector2 orig = transform.getTranslation(vector2Cache1);
        Vector2 bl = contents.getPosition(vector2Cache2).add(orig).add(offset);
        Vector2 tr = vector2Cache4.set(bl).add(contents.getSize(vector2Cache3));
        Vector2 vbl = viewport.getPosition(vector2Cache3);
        Vector2 vtr = vector2Cache5.set(vbl).add(viewport.getSize(vector2Cache6));
        if (bl.x > vbl.x) {
            result.x -= bl.x - vbl.x;
        } else if (tr.x < vtr.x) {
            result.x += vtr.x - tr.x;
        }
        if (bl.y > vbl.y) {
            result.y -= bl.y - vbl.y;
        } else if (tr.y < vtr.y) {
            result.y += vtr.y - tr.y;
        }
        return result;
    }

    public static Vector2 clampPan2(Rectangle viewport, Rectangle contents, Affine2 transform, Vector2 offset, Vector2 result) {
        result.set(offset);
        Affine2 inverse = affineCache.set(transform).inv();
        Vector2 shifted = vector2Cache1;
        for (int i = 0; i < 4; ++i) {
            Vector2 corner = GeometryUtils.rectCorner(viewport, i, vector2Cache2);
            shifted.set(corner).sub(result);
            inverse.applyTo(shifted);
            boolean alter = false;
            if (shifted.x < contents.x) {
                shifted.x = contents.x;
                alter = true;
            } else if (shifted.x > contents.x + contents.getWidth()) {
                shifted.x = contents.x + contents.getWidth();
                alter = true;
            }
            if (shifted.y < contents.y) {
                shifted.y = contents.y;
                alter = true;
            } else if (shifted.y > contents.y + contents.getHeight()) {
                shifted.y = contents.y + contents.getHeight();
                alter = true;
            }
            if (!alter) continue;
            Vector2 tempResult = vector2Cache3;
            tempResult.set(shifted);
            transform.applyTo(tempResult);
            result = vector2Cache4.set(corner).sub(tempResult);
        }
        return result;
    }
}

