/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.utils.FloatArray;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.PathFactory;
import edu.cornell.gdiac.math.Poly2;
import edu.cornell.gdiac.math.PolyTriangulator;
import edu.cornell.gdiac.physics2.Obstacle;

public class PolygonObstacle
extends Obstacle {
    protected PolygonShape[] shapes;
    protected Poly2 poly;
    private Fixture[] geoms;
    private Path2[] outlines;

    public Rectangle getBounds() {
        return this.poly.getBounds();
    }

    public Rectangle getBounds(Rectangle rect) {
        return this.poly.getBounds(rect);
    }

    public void setPoints(float[] points) {
        this.setPoints(points, 0, points.length);
    }

    public void setPoints(float[] points, int offset, int length) {
        this.poly.clear();
        PolyTriangulator triangulator = new PolyTriangulator();
        triangulator.set(points, offset, length);
        triangulator.calculate();
        triangulator.getPolygon(this.poly);
        this.markDirty(true);
        triangulator = null;
    }

    public void setPoints(FloatArray points) {
        this.poly.clear();
        PolyTriangulator triangulator = new PolyTriangulator();
        triangulator.set(points);
        triangulator.calculate();
        triangulator.getPolygon(this.poly);
        this.markDirty(true);
        triangulator = null;
    }

    public void setPolygon(Poly2 poly) {
        this.poly.set(poly);
        this.markDirty(true);
    }

    public PolygonObstacle(float[] points) {
        this(points, 0.0f, 0.0f);
    }

    public PolygonObstacle(float[] points, float x, float y) {
        super(x, y);
        assert (points.length % 2 == 0);
        this.poly = new Poly2();
        this.setPoints(points);
        this.initShapes();
    }

    public PolygonObstacle(FloatArray points) {
        this(points, 0.0f, 0.0f);
    }

    public PolygonObstacle(FloatArray points, float x, float y) {
        super(x, y);
        assert (points.size % 2 == 0);
        this.poly = new Poly2();
        this.setPoints(points);
    }

    public PolygonObstacle(Poly2 poly) {
        this(poly, 0.0f, 0.0f);
    }

    public PolygonObstacle(Poly2 poly, float x, float y) {
        super(x, y);
        this.poly = new Poly2();
        this.setPolygon(poly);
    }

    private void initShapes() {
        if (this.poly.indices.size < 3) {
            return;
        }
        int tris = this.poly.indices.size / 3;
        float[] vertices = new float[tris * 6];
        this.shapes = new PolygonShape[tris];
        this.geoms = new Fixture[tris];
        for (int ii = 0; ii < tris; ++ii) {
            for (int jj = 0; jj < 3; ++jj) {
                vertices[6 * ii + 2 * jj] = this.poly.vertices.items[2 * this.poly.indices.items[3 * ii + jj]];
                vertices[6 * ii + 2 * jj + 1] = this.poly.vertices.items[2 * this.poly.indices.items[3 * ii + jj] + 1];
            }
            this.shapes[ii] = new PolygonShape();
            this.shapes[ii].set(vertices, 6 * ii, 6);
        }
        PathFactory pather = new PathFactory();
        this.outlines = pather.makeInteriorTraversal(this.poly);
    }

    @Override
    protected void createFixtures() {
        if (this.body == null) {
            return;
        }
        this.releaseFixtures();
        this.initShapes();
        for (int ii = 0; ii < this.shapes.length; ++ii) {
            this.fixture.shape = this.shapes[ii];
            this.geoms[ii] = this.body.createFixture(this.fixture);
        }
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.geoms != null && this.geoms[0] != null) {
            for (Fixture fix : this.geoms) {
                this.body.destroyFixture(fix);
            }
        }
    }

    @Override
    public void draw(SpriteBatch batch) {
        this.draw(batch, Color.WHITE);
    }

    @Override
    public void draw(SpriteBatch batch, Color color) {
        Vector2 p = this.getPosition();
        this.transform.idt();
        this.transform.preScale(this.units, this.units);
        this.transform.preRotate(this.getAngle());
        this.transform.preTranslate(p.x * this.units, p.y * this.units);
        Color c = batch.getColor();
        batch.setColor(color);
        for (Path2 o : this.outlines) {
            batch.outline(o, this.transform);
        }
        batch.setColor(c);
    }

    @Override
    public void draw(SpriteBatch batch, Affine2 affine) {
        this.draw(batch, Color.WHITE, affine);
    }

    @Override
    public void draw(SpriteBatch batch, Color color, Affine2 affine) {
        Vector2 p = this.getPosition();
        this.transform.set(affine);
        this.transform.preScale(this.units, this.units);
        this.transform.preRotate(this.getAngle());
        this.transform.preTranslate(p.x * this.units, p.y * this.units);
        Color c = batch.getColor();
        batch.setColor(color);
        for (Path2 o : this.outlines) {
            batch.outline(o, this.transform);
        }
        batch.setColor(c);
    }
}

