/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.FloatArray;
import edu.cornell.gdiac.math.Capsule;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;

public class PolyFactory {
    private float DEFAULT_TOLERANCE;
    private float tolerance;

    public PolyFactory(float tol) {
        this.DEFAULT_TOLERANCE = 0.5f;
        this.tolerance = tol;
    }

    public PolyFactory() {
        this.tolerance = this.DEFAULT_TOLERANCE = 0.5f;
    }

    public Poly2 makeTriangle(float ax, float ay, float bx, float by, float cx, float cy) {
        return this.makeTriangle(new Poly2(new float[0]), ax, ay, bx, by, cx, cy);
    }

    public Poly2 makeTriangle(Vector2 a, Vector2 b, Vector2 c) {
        return this.makeTriangle(a.x, a.y, b.x, b.y, c.x, c.y);
    }

    public Poly2 makeTriangle(Poly2 poly, float ax, float ay, float bx, float by, float cx, float cy) {
        int offset = poly.vertices.size / 2;
        int idx = poly.vertices.size;
        poly.vertices.ensureCapacity(6);
        poly.vertices.items[idx++] = ax;
        poly.vertices.items[idx++] = ay;
        poly.vertices.items[idx++] = bx;
        poly.vertices.items[idx++] = by;
        poly.vertices.items[idx++] = cx;
        poly.vertices.items[idx++] = cy;
        poly.vertices.size += 6;
        idx = poly.indices.size;
        poly.indices.ensureCapacity(3);
        poly.indices.items[idx + 1] = (short)(offset + 1);
        if (Path2.orientation(ax, ay, bx, by, cx, cy) >= 0) {
            poly.indices.items[idx] = (short)(offset + 2);
            poly.indices.items[idx + 2] = (short)offset;
        } else {
            poly.indices.items[idx] = (short)offset;
            poly.indices.items[idx + 2] = (short)(offset + 2);
        }
        poly.indices.size += 3;
        return poly;
    }

    public Poly2 makeTriangle(Poly2 poly, Vector2 a, Vector2 b, Vector2 c) {
        return this.makeTriangle(poly, a.x, a.y, b.x, b.y, c.x, c.y);
    }

    public Poly2 makeRect(float x, float y, float w, float h) {
        return this.makeRect(new Poly2(new float[0]), x, y, w, h);
    }

    public Poly2 makeRect(Vector2 origin, Vector2 size) {
        return this.makeRect(origin.x, origin.y, size.x, size.y);
    }

    public Poly2 makeRect(Poly2 poly, float x, float y, float w, float h) {
        int offset = poly.vertices.size / 2;
        int idx = poly.vertices.size;
        poly.vertices.ensureCapacity(8);
        poly.vertices.items[idx++] = x;
        poly.vertices.items[idx++] = y;
        poly.vertices.items[idx++] = x + w;
        poly.vertices.items[idx++] = y;
        poly.vertices.items[idx++] = x + w;
        poly.vertices.items[idx++] = y + h;
        poly.vertices.items[idx++] = x;
        poly.vertices.items[idx++] = y + h;
        poly.vertices.size += 8;
        idx = poly.indices.size;
        poly.indices.ensureCapacity(6);
        poly.indices.items[idx++] = (short)offset;
        poly.indices.items[idx++] = (short)(offset + 1);
        poly.indices.items[idx++] = (short)(offset + 2);
        poly.indices.items[idx++] = (short)(offset + 2);
        poly.indices.items[idx++] = (short)(offset + 3);
        poly.indices.items[idx++] = (short)offset;
        poly.indices.size += 6;
        return poly;
    }

    public Poly2 makeRect(Poly2 poly, Vector2 origin, Vector2 size) {
        return this.makeRect(poly, origin.x, origin.y, size.x, size.y);
    }

    public Poly2 makeNgon(float cx, float cy, float radius, int sides) {
        return this.makeNgon(new Poly2(new float[0]), cx, cy, radius, sides);
    }

    public Poly2 makeNgon(Vector2 center, float radius, int sides) {
        return this.makeNgon(center.x, center.y, radius, sides);
    }

    public Poly2 makeNgon(Poly2 poly, float cx, float cy, float radius, int sides) {
        int i;
        int offset = poly.vertices.size / 2;
        int idx = poly.vertices.size;
        float coef = (float)Math.PI * 2 / (float)sides;
        poly.vertices.ensureCapacity(sides * 2 + 2);
        for (i = 0; i < sides; ++i) {
            float rads = (float)i * coef;
            poly.vertices.items[idx++] = (float)((double)radius * Math.cos(rads) + (double)cx);
            poly.vertices.items[idx++] = (float)((double)radius * Math.sin(rads) + (double)cy);
        }
        poly.vertices.items[idx++] = cx;
        poly.vertices.items[idx++] = cy;
        poly.vertices.size += sides * 2 + 2;
        idx = poly.indices.size;
        poly.indices.ensureCapacity(3 * sides);
        for (i = 0; i < sides - 1; ++i) {
            poly.indices.items[idx++] = (short)(i + offset);
            poly.indices.items[idx++] = (short)(i + offset + 1);
            poly.indices.items[idx++] = (short)(sides + offset);
        }
        poly.indices.items[idx++] = (short)(sides + offset - 1);
        poly.indices.items[idx++] = (short)offset;
        poly.indices.items[idx++] = (short)(sides + offset);
        poly.indices.size += 3 * sides;
        return poly;
    }

    public Poly2 makeNgon(Poly2 poly, Vector2 center, float radius, int sides) {
        return this.makeNgon(poly, center.x, center.y, radius, sides);
    }

    public Poly2 makeEllipse(float cx, float cy, float sx, float sy) {
        return this.makeEllipse(new Poly2(new float[0]), cx, cy, sx, sy);
    }

    public Poly2 makeEllipse(Vector2 center, Vector2 size) {
        return this.makeEllipse(center.x, center.y, size.x, size.y);
    }

    public Poly2 makeEllipse(Poly2 poly, float cx, float cy, float sx, float sy) {
        int i;
        int segments = this.curveSegs(Math.max(sx / 2.0f, sy / 2.0f), (float)Math.PI * 2, this.tolerance);
        float coef = (float)Math.PI * 2 / (float)segments;
        int offset = poly.vertices.size / 2;
        int idx = poly.vertices.size;
        poly.vertices.ensureCapacity(segments * 2 + 2);
        for (i = 0; i < segments; ++i) {
            float rads = (float)i * coef;
            poly.vertices.items[idx++] = (float)((double)(0.5f * sx) * Math.cos(rads) + (double)cx);
            poly.vertices.items[idx++] = (float)((double)(0.5f * sy) * Math.sin(rads) + (double)cy);
        }
        poly.vertices.items[idx++] = cx;
        poly.vertices.items[idx++] = cy;
        poly.vertices.size += segments * 2 + 2;
        idx = poly.indices.size;
        poly.indices.ensureCapacity(3 * segments);
        for (i = 0; i < segments - 1; ++i) {
            poly.indices.items[idx++] = (short)(i + offset);
            poly.indices.items[idx++] = (short)(i + offset + 1);
            poly.indices.items[idx++] = (short)(segments + offset);
        }
        poly.indices.items[idx++] = (short)(segments + offset - 1);
        poly.indices.items[idx++] = (short)offset;
        poly.indices.items[idx++] = (short)(segments + offset);
        poly.indices.size += 3 * segments;
        return poly;
    }

    public Poly2 makeEllipse(Poly2 poly, Vector2 center, Vector2 size) {
        return this.makeEllipse(poly, center.x, center.y, size.x, size.y);
    }

    public Poly2 makeCircle(float cx, float cy, float radius) {
        return this.makeCircle(new Poly2(new float[0]), cx, cy, radius);
    }

    public Poly2 makeCircle(Vector2 center, float radius) {
        return this.makeCircle(center.x, center.y, radius);
    }

    public Poly2 makeCircle(Poly2 poly, float cx, float cy, float radius) {
        return this.makeEllipse(poly, cx, cy, 2.0f * radius, 2.0f * radius);
    }

    public Poly2 makeCircle(Poly2 poly, Vector2 center, float radius) {
        return this.makeCircle(poly, center.x, center.y, radius);
    }

    public Poly2 makeArc(float cx, float cy, float radius, float start, float degrees) {
        return this.makeArc(new Poly2(new float[0]), cx, cy, radius, start, degrees);
    }

    public Poly2 makeArc(Vector2 center, float radius, float start, float degrees) {
        return this.makeArc(center.x, center.y, radius, start, degrees);
    }

    public Poly2 makeArc(Poly2 poly, float cx, float cy, float radius, float start, float degrees) {
        int i;
        int offset = poly.vertices.size / 2;
        int idx = poly.vertices.size;
        int segments = this.curveSegs(radius, degrees * (float)Math.PI / 180.0f, this.tolerance);
        segments = degrees < (float)segments ? (int)degrees : segments;
        float srad = (float)Math.PI / 180 * start;
        float arad = (float)Math.PI / 180 * degrees;
        float coef = arad / (float)segments;
        poly.vertices.ensureCapacity(segments * 2 + 4);
        for (i = 0; i < segments + 1; ++i) {
            float rads = srad + (float)i * coef;
            poly.vertices.items[idx++] = (float)((double)(0.5f * radius) * Math.cos(rads) + (double)cx);
            poly.vertices.items[idx++] = (float)((double)(0.5f * radius) * Math.sin(rads) + (double)cy);
        }
        poly.vertices.items[idx++] = cx;
        poly.vertices.items[idx++] = cy;
        poly.vertices.size += segments * 2 + 4;
        idx = poly.indices.size;
        poly.indices.ensureCapacity(3 * segments + 3);
        for (i = 0; i < segments + 1; ++i) {
            poly.indices.items[idx++] = (short)(i + offset);
            poly.indices.items[idx++] = (short)(i + offset + 1);
            poly.indices.items[idx++] = (short)(segments + offset + 1);
        }
        poly.indices.size += 3 * segments + 3;
        return poly;
    }

    public Poly2 makeArc(Poly2 poly, Vector2 center, float radius, float start, float degrees) {
        return this.makeArc(poly, center.x, center.y, radius, start, degrees);
    }

    public Poly2 makeRoundedRect(float x, float y, float w, float h, float r) {
        return this.makeRoundedRect(new Poly2(new float[0]), x, y, w, h, r);
    }

    public Poly2 makeRoundedRect(Vector2 origin, Vector2 size, float radius) {
        return this.makeRoundedRect(origin.x, origin.y, size.x, size.y, radius);
    }

    public Poly2 makeRoundedRect(Poly2 poly, float x, float y, float w, float h, float r) {
        int i;
        if (r > w / 2.0f) {
            throw new IllegalArgumentException("Radius exceeds width");
        }
        if (r > h / 2.0f) {
            throw new IllegalArgumentException("Radius exceeds height");
        }
        int offset = poly.vertices.size / 2;
        int idx = poly.vertices.size;
        int segments = this.curveSegs(r, (float)Math.PI * 2, this.tolerance);
        float coef = (float)(Math.PI / (double)(2.0f * (float)segments));
        float c1x = w >= 0.0f ? w : 0.0f;
        float c1y = h >= 0.0f ? h : 0.0f;
        float c2x = w >= 0.0f ? 0.0f : w;
        float c2y = h >= 0.0f ? h : 0.0f;
        float c3x = w >= 0.0f ? 0.0f : w;
        float c3y = h >= 0.0f ? 0.0f : h;
        float c4x = w >= 0.0f ? w : 0.0f;
        float c4y = h >= 0.0f ? 0.0f : h;
        poly.vertices.ensureCapacity(segments * 8 + 10);
        float cx = x + c1x - r;
        float cy = y + c1y - r;
        for (i = 0; i <= segments; ++i) {
            poly.vertices.items[idx++] = (float)((double)r * Math.cos((float)i * coef) + (double)cx);
            poly.vertices.items[idx++] = (float)((double)r * Math.sin((float)i * coef) + (double)cy);
        }
        cx = x + c2x + r;
        cy = y + c2y - r;
        for (i = 0; i <= segments; ++i) {
            poly.vertices.items[idx++] = (float)((double)cx - (double)r * Math.sin((float)i * coef));
            poly.vertices.items[idx++] = (float)((double)r * Math.cos((float)i * coef) + (double)cy);
        }
        cx = x + c3x + r;
        cy = y + c3y + r;
        for (i = 0; i <= segments; ++i) {
            poly.vertices.items[idx++] = (float)((double)cx - (double)r * Math.cos((float)i * coef));
            poly.vertices.items[idx++] = (float)((double)cy - (double)r * Math.sin((float)i * coef));
        }
        cx = x + c4x - r;
        cy = y + c4y + r;
        for (i = 0; i <= segments; ++i) {
            poly.vertices.items[idx++] = (float)((double)r * Math.sin((float)i * coef) + (double)cx);
            poly.vertices.items[idx++] = (float)((double)cy - (double)r * Math.cos((float)i * coef));
        }
        cx = x + w / 2.0f;
        cy = y + h / 2.0f;
        poly.vertices.items[idx++] = cx;
        poly.vertices.items[idx++] = cy;
        poly.vertices.size += segments * 8 + 10;
        int capacity = 4 * segments + 4;
        idx = poly.indices.size;
        poly.indices.ensureCapacity(3 * capacity);
        for (int i2 = 0; i2 < capacity - 1; ++i2) {
            poly.indices.items[idx++] = (short)(offset + i2);
            poly.indices.items[idx++] = (short)(offset + i2 + 1);
            poly.indices.items[idx++] = (short)(offset + capacity);
        }
        poly.indices.items[idx++] = (short)(capacity + offset - 1);
        poly.indices.items[idx++] = (short)offset;
        poly.indices.items[idx++] = (short)(capacity + offset);
        poly.indices.size += 3 * capacity;
        return poly;
    }

    public Poly2 makeRoundedRect(Poly2 poly, Vector2 origin, Vector2 size, float radius) {
        return this.makeRoundedRect(poly, origin.x, origin.y, size.x, size.y, radius);
    }

    public Poly2 makeCapsule(float x, float y, float w, float h) {
        return this.makeCapsule(new Poly2(new float[0]), Capsule.FULL, x, y, w, h);
    }

    public Poly2 makeCapsule(Vector2 origin, Vector2 size) {
        return this.makeCapsule(origin.x, origin.y, size.x, size.y);
    }

    public Poly2 makeCapsule(Poly2 poly, float x, float y, float w, float h) {
        return this.makeCapsule(poly, Capsule.FULL, x, y, w, h);
    }

    public Poly2 makeCapsule(Poly2 poly, Vector2 origin, Vector2 size) {
        return this.makeCapsule(poly, origin.x, origin.y, size.x, size.y);
    }

    public Poly2 makeCapsule(Capsule shape, float x, float y, float w, float h) {
        return this.makeCapsule(new Poly2(new float[0]), shape, x, y, w, h);
    }

    public Poly2 makeCapsule(Capsule shape, Vector2 origin, Vector2 size) {
        return this.makeCapsule(shape, origin.x, origin.y, size.x, size.y);
    }

    public Poly2 makeCapsule(Poly2 poly, Capsule shape, float x, float y, float w, float h) {
        int i;
        float rads;
        int i2;
        float radius;
        if (shape == Capsule.DEGENERATE) {
            return this.makeEllipse(poly, x + w / 2.0f, y + h / 2.0f, w, h);
        }
        if (w == h) {
            return this.makeCircle(poly, x + w / 2.0f, y + h / 2.0f, w);
        }
        int segments = this.curveSegs(Math.min(w / 2.0f, h / 2.0f), (float)Math.PI, this.tolerance);
        int offset = poly.vertices.size / 2;
        float coef = (float)(Math.PI / (double)segments);
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        int vCount = 0;
        FloatArray vList = new FloatArray();
        if (w <= h) {
            radius = w / 2.0f;
            float iy = y + radius;
            float ih = h - w;
            if (shape == Capsule.HALF_REVERSE) {
                vList.add(cx - radius);
                vList.add(iy);
                vList.add(cx + radius);
                vList.add(iy);
                vCount += 2;
            } else {
                for (i2 = 0; i2 <= segments; ++i2) {
                    rads = i2 == segments ? (float)Math.PI : (float)i2 * coef;
                    vList.add((float)((double)cx - (double)radius * Math.cos(rads)));
                    vList.add((float)((double)iy - (double)radius * Math.sin(rads)));
                }
                vCount += segments + 1;
            }
            if (shape == Capsule.HALF) {
                vList.add(cx + radius);
                vList.add(iy + ih);
                vList.add(cx - radius);
                vList.add(iy + ih);
                vCount += 2;
            } else {
                for (i2 = 0; i2 <= segments; ++i2) {
                    rads = i2 == segments ? (float)Math.PI : (float)i2 * coef;
                    vList.add((float)((double)cx + (double)radius * Math.cos(rads)));
                    vList.add((float)((double)(iy + ih) + (double)radius * Math.sin(rads)));
                }
                vCount += segments + 1;
            }
        } else {
            radius = h / 2.0f;
            float ix = x + radius;
            float iw = w - h;
            if (shape == Capsule.HALF_REVERSE) {
                vList.add(ix);
                vList.add(cy + radius);
                vList.add(ix);
                vList.add(cy - radius);
                vCount += 2;
            } else {
                for (i2 = 0; i2 <= segments; ++i2) {
                    rads = i2 == segments ? (float)Math.PI : (float)i2 * coef;
                    vList.add((float)((double)ix - (double)radius * Math.sin(rads)));
                    vList.add((float)((double)cy + (double)radius * Math.cos(rads)));
                }
                vCount += segments + 1;
            }
            if (shape == Capsule.HALF) {
                vList.add(ix + iw);
                vList.add(cy - radius);
                vList.add(ix + iw);
                vList.add(cy + radius);
                vCount += 2;
            } else {
                for (i2 = 0; i2 <= segments; ++i2) {
                    rads = i2 == segments ? (float)Math.PI : (float)i2 * coef;
                    vList.add((float)((double)(ix + iw) + (double)radius * Math.sin(rads)));
                    vList.add((float)((double)cy - (double)radius * Math.cos(rads)));
                }
                vCount += segments + 1;
            }
        }
        vList.add(cx);
        vList.add(cy);
        int idx = poly.vertices.size;
        poly.vertices.ensureCapacity(vList.size);
        for (i = 0; i < vList.size; ++i) {
            poly.vertices.items[idx++] = vList.items[i];
        }
        poly.vertices.size += vList.size;
        idx = poly.indices.size;
        poly.indices.ensureCapacity(3 * vCount);
        for (i = 0; i < vCount - 1; ++i) {
            poly.indices.items[idx++] = (short)(offset + i);
            poly.indices.items[idx++] = (short)(offset + i + 1);
            poly.indices.items[idx++] = (short)(offset + vCount);
        }
        poly.indices.items[idx++] = (short)(offset + vCount - 1);
        poly.indices.items[idx++] = (short)offset;
        poly.indices.items[idx++] = (short)(offset + vCount);
        poly.indices.size += 3 * vCount;
        return poly;
    }

    public Poly2 makeCapsule(Poly2 poly, Capsule shape, Vector2 origin, Vector2 size) {
        return this.makeCapsule(poly, shape, origin.x, origin.y, size.x, size.y);
    }

    private int curveSegs(float rad, float arc, float tol) {
        float da = (float)(Math.acos(rad / (rad + tol)) * 2.0);
        return Math.max(2, (int)Math.ceil(arc / da));
    }
}

