/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.design;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;

public class GameCanvas {
    private PolygonSpriteBatch spriteBatch;
    private ShapeRenderer debugRender;
    private DrawPass active = DrawPass.INACTIVE;
    private BlendState blend;
    private OrthographicCamera camera;
    int width;
    int height;
    private Affine2 local;
    private Matrix4 global;
    private Vector2 vertex;
    private TextureRegion holder;

    public GameCanvas() {
        this.spriteBatch = new PolygonSpriteBatch();
        this.debugRender = new ShapeRenderer();
        this.camera = new OrthographicCamera(this.getWidth(), this.getHeight());
        this.camera.setToOrtho(false);
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
        this.debugRender.setProjectionMatrix(this.camera.combined);
        this.holder = new TextureRegion();
        this.local = new Affine2();
        this.global = new Matrix4();
        this.vertex = new Vector2();
    }

    public void dispose() {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot dispose while drawing active", new IllegalStateException());
            return;
        }
        this.spriteBatch.dispose();
        this.spriteBatch = null;
        this.local = null;
        this.global = null;
        this.vertex = null;
        this.holder = null;
    }

    public int getWidth() {
        return Gdx.graphics.getWidth();
    }

    public void setWidth(int width) {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", new IllegalStateException());
            return;
        }
        this.width = width;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(width, this.getHeight());
        }
        this.resize();
    }

    public int getHeight() {
        return Gdx.graphics.getHeight();
    }

    public void setHeight(int height) {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", new IllegalStateException());
            return;
        }
        this.height = height;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(this.getWidth(), height);
        }
        this.resize();
    }

    public Vector2 getSize() {
        return new Vector2(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setSize(int width, int height) {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", new IllegalStateException());
            return;
        }
        this.width = width;
        this.height = height;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(width, height);
        }
        this.resize();
    }

    public boolean isFullscreen() {
        return Gdx.graphics.isFullscreen();
    }

    public void setFullscreen(boolean value, boolean desktop) {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", new IllegalStateException());
            return;
        }
        if (value) {
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
        } else {
            Gdx.graphics.setWindowedMode(this.width, this.height);
        }
    }

    public void resize() {
        this.spriteBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public BlendState getBlendState() {
        return this.blend;
    }

    public void setBlendState(BlendState state) {
        if (state == this.blend) {
            return;
        }
        switch (state) {
            case NO_PREMULT: {
                this.spriteBatch.setBlendFunction(770, 771);
                break;
            }
            case ALPHA_BLEND: {
                this.spriteBatch.setBlendFunction(1, 771);
                break;
            }
            case ADDITIVE: {
                this.spriteBatch.setBlendFunction(770, 1);
                break;
            }
            case OPAQUE: {
                this.spriteBatch.setBlendFunction(1, 0);
            }
        }
        this.blend = state;
    }

    public void clear() {
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16384);
    }

    public void begin(Affine2 affine) {
        this.global.setAsAffine(affine);
        this.global.mulLeft(this.camera.combined);
        this.spriteBatch.setProjectionMatrix(this.global);
        this.setBlendState(BlendState.NO_PREMULT);
        this.spriteBatch.begin();
        this.active = DrawPass.STANDARD;
    }

    public void begin(float sx, float sy) {
        this.global.idt();
        this.global.scl(sx, sy, 1.0f);
        this.global.mulLeft(this.camera.combined);
        this.spriteBatch.setProjectionMatrix(this.global);
        this.spriteBatch.begin();
        this.active = DrawPass.STANDARD;
    }

    public void begin() {
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
        this.spriteBatch.begin();
        this.active = DrawPass.STANDARD;
    }

    public void end() {
        this.spriteBatch.end();
        this.active = DrawPass.INACTIVE;
    }

    public void draw(Texture image, float x, float y) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(image, x, y);
    }

    public void draw(Texture image, Color tint, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(image, x, y, width, height);
    }

    public void draw(Texture image, Color tint, float ox, float oy, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.holder.setRegion(image);
        this.draw(this.holder, tint, x - ox, y - oy, width, height);
    }

    public void draw(Texture image, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.holder.setRegion(image);
        this.draw(this.holder, tint, ox, oy, x, y, angle, sx, sy);
    }

    public void draw(Texture image, Color tint, float ox, float oy, Affine2 transform) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.holder.setRegion(image);
        this.draw(this.holder, tint, ox, oy, transform);
    }

    public void draw(TextureRegion region, float x, float y) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(region, x, y);
    }

    public void draw(TextureRegion region, Color tint, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x, y, width, height);
    }

    public void draw(TextureRegion region, Color tint, float ox, float oy, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x - ox, y - oy, width, height);
    }

    public void draw(TextureRegion region, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.computeTransform(ox, oy, x, y, angle, sx, sy);
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, region.getRegionWidth(), (float)region.getRegionHeight(), this.local);
    }

    public void draw(TextureRegion region, Color tint, float ox, float oy, Affine2 affine) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.local.set(affine);
        this.local.translate(-ox, -oy);
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, region.getRegionWidth(), (float)region.getRegionHeight(), this.local);
    }

    public void draw(PolygonRegion region, float x, float y) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(region, x, y);
    }

    public void draw(PolygonRegion region, Color tint, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x, y, width, height);
    }

    public void draw(PolygonRegion region, Color tint, float ox, float oy, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x - ox, y - oy, width, height);
    }

    public void draw(PolygonRegion region, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        TextureRegion bounds = region.getRegion();
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x, y, ox, oy, (float)bounds.getRegionWidth(), (float)bounds.getRegionHeight(), sx, sy, 180.0f * angle / (float)Math.PI);
    }

    public void draw(PolygonRegion region, Color tint, float ox, float oy, Affine2 affine) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        this.local.set(affine);
        this.local.translate(-ox, -oy);
        this.computeVertices(this.local, region.getVertices());
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, 0.0f, 0.0f);
        this.local.inv();
        this.computeVertices(this.local, region.getVertices());
    }

    private void computeVertices(Affine2 affine, float[] vertices) {
        for (int ii = 0; ii < vertices.length; ii += 2) {
            this.vertex.set(vertices[2 * ii], vertices[2 * ii + 1]);
            affine.applyTo(this.vertex);
            vertices[2 * ii] = this.vertex.x;
            vertices[2 * ii + 1] = this.vertex.y;
        }
    }

    public void drawText(String text, BitmapFont font, float x, float y) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        GlyphLayout layout = new GlyphLayout(font, text);
        font.draw((Batch)this.spriteBatch, layout, x, y);
    }

    public void drawTextCentered(String text, BitmapFont font, float offset) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", new IllegalStateException());
            return;
        }
        GlyphLayout layout = new GlyphLayout(font, text);
        float x = ((float)this.getWidth() - layout.width) / 2.0f;
        float y = ((float)this.getHeight() + layout.height) / 2.0f;
        font.draw((Batch)this.spriteBatch, layout, x, y + offset);
    }

    public void beginDebug(Affine2 affine) {
        this.global.setAsAffine(affine);
        this.global.mulLeft(this.camera.combined);
        this.debugRender.setProjectionMatrix(this.global);
        this.debugRender.begin(ShapeRenderer.ShapeType.Line);
        this.active = DrawPass.DEBUG;
    }

    public void beginDebug(float sx, float sy) {
        this.global.idt();
        this.global.scl(sx, sy, 1.0f);
        this.global.mulLeft(this.camera.combined);
        this.debugRender.setProjectionMatrix(this.global);
        this.debugRender.begin(ShapeRenderer.ShapeType.Line);
        this.active = DrawPass.DEBUG;
    }

    private void computeTransform(float ox, float oy, float x, float y, float angle, float sx, float sy) {
        this.local.setToTranslation(x, y);
        this.local.rotate(180.0f * angle / (float)Math.PI);
        this.local.scale(sx, sy);
        this.local.translate(-ox, -oy);
    }

    public static enum BlendState {
        ALPHA_BLEND,
        NO_PREMULT,
        ADDITIVE,
        OPAQUE;

    }

    private static enum DrawPass {
        INACTIVE,
        STANDARD,
        DEBUG;

    }
}

